/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Resource;
import org.apache.wicket.Response;
import org.apache.wicket.protocol.http.WebResponse;

public abstract class WebResource
extends Resource {
    private static final long serialVersionUID = 1L;

    protected final void configureResponse(Response response) {
        if (response instanceof WebResponse) {
            this.setHeaders((WebResponse)response);
        }
    }

    protected void setHeaders(WebResponse response) {
        if (this.isCacheable()) {
            response.setDateHeader("Expires", System.currentTimeMillis() + (long)this.getCacheDuration() * 1000L);
            response.setHeader("Cache-Control", "max-age=" + this.getCacheDuration());
        } else {
            response.setHeader("Cache-Control", "no-cache, must-revalidate");
        }
    }

    protected int getCacheDuration() {
        return 3600;
    }
}

