/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.version.undo.Change;

public class CheckBoxMultipleChoice
extends ListMultipleChoice {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "<br/>\n";
    static /* synthetic */ Class class$java$lang$String;

    public CheckBoxMultipleChoice(String id) {
        super(id);
    }

    public CheckBoxMultipleChoice(String id, List choices) {
        super(id, choices);
    }

    public CheckBoxMultipleChoice(String id, List choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel model, List choices) {
        super(id, model, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel model, List choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel choices) {
        super(id, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel model, IModel choices) {
        super(id, model, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel model, IModel choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public final CheckBoxMultipleChoice setPrefix(String prefix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange(new PrefixChange(this.prefix));
        }
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public final CheckBoxMultipleChoice setSuffix(String suffix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange(new SuffixChange(this.suffix));
        }
        this.suffix = suffix;
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("multiple");
        tag.remove("size");
        tag.remove("disabled");
        tag.remove("name");
    }

    protected final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer(70 * (choices.size() + 1));
        String selected = this.getValue();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
            Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
            String label = "";
            if (objectClass != null && objectClass != (class$java$lang$String == null ? CheckBoxMultipleChoice.class$("java.lang.String") : class$java$lang$String)) {
                label = this.getConverter(objectClass).convertToString(displayValue, this.getLocale());
            } else if (displayValue != null) {
                label = displayValue.toString();
            }
            if (label == null) continue;
            buffer.append(this.getPrefix());
            String id = this.getChoiceRenderer().getIdValue(choice, index);
            String idAttr = this.getInputName() + "_" + id;
            buffer.append("<input name=\"").append(this.getInputName()).append("\"").append(" type=\"checkbox\"").append(this.isSelected(choice, index, selected) ? " checked=\"checked\"" : "").append(this.isEnabled() ? "" : " disabled=\"disabled\"").append(" value=\"").append(id).append("\" id=\"").append(idAttr).append("\"/>");
            String display = label;
            if (this.localizeDisplayValues()) {
                display = this.getLocalizer().getString(label, (Component)this, label);
            }
            CharSequence escaped = this.isEscapeLabelMarkup() ? Strings.escapeMarkup(display, false, true) : display;
            buffer.append("<label for=\"");
            buffer.append(idAttr);
            buffer.append("\">").append(escaped).append("</label>");
            buffer.append(this.getSuffix());
        }
        this.replaceComponentTagBody(markupStream, openTag, buffer);
    }

    protected boolean isEscapeLabelMarkup() {
        return true;
    }

    private class PrefixChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final String prevPrefix;

        PrefixChange(String prevSuffix) {
            this.prevPrefix = prevSuffix;
        }

        public void undo() {
            CheckBoxMultipleChoice.this.setPrefix(this.prevPrefix);
        }

        public String toString() {
            return "PrefixChange[component: " + CheckBoxMultipleChoice.this.getPath() + ", prefix: " + this.prevPrefix + "]";
        }
    }

    private class SuffixChange
    extends Change {
        private static final long serialVersionUID = 1L;
        final String prevSuffix;

        SuffixChange(String prevSuffix) {
            this.prevSuffix = prevSuffix;
        }

        public void undo() {
            CheckBoxMultipleChoice.this.setSuffix(this.prevSuffix);
        }

        public String toString() {
            return "SuffixChange[component: " + CheckBoxMultipleChoice.this.getPath() + ", suffix: " + this.prevSuffix + "]";
        }
    }
}

