/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.wicket.protocol.http.portlet.WicketResponseState;

public class PortletServletResponseWrapper
extends HttpServletResponseWrapper {
    private WicketResponseState responseState;

    public PortletServletResponseWrapper(HttpServletResponse response, WicketResponseState responseState) {
        super(response);
        this.responseState = responseState;
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        this.responseState.setErrorCode(errorCode);
        this.responseState.setErrorMessage(errorMessage);
    }

    public void sendError(int errorCode) throws IOException {
        this.responseState.setErrorCode(errorCode);
        this.responseState.setErrorMessage(null);
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        this.responseState.setRedirectLocation(redirectLocation);
    }

    public void setStatus(int statusCode) {
        this.responseState.setStatusCode(statusCode);
    }

    public String encodeRedirectUrl(String url) {
        String s = super.encodeRedirectUrl(url);
        return s != null ? s : url;
    }

    public String encodeRedirectURL(String url) {
        String s = super.encodeRedirectURL(url);
        return s != null ? s : url;
    }
}

