/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.string.AppendingStringBuffer;

public final class XmlReader
extends Reader {
    private static final Pattern xmlDecl = Pattern.compile("[\\s\\n\\r]*<\\?xml(\\s+.*)?\\?>");
    private static final Pattern encodingPattern = Pattern.compile("\\s+encoding\\s*=\\s*([\"'](.*?)[\"']|(\\S*)).*\\?>");
    private String encoding;
    private String xmlDeclarationString;
    private final InputStream inputStream;
    private Reader reader;

    public XmlReader(InputStream inputStream, String defaultEncoding) throws IOException {
        this.inputStream = inputStream;
        this.encoding = defaultEncoding;
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter 'inputStream' must not be null");
        }
        this.init();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getXmlDeclaration() {
        return this.xmlDeclarationString;
    }

    public void init() throws IOException {
        if (!this.inputStream.markSupported()) {
            throw new IOException("The InputStream must support mark/reset");
        }
        int readAheadSize = 80;
        this.inputStream.mark(80);
        if (this.getXmlDeclaration(this.inputStream, 80)) {
            this.encoding = this.determineEncoding(this.xmlDeclarationString);
        } else {
            this.inputStream.reset();
        }
        this.reader = this.encoding == null ? new BufferedReader(new InputStreamReader(this.inputStream)) : new BufferedReader(new InputStreamReader(this.inputStream, this.encoding));
    }

    private final String determineEncoding(String string) {
        Matcher matcher = encodingPattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        String encoding = matcher.group(2);
        if (encoding == null || encoding.length() == 0) {
            encoding = matcher.group(3);
        }
        if (encoding != null) {
            encoding = encoding.trim();
        }
        return encoding;
    }

    private final boolean getXmlDeclaration(InputStream in, int readAheadSize) throws IOException {
        Matcher matcher;
        int value;
        AppendingStringBuffer pushBack = new AppendingStringBuffer(readAheadSize);
        while ((value = in.read()) != -1) {
            pushBack.append((char)value);
            if (value != 62 && value != 10 && value != 13 && pushBack.length() < readAheadSize - 1) continue;
        }
        if (!(matcher = xmlDecl.matcher(pushBack)).matches()) {
            return false;
        }
        this.xmlDeclarationString = pushBack.toString().trim();
        return true;
    }

    public void close() throws IOException {
        this.reader.close();
        this.inputStream.close();
    }

    public int read(char[] buf, int from, int to) throws IOException {
        return this.reader.read(buf, from, to);
    }

    public String toString() {
        return this.inputStream.toString() + " (" + this.encoding + ")";
    }
}

