/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.value;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;

public class CopyOnWriteValueMap
implements IValueMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private IValueMap wrapped;

    public CopyOnWriteValueMap(IValueMap wrapped) {
        this.wrapped = wrapped;
    }

    public void clear() {
        this.checkAndCopy();
        this.wrapped.clear();
    }

    private void checkAndCopy() {
        if (this.wrapped.isImmutable()) {
            this.wrapped = new ValueMap((Map)this.wrapped);
        }
    }

    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    public Set entrySet() {
        this.checkAndCopy();
        return this.wrapped.entrySet();
    }

    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    public Object get(Object key) {
        return this.wrapped.get(key);
    }

    public boolean getBoolean(String key) throws StringValueConversionException {
        return this.wrapped.getBoolean(key);
    }

    public CharSequence getCharSequence(String key) {
        return this.wrapped.getCharSequence(key);
    }

    public double getDouble(String key) throws StringValueConversionException {
        return this.wrapped.getDouble(key);
    }

    public double getDouble(String key, double defaultValue) throws StringValueConversionException {
        return this.wrapped.getDouble(key, defaultValue);
    }

    public Duration getDuration(String key) throws StringValueConversionException {
        return this.wrapped.getDuration(key);
    }

    public int getInt(String key, int defaultValue) throws StringValueConversionException {
        return this.wrapped.getInt(key, defaultValue);
    }

    public int getInt(String key) throws StringValueConversionException {
        return this.wrapped.getInt(key);
    }

    public String getKey(String key) {
        return this.wrapped.getKey(key);
    }

    public long getLong(String key, long defaultValue) throws StringValueConversionException {
        return this.wrapped.getLong(key, defaultValue);
    }

    public long getLong(String key) throws StringValueConversionException {
        return this.wrapped.getLong(key);
    }

    public String getString(String key, String defaultValue) {
        return this.wrapped.getString(key, defaultValue);
    }

    public String getString(String key) {
        return this.wrapped.getString(key);
    }

    public String[] getStringArray(String key) {
        return this.wrapped.getStringArray(key);
    }

    public StringValue getStringValue(String key) {
        return this.wrapped.getStringValue(key);
    }

    public Time getTime(String key) throws StringValueConversionException {
        return this.wrapped.getTime(key);
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public boolean isImmutable() {
        return false;
    }

    public Set keySet() {
        this.checkAndCopy();
        return this.wrapped.keySet();
    }

    public IValueMap makeImmutable() {
        return this.wrapped.makeImmutable();
    }

    public Object put(Object key, Object value) {
        this.checkAndCopy();
        return this.wrapped.put(key, value);
    }

    public void putAll(Map map) {
        this.checkAndCopy();
        this.wrapped.putAll(map);
    }

    public Object remove(Object key) {
        this.checkAndCopy();
        return this.wrapped.remove(key);
    }

    public int size() {
        return this.wrapped.size();
    }

    public Collection values() {
        return this.wrapped.values();
    }

    public String toString() {
        return super.toString();
    }
}

