/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.IClusterable;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.ValidationError;

public abstract class AbstractValidator
implements INullAcceptingValidator,
IClusterable {
    private static final long serialVersionUID = 1L;

    public boolean validateOnNullValue() {
        return false;
    }

    protected abstract void onValidate(IValidatable var1);

    public final void validate(IValidatable validatable) {
        if (validatable.getValue() != null || this.validateOnNullValue()) {
            this.onValidate(validatable);
        }
    }

    public void error(IValidatable validatable) {
        this.error(validatable, this.resourceKey(), this.variablesMap(validatable));
    }

    public void error(IValidatable validatable, String resourceKey) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("Argument [[resourceKey]] cannot be null");
        }
        this.error(validatable, resourceKey, this.variablesMap(validatable));
    }

    public void error(IValidatable validatable, Map vars) {
        if (vars == null) {
            throw new IllegalArgumentException("Argument [[vars]] cannot be null");
        }
        this.error(validatable, this.resourceKey(), vars);
    }

    public void error(IValidatable validatable, String resourceKey, Map vars) {
        if (validatable == null) {
            throw new IllegalArgumentException("Argument [[validatable]] cannot be null");
        }
        if (vars == null) {
            throw new IllegalArgumentException("Argument [[vars]] cannot be null");
        }
        if (resourceKey == null) {
            throw new IllegalArgumentException("Argument [[resourceKey]] cannot be null");
        }
        ValidationError error = new ValidationError().addMessageKey(resourceKey);
        String defaultKey = Classes.simpleName(this.getClass());
        if (!resourceKey.equals(defaultKey)) {
            error.addMessageKey(defaultKey);
        }
        error.setVariables(vars);
        validatable.error(error);
    }

    protected String resourceKey() {
        return Classes.simpleName(this.getClass());
    }

    protected Map variablesMap(IValidatable validatable) {
        HashMap resourceModel = new HashMap(1);
        return resourceModel;
    }

    protected final Map messageModel(FormComponent formComponent) {
        throw new UnsupportedOperationException("THIS METHOD IS DEPRECATED, SEE JAVADOC");
    }

    protected final String resourceKey(FormComponent formComponent) {
        throw new UnsupportedOperationException("THIS METHOD IS DEPRECATED, SEE JAVADOC");
    }

    public final void validate(FormComponent component) {
        throw new UnsupportedOperationException("THIS METHOD IS DEPRECATED, SEE JAVADOC");
    }
}

