/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import java.util.HashSet;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.util.NucleusLogger;

public class MetaDataValidator {
    private static final Set<String> ONE_OR_ZERO_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.encoded-pk", "gae.pk-name", "gae.parent-pk");
    private static final Set<String> NOT_PRIMARY_KEY_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.pk-name", "gae.parent-pk");
    private static final Set<String> REQUIRES_ENCODED_STRING_PK_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.pk-name");
    private final AbstractClassMetaData acmd;
    private final MetaDataManager metaDataManager;
    private final ClassLoaderResolver clr;
    private boolean noParentAllowed = false;

    public MetaDataValidator(AbstractClassMetaData acmd, MetaDataManager metaDataManager, ClassLoaderResolver clr) {
        this.acmd = acmd;
        this.metaDataManager = metaDataManager;
        this.clr = clr;
    }

    public void validate() {
        NucleusLogger.METADATA.info((Object)("Performing appengine-specific metadata validation for " + this.acmd.getFullClassName()));
        AbstractMemberMetaData pkMemberMetaData = this.validatePrimaryKey();
        this.validateExtensions(this.acmd, pkMemberMetaData);
        NucleusLogger.METADATA.info((Object)("Finished performing appengine-specific metadata validation for " + this.acmd.getFullClassName()));
    }

    private void validateExtensions(AbstractClassMetaData acmd, AbstractMemberMetaData pkMemberMetaData) {
        HashSet<Object> foundOneOrZeroExtensions = Utils.newHashSet(new Object[0]);
        Class pkClass = pkMemberMetaData.getType();
        for (AbstractMemberMetaData ammd : acmd.getManagedMembers()) {
            for (String extension : ONE_OR_ZERO_EXTENSIONS) {
                if (!ammd.hasExtension(extension) || foundOneOrZeroExtensions.add(extension)) continue;
                throw new DatastoreMetaDataException(acmd, ammd, "Cannot have more than one field with the \"" + extension + "\" extension.");
            }
            if (!(!ammd.hasExtension("gae.encoded-pk") || ammd.isPrimaryKey() && ammd.getType().equals(String.class))) {
                throw new DatastoreMetaDataException(acmd, ammd, "A field with the \"gae.encoded-pk\" extension can only be applied to a String primary key.");
            }
            if (ammd.hasExtension("gae.pk-name") && !ammd.getType().equals(String.class)) {
                throw new DatastoreMetaDataException(acmd, ammd, "\"gae.pk-name\" can only be applied to a String field.");
            }
            if (ammd.hasExtension("gae.pk-id") && !ammd.getType().equals(Long.class)) {
                throw new DatastoreMetaDataException(acmd, ammd, "\"gae.pk-id\" can only be applied to a Long field.");
            }
            if (ammd.hasExtension("gae.parent-pk")) {
                if (this.noParentAllowed) {
                    throw new DatastoreMetaDataException(acmd, ammd, "Cannot have a " + pkClass.getName() + " primary key and a parent pk field.");
                }
                if (!ammd.getType().equals(String.class) && !ammd.getType().equals(Key.class)) {
                    throw new DatastoreMetaDataException(acmd, ammd, "Parent pk must be of type String or " + Key.class.getName() + ".");
                }
            }
            for (String extension : NOT_PRIMARY_KEY_EXTENSIONS) {
                if (!ammd.hasExtension(extension) || !ammd.isPrimaryKey()) continue;
                throw new DatastoreMetaDataException(acmd, ammd, "A field with the \"" + extension + "\" extension must not be the primary key.");
            }
            for (String extension : REQUIRES_ENCODED_STRING_PK_EXTENSIONS) {
                if (!ammd.hasExtension(extension) || pkMemberMetaData.hasExtension("gae.encoded-pk")) continue;
                throw new DatastoreMetaDataException(acmd, ammd, "A field with the \"" + extension + "\" extension can only be used in conjunction " + "with an encoded String primary key..");
            }
            if (!this.noParentAllowed) continue;
            this.checkForIllegalChildField(ammd);
        }
    }

    private void checkForIllegalChildField(AbstractMemberMetaData ammd) {
        int relationType = ammd.getRelationType(this.clr);
        if (relationType == 0 || ammd.isEmbedded()) {
            return;
        }
        AbstractClassMetaData childAcmd = null;
        if (relationType == 4 || relationType == 3) {
            if (ammd.getCollection() != null) {
                childAcmd = ammd.getCollection().getElementClassMetaData(this.clr);
            } else if (ammd.getArray() != null) {
                childAcmd = ammd.getArray().getElementClassMetaData(this.clr);
            } else {
                NucleusLogger.METADATA.warn((Object)("Unable to validate one-to-many relation " + ammd.getFullFieldName()));
            }
        } else if (relationType == 2 || relationType == 1) {
            childAcmd = this.metaDataManager.getMetaDataForClass(ammd.getType(), this.clr);
        }
        if (childAcmd == null) {
            return;
        }
        int[] pkPositions = childAcmd.getPKMemberPositions();
        if (pkPositions == null) {
            NucleusLogger.METADATA.warn((Object)("Unable to validate relation " + ammd.getFullFieldName()));
            return;
        }
        int pkPos = pkPositions[0];
        AbstractMemberMetaData pkMemberMetaData = childAcmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPos);
        Class pkType = pkMemberMetaData.getType();
        if (pkType.equals(Long.class) || pkType.equals(String.class) && !pkMemberMetaData.hasExtension("gae.encoded-pk")) {
            throw new DatastoreMetaDataException(childAcmd, pkMemberMetaData, "Cannot have a " + pkType.getName() + " primary key and be a child object " + "(owning field is " + ammd.getFullFieldName() + ").");
        }
    }

    private AbstractMemberMetaData validatePrimaryKey() {
        int[] pkPositions = this.acmd.getPKMemberPositions();
        if (pkPositions == null) {
            throw new DatastoreMetaDataException(this.acmd, "No primary key defined.");
        }
        if (pkPositions.length != 1) {
            throw new DatastoreMetaDataException(this.acmd, "More than one primary key field.");
        }
        int pkPos = pkPositions[0];
        AbstractMemberMetaData pkMemberMetaData = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPos);
        Class pkType = pkMemberMetaData.getType();
        if (pkType.equals(Long.class)) {
            this.noParentAllowed = true;
        } else if (pkType.equals(String.class)) {
            if (!DatastoreManager.isEncodedPKField(this.acmd, pkPos)) {
                this.noParentAllowed = true;
            }
        } else if (!pkType.equals(Key.class)) {
            throw new DatastoreMetaDataException(this.acmd, pkMemberMetaData, "Unsupported primary key type: " + pkType.getName());
        }
        return pkMemberMetaData;
    }

    static final class DatastoreMetaDataException
    extends NucleusUserException {
        private static final String MSG_FORMAT_CLASS_ONLY = "Error in meta-data for %s: %s";
        private static final String MSG_FORMAT = "Error in meta-data for %s.%s: %s";

        private DatastoreMetaDataException(AbstractClassMetaData acmd, String msg) {
            super(String.format(MSG_FORMAT_CLASS_ONLY, acmd.getFullClassName(), msg));
        }

        private DatastoreMetaDataException(AbstractClassMetaData acmd, AbstractMemberMetaData ammd, String msg) {
            super(String.format(MSG_FORMAT, acmd.getFullClassName(), ammd.getName(), msg));
        }
    }
}

