/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocketAppenderBase<E>
extends AppenderBase<E> {
    static final int DEFAULT_PORT = 4560;
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    protected String remoteHost;
    protected InetAddress address;
    protected int port = 4560;
    protected ObjectOutputStream oos;
    protected int reconnectionDelay = 30000;
    private Connector connector;
    protected int counter = 0;

    @Override
    public void start() {
        int errorCount = 0;
        if (this.port == 0) {
            ++errorCount;
            this.addError("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.address == null) {
            ++errorCount;
            this.addError("No remote address was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        this.connect(this.address, this.port);
        if (errorCount == 0) {
            this.started = true;
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.started = false;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                this.addError("Could not close oos.", e);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.addInfo("Interrupting the connector.");
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(address, port).getOutputStream());
        }
        catch (IOException e) {
            String msg = "Could not connect to remote logback server at [" + address.getHostName() + "].";
            if (this.reconnectionDelay > 0) {
                msg = msg + " We will try again later.";
                this.fireConnector();
            }
            this.addError(msg, e);
        }
    }

    @Override
    protected void append(E event) {
        block9: {
            if (event == null) {
                return;
            }
            if (this.address == null) {
                this.addError("No remote host is set for SocketAppender named \"" + this.name + "\". For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
                return;
            }
            if (this.oos != null) {
                try {
                    this.postProcessEvent(event);
                    this.oos.writeObject(event);
                    this.oos.flush();
                    if (++this.counter >= 70) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                }
                catch (IOException e) {
                    if (this.oos != null) {
                        try {
                            this.oos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.oos = null;
                    this.addWarn("Detected problem with connection: " + e);
                    if (this.reconnectionDelay <= 0) break block9;
                    this.fireConnector();
                }
            }
        }
    }

    protected abstract void postProcessEvent(E var1);

    void fireConnector() {
        if (this.connector == null) {
            this.addInfo("Starting a new connector thread.");
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    protected static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRemoteHost(String host) {
        this.address = SocketAppenderBase.getAddressByName(host);
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    class Connector
    extends Thread {
        boolean interrupted = false;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    Connector.sleep(SocketAppenderBase.this.reconnectionDelay);
                    SocketAppenderBase.this.addInfo("Attempting connection to " + SocketAppenderBase.this.address.getHostName());
                    Socket socket = new Socket(SocketAppenderBase.this.address, SocketAppenderBase.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppenderBase.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppenderBase.this.connector = null;
                        SocketAppenderBase.this.addInfo("Connection established. Exiting connector thread.");
                        break;
                    }
                }
                catch (InterruptedException e) {
                    SocketAppenderBase.this.addInfo("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException e) {
                    SocketAppenderBase.this.addInfo("Remote host " + SocketAppenderBase.this.address.getHostName() + " refused connection.");
                }
                catch (IOException e) {
                    SocketAppenderBase.this.addInfo("Could not connect to " + SocketAppenderBase.this.address.getHostName() + ". Exception is " + e);
                }
            }
        }
    }
}

