/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.ssl.SslSecurityLevel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class MemcacheServicePb {
    private MemcacheServicePb() {
    }

    public static final class MemcacheService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("MemcacheService", params));
            }
        };

        private MemcacheService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("MemcacheService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("MemcacheService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            MemcacheService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Get", (ProtocolMessage)new MemcacheGetRequest(), (ProtocolMessage)new MemcacheGetResponse(), null, config.Get_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.get(rpc, (MemcacheGetRequest)rpc.internalRequest(), (MemcacheGetResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Set", (ProtocolMessage)new MemcacheSetRequest(), (ProtocolMessage)new MemcacheSetResponse(), null, config.Set_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.set(rpc, (MemcacheSetRequest)rpc.internalRequest(), (MemcacheSetResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Delete", (ProtocolMessage)new MemcacheDeleteRequest(), (ProtocolMessage)new MemcacheDeleteResponse(), null, config.Delete_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.delete(rpc, (MemcacheDeleteRequest)rpc.internalRequest(), (MemcacheDeleteResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Increment", (ProtocolMessage)new MemcacheIncrementRequest(), (ProtocolMessage)new MemcacheIncrementResponse(), null, config.Increment_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.increment(rpc, (MemcacheIncrementRequest)rpc.internalRequest(), (MemcacheIncrementResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "FlushAll", (ProtocolMessage)new MemcacheFlushRequest(), (ProtocolMessage)new MemcacheFlushResponse(), null, config.FlushAll_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.flushAll(rpc, (MemcacheFlushRequest)rpc.internalRequest(), (MemcacheFlushResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Stats", (ProtocolMessage)new MemcacheStatsRequest(), (ProtocolMessage)new MemcacheStatsResponse(), null, config.Stats_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.stats(rpc, (MemcacheStatsRequest)rpc.internalRequest(), (MemcacheStatsResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return MemcacheService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            MemcacheService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Get", (ProtocolMessage)new MemcacheGetRequest(), (ProtocolMessage)new MemcacheGetResponse(), null, config.Get_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public MemcacheGetResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.get(rpc, (MemcacheGetRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Set", (ProtocolMessage)new MemcacheSetRequest(), (ProtocolMessage)new MemcacheSetResponse(), null, config.Set_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public MemcacheSetResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.set(rpc, (MemcacheSetRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Delete", (ProtocolMessage)new MemcacheDeleteRequest(), (ProtocolMessage)new MemcacheDeleteResponse(), null, config.Delete_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public MemcacheDeleteResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.delete(rpc, (MemcacheDeleteRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Increment", (ProtocolMessage)new MemcacheIncrementRequest(), (ProtocolMessage)new MemcacheIncrementResponse(), null, config.Increment_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public MemcacheIncrementResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.increment(rpc, (MemcacheIncrementRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "FlushAll", (ProtocolMessage)new MemcacheFlushRequest(), (ProtocolMessage)new MemcacheFlushResponse(), null, config.FlushAll_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public MemcacheFlushResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.flushAll(rpc, (MemcacheFlushRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Stats", (ProtocolMessage)new MemcacheStatsRequest(), (ProtocolMessage)new MemcacheStatsResponse(), null, config.Stats_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public MemcacheStatsResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.stats(rpc, (MemcacheStatsRequest)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return MemcacheService.exportBlockingService(impl, registry);
                }
            };
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("MemcacheService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters Get_parameters_ = new RpcServerParameters();
            final RpcServerParameters Set_parameters_ = new RpcServerParameters();
            final RpcServerParameters Delete_parameters_ = new RpcServerParameters();
            final RpcServerParameters Increment_parameters_ = new RpcServerParameters();
            final RpcServerParameters FlushAll_parameters_ = new RpcServerParameters();
            final RpcServerParameters Stats_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("MemcacheService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_Get(t);
                this.setRpcRunner_Set(t);
                this.setRpcRunner_Delete(t);
                this.setRpcRunner_Increment(t);
                this.setRpcRunner_FlushAll(t);
                this.setRpcRunner_Stats(t);
            }

            public void setRpcRunner_Get(Executor t) {
                this.Get_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Set(Executor t) {
                this.Set_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Delete(Executor t) {
                this.Delete_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Increment(Executor t) {
                this.Increment_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_FlushAll(Executor t) {
                this.FlushAll_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Stats(Executor t) {
                this.Stats_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_Get(int t) {
                this.Get_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Set(int t) {
                this.Set_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Delete(int t) {
                this.Delete_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Increment(int t) {
                this.Increment_parameters_.setServerLogging(t);
            }

            public void setServerLogging_FlushAll(int t) {
                this.FlushAll_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Stats(int t) {
                this.Stats_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_Get(SslSecurityLevel t) {
                this.Get_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Set(SslSecurityLevel t) {
                this.Set_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Delete(SslSecurityLevel t) {
                this.Delete_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Increment(SslSecurityLevel t) {
                this.Increment_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_FlushAll(SslSecurityLevel t) {
                this.FlushAll_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Stats(SslSecurityLevel t) {
                this.Stats_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_Get(RpcCancelCallback t) {
                this.Get_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Set(RpcCancelCallback t) {
                this.Set_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Delete(RpcCancelCallback t) {
                this.Delete_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Increment(RpcCancelCallback t) {
                this.Increment_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_FlushAll(RpcCancelCallback t) {
                this.FlushAll_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Stats(RpcCancelCallback t) {
                this.Stats_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void get(RPC rpc, MemcacheGetRequest req, MemcacheGetResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Get_method_, "Get", req, reply, cb, this.Get_parameters_);
            }

            public void set(RPC rpc, MemcacheSetRequest req, MemcacheSetResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Set_method_, "Set", req, reply, cb, this.Set_parameters_);
            }

            public void delete(RPC rpc, MemcacheDeleteRequest req, MemcacheDeleteResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Delete_method_, "Delete", req, reply, cb, this.Delete_parameters_);
            }

            public void increment(RPC rpc, MemcacheIncrementRequest req, MemcacheIncrementResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Increment_method_, "Increment", req, reply, cb, this.Increment_parameters_);
            }

            public void flushAll(RPC rpc, MemcacheFlushRequest req, MemcacheFlushResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.FlushAll_method_, "FlushAll", req, reply, cb, this.FlushAll_parameters_);
            }

            public void stats(RPC rpc, MemcacheStatsRequest req, MemcacheStatsResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Stats_method_, "Stats", req, reply, cb, this.Stats_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void get(RPC var1, MemcacheGetRequest var2, MemcacheGetResponse var3, RpcCallback var4);

            public void set(RPC var1, MemcacheSetRequest var2, MemcacheSetResponse var3, RpcCallback var4);

            public void delete(RPC var1, MemcacheDeleteRequest var2, MemcacheDeleteResponse var3, RpcCallback var4);

            public void increment(RPC var1, MemcacheIncrementRequest var2, MemcacheIncrementResponse var3, RpcCallback var4);

            public void flushAll(RPC var1, MemcacheFlushRequest var2, MemcacheFlushResponse var3, RpcCallback var4);

            public void stats(RPC var1, MemcacheStatsRequest var2, MemcacheStatsResponse var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public MemcacheGetResponse get(RPC rpc, MemcacheGetRequest req) throws RpcException {
                MemcacheGetResponse reply = new MemcacheGetResponse();
                this.startBlockingRpc(rpc, this.Get_method_, "Get", req, reply, this.Get_parameters_);
                return reply;
            }

            public MemcacheSetResponse set(RPC rpc, MemcacheSetRequest req) throws RpcException {
                MemcacheSetResponse reply = new MemcacheSetResponse();
                this.startBlockingRpc(rpc, this.Set_method_, "Set", req, reply, this.Set_parameters_);
                return reply;
            }

            public MemcacheDeleteResponse delete(RPC rpc, MemcacheDeleteRequest req) throws RpcException {
                MemcacheDeleteResponse reply = new MemcacheDeleteResponse();
                this.startBlockingRpc(rpc, this.Delete_method_, "Delete", req, reply, this.Delete_parameters_);
                return reply;
            }

            public MemcacheIncrementResponse increment(RPC rpc, MemcacheIncrementRequest req) throws RpcException {
                MemcacheIncrementResponse reply = new MemcacheIncrementResponse();
                this.startBlockingRpc(rpc, this.Increment_method_, "Increment", req, reply, this.Increment_parameters_);
                return reply;
            }

            public MemcacheFlushResponse flushAll(RPC rpc, MemcacheFlushRequest req) throws RpcException {
                MemcacheFlushResponse reply = new MemcacheFlushResponse();
                this.startBlockingRpc(rpc, this.FlushAll_method_, "FlushAll", req, reply, this.FlushAll_parameters_);
                return reply;
            }

            public MemcacheStatsResponse stats(RPC rpc, MemcacheStatsRequest req) throws RpcException {
                MemcacheStatsResponse reply = new MemcacheStatsResponse();
                this.startBlockingRpc(rpc, this.Stats_method_, "Stats", req, reply, this.Stats_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public MemcacheGetResponse get(RPC var1, MemcacheGetRequest var2) throws RpcException;

            public MemcacheSetResponse set(RPC var1, MemcacheSetRequest var2) throws RpcException;

            public MemcacheDeleteResponse delete(RPC var1, MemcacheDeleteRequest var2) throws RpcException;

            public MemcacheIncrementResponse increment(RPC var1, MemcacheIncrementRequest var2) throws RpcException;

            public MemcacheFlushResponse flushAll(RPC var1, MemcacheFlushRequest var2) throws RpcException;

            public MemcacheStatsResponse stats(RPC var1, MemcacheStatsRequest var2) throws RpcException;
        }

        private static class BaseStub
        extends RpcStub {
            protected final String Get_method_;
            protected final RPC Get_parameters_ = this.newRpcPrototype(Method.Get);
            protected final String Set_method_;
            protected final RPC Set_parameters_ = this.newRpcPrototype(Method.Set);
            protected final String Delete_method_;
            protected final RPC Delete_parameters_ = this.newRpcPrototype(Method.Delete);
            protected final String Increment_method_;
            protected final RPC Increment_parameters_ = this.newRpcPrototype(Method.Increment);
            protected final String FlushAll_method_;
            protected final RPC FlushAll_parameters_ = this.newRpcPrototype(Method.FlushAll);
            protected final String Stats_method_;
            protected final RPC Stats_parameters_ = this.newRpcPrototype(Method.Stats);

            protected BaseStub(RpcStubParameters params) {
                super("MemcacheService", params, Method.class);
                this.Get_method_ = this.makeFullMethodName("Get");
                this.Set_method_ = this.makeFullMethodName("Set");
                this.Delete_method_ = this.makeFullMethodName("Delete");
                this.Increment_method_ = this.makeFullMethodName("Increment");
                this.FlushAll_method_ = this.makeFullMethodName("FlushAll");
                this.Stats_method_ = this.makeFullMethodName("Stats");
            }
        }

        private static class SimpleStub
        extends RpcStub {
            public SimpleStub(RpcStubParameters params) {
                super("MemcacheService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            Get,
            Set,
            Delete,
            Increment,
            FlushAll,
            Stats;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheStatsResponse
    extends ProtocolMessage<MemcacheStatsResponse> {
        private static final long serialVersionUID = 1L;
        private MergedNamespaceStats stats_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheStatsResponse IMMUTABLE_DEFAULT_INSTANCE = new MemcacheStatsResponse(){
            private static final long serialVersionUID = 1L;

            public MemcacheStatsResponse clearStats() {
                return this;
            }

            public MemcacheStatsResponse setStats(MergedNamespaceStats x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats getMutableStats() {
                return (MergedNamespaceStats)ProtocolSupport.unsupportedOperation();
            }

            public MemcacheStatsResponse mergeFrom(MemcacheStatsResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheStatsResponse freeze() {
                return this;
            }

            public MemcacheStatsResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kstats = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final MergedNamespaceStats getStats() {
            if (this.stats_ == null) {
                return MergedNamespaceStats.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.stats_;
        }

        public final boolean hasStats() {
            return (this.optional_0_ & 1) != 0;
        }

        public MemcacheStatsResponse clearStats() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.stats_ != null) {
                this.stats_.clear();
            }
            return this;
        }

        public MemcacheStatsResponse setStats(MergedNamespaceStats x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.stats_ = x;
            return this;
        }

        public MergedNamespaceStats getMutableStats() {
            this.optional_0_ |= 1;
            if (this.stats_ == null) {
                this.stats_ = new MergedNamespaceStats();
            }
            return this.stats_;
        }

        @Override
        public MemcacheStatsResponse mergeFrom(MemcacheStatsResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                MergedNamespaceStats v = this.stats_;
                if (v == null) {
                    this.stats_ = v = new MergedNamespaceStats();
                }
                v.mergeFrom(that.stats_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheStatsResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheStatsResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheStatsResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.stats_.equals(that.stats_, ignoreUninterpreted)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheStatsResponse && this.equals((MemcacheStatsResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = 1575483490;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.stats_.hashCode() : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0 && (e = this.stats_.findInitializationError()) != null) {
                return e;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.stats_.encodingSize());
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.stats_.maxEncodingSize();
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.stats_ != null) {
                this.stats_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public MemcacheStatsResponse newInstance() {
            return new MemcacheStatsResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)10);
                sink.putForeign(this.stats_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        MergedNamespaceStats v1 = this.stats_;
                        if (v1 == null) {
                            this.stats_ = v1 = new MergedNamespaceStats();
                        }
                        if (!v1.merge(source)) {
                            result = false;
                            break block4;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheStatsResponse freeze() {
            if (this.stats_ != null) {
                this.stats_.freeze();
            }
            return this;
        }

        @Override
        public MemcacheStatsResponse unfreeze() {
            if (this.stats_ != null) {
                this.stats_.unfreeze();
            }
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.stats_ != null && this.stats_.isFrozen();
        }

        static {
            MemcacheStatsResponse.text[0] = "ErrorCode";
            MemcacheStatsResponse.text[1] = "stats";
            types = new int[2];
            Arrays.fill(types, 6);
            MemcacheStatsResponse.types[0] = 0;
            MemcacheStatsResponse.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheStatsResponse.class, "Z.apphosting/api/memcache/memcache_service.proto\n apphosting.MemcacheStatsResponse\u0013\u001a\u0005stats \u0001(\u00020\u000b8\u0001J\u001fapphosting.MergedNamespaceStats\u0014", new ProtocolType.FieldType("stats", "stats", 1, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, MergedNamespaceStats.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergedNamespaceStats
    extends ProtocolMessage<MergedNamespaceStats> {
        private static final long serialVersionUID = 1L;
        private long hits_ = 0L;
        private long misses_ = 0L;
        private long byte_hits_ = 0L;
        private long items_ = 0L;
        private long bytes_ = 0L;
        private int oldest_item_age_ = 0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MergedNamespaceStats IMMUTABLE_DEFAULT_INSTANCE = new MergedNamespaceStats(){
            private static final long serialVersionUID = 1L;

            public MergedNamespaceStats clearHits() {
                return this;
            }

            public MergedNamespaceStats setHits(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats clearMisses() {
                return this;
            }

            public MergedNamespaceStats setMisses(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats clearByteHits() {
                return this;
            }

            public MergedNamespaceStats setByteHits(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats clearItems() {
                return this;
            }

            public MergedNamespaceStats setItems(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats clearBytes() {
                return this;
            }

            public MergedNamespaceStats setBytes(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats clearOldestItemAge() {
                return this;
            }

            public MergedNamespaceStats setOldestItemAge(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MergedNamespaceStats mergeFrom(MergedNamespaceStats that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MergedNamespaceStats freeze() {
                return this;
            }

            public MergedNamespaceStats unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int khits = 1;
        public static final int kmisses = 2;
        public static final int kbyte_hits = 3;
        public static final int kitems = 4;
        public static final int kbytes = 5;
        public static final int koldest_item_age = 6;
        public static final String[] text = new String[7];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final long getHits() {
            return this.hits_;
        }

        public final boolean hasHits() {
            return (this.optional_0_ & 1) != 0;
        }

        public MergedNamespaceStats clearHits() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.hits_ = 0L;
            return this;
        }

        public MergedNamespaceStats setHits(long x) {
            this.optional_0_ |= 1;
            this.hits_ = x;
            return this;
        }

        public final long getMisses() {
            return this.misses_;
        }

        public final boolean hasMisses() {
            return (this.optional_0_ & 2) != 0;
        }

        public MergedNamespaceStats clearMisses() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.misses_ = 0L;
            return this;
        }

        public MergedNamespaceStats setMisses(long x) {
            this.optional_0_ |= 2;
            this.misses_ = x;
            return this;
        }

        public final long getByteHits() {
            return this.byte_hits_;
        }

        public final boolean hasByteHits() {
            return (this.optional_0_ & 4) != 0;
        }

        public MergedNamespaceStats clearByteHits() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.byte_hits_ = 0L;
            return this;
        }

        public MergedNamespaceStats setByteHits(long x) {
            this.optional_0_ |= 4;
            this.byte_hits_ = x;
            return this;
        }

        public final long getItems() {
            return this.items_;
        }

        public final boolean hasItems() {
            return (this.optional_0_ & 8) != 0;
        }

        public MergedNamespaceStats clearItems() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.items_ = 0L;
            return this;
        }

        public MergedNamespaceStats setItems(long x) {
            this.optional_0_ |= 8;
            this.items_ = x;
            return this;
        }

        public final long getBytes() {
            return this.bytes_;
        }

        public final boolean hasBytes() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public MergedNamespaceStats clearBytes() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.bytes_ = 0L;
            return this;
        }

        public MergedNamespaceStats setBytes(long x) {
            this.optional_0_ |= 0x10;
            this.bytes_ = x;
            return this;
        }

        public final int getOldestItemAge() {
            return this.oldest_item_age_;
        }

        public final boolean hasOldestItemAge() {
            return (this.optional_0_ & 0x20) != 0;
        }

        public MergedNamespaceStats clearOldestItemAge() {
            this.optional_0_ &= 0xFFFFFFDF;
            this.oldest_item_age_ = 0;
            return this;
        }

        public MergedNamespaceStats setOldestItemAge(int x) {
            this.optional_0_ |= 0x20;
            this.oldest_item_age_ = x;
            return this;
        }

        @Override
        public MergedNamespaceStats mergeFrom(MergedNamespaceStats that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.hits_ = that.hits_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.misses_ = that.misses_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.byte_hits_ = that.byte_hits_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.items_ = that.items_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.bytes_ = that.bytes_;
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                this.oldest_item_age_ = that.oldest_item_age_;
            }
            if ((that_t0 & 0x40) != 0) {
                this_t0 |= 0x40;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MergedNamespaceStats that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MergedNamespaceStats that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MergedNamespaceStats that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFBF) != (that_t0 & 0xFFFFFFBF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.hits_ != that.hits_) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.misses_ != that.misses_) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.byte_hits_ != that.byte_hits_) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.items_ != that.items_) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && this.bytes_ != that.bytes_) {
                return false;
            }
            if ((this_t0 & 0x20) != 0 && this.oldest_item_age_ != that.oldest_item_age_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x40) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MergedNamespaceStats && this.equals((MergedNamespaceStats)that);
        }

        @Override
        public int hashCode() {
            int hash = -239053698;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode(this.hits_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode(this.misses_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode(this.byte_hits_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? ProtocolSupport.hashCode(this.items_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? ProtocolSupport.hashCode(this.bytes_) : -113);
            hash = hash * 31 + ((this_t0 & 0x20) != 0 ? this.oldest_item_age_ : -113);
            if ((this_t0 & 0x40) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x3F) != 63) {
                if ((this_t0 & 1) == 0) {
                    return "missing field: hits";
                }
                if ((this_t0 & 2) == 0) {
                    return "missing field: misses";
                }
                if ((this_t0 & 4) == 0) {
                    return "missing field: byte_hits";
                }
                if ((this_t0 & 8) == 0) {
                    return "missing field: items";
                }
                if ((this_t0 & 0x10) == 0) {
                    return "missing field: bytes";
                }
                return "missing field: oldest_item_age";
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 10 + Protocol.varLongSize(this.hits_) + Protocol.varLongSize(this.misses_) + Protocol.varLongSize(this.byte_hits_) + Protocol.varLongSize(this.items_) + Protocol.varLongSize(this.bytes_);
            int this_t0 = this.optional_0_;
            return (this_t0 & 0x40) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 60;
            int this_t0 = this.optional_0_;
            return (this_t0 & 0x40) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x40;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.hits_ = 0L;
            this.misses_ = 0L;
            this.byte_hits_ = 0L;
            this.items_ = 0L;
            this.bytes_ = 0L;
            this.oldest_item_age_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public MergedNamespaceStats newInstance() {
            return new MergedNamespaceStats();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)8);
            sink.putVarLong(this.hits_);
            sink.putByte((byte)16);
            sink.putVarLong(this.misses_);
            sink.putByte((byte)24);
            sink.putVarLong(this.byte_hits_);
            sink.putByte((byte)32);
            sink.putVarLong(this.items_);
            sink.putByte((byte)40);
            sink.putVarLong(this.bytes_);
            sink.putByte((byte)53);
            sink.putInt(this.oldest_item_age_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x40) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block9: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block9;
                    }
                    case 8: {
                        this.hits_ = source.getVarLong();
                        this_t0 |= 1;
                        continue block9;
                    }
                    case 16: {
                        this.misses_ = source.getVarLong();
                        this_t0 |= 2;
                        continue block9;
                    }
                    case 24: {
                        this.byte_hits_ = source.getVarLong();
                        this_t0 |= 4;
                        continue block9;
                    }
                    case 32: {
                        this.items_ = source.getVarLong();
                        this_t0 |= 8;
                        continue block9;
                    }
                    case 40: {
                        this.bytes_ = source.getVarLong();
                        this_t0 |= 0x10;
                        continue block9;
                    }
                    case 53: {
                        this.oldest_item_age_ = source.getInt();
                        this_t0 |= 0x20;
                        continue block9;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x40;
                        continue block9;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MergedNamespaceStats.text[0] = "ErrorCode";
            MergedNamespaceStats.text[1] = "hits";
            MergedNamespaceStats.text[2] = "misses";
            MergedNamespaceStats.text[3] = "byte_hits";
            MergedNamespaceStats.text[4] = "items";
            MergedNamespaceStats.text[5] = "bytes";
            MergedNamespaceStats.text[6] = "oldest_item_age";
            types = new int[7];
            Arrays.fill(types, 6);
            MergedNamespaceStats.types[0] = 0;
            MergedNamespaceStats.types[1] = 0;
            MergedNamespaceStats.types[2] = 0;
            MergedNamespaceStats.types[3] = 0;
            MergedNamespaceStats.types[4] = 0;
            MergedNamespaceStats.types[5] = 0;
            MergedNamespaceStats.types[6] = 5;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MergedNamespaceStats.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001fapphosting.MergedNamespaceStats\u0013\u001a\u0004hits \u0001(\u00000\u00048\u0002\u0014\u0013\u001a\u0006misses \u0002(\u00000\u00048\u0002\u0014\u0013\u001a\tbyte_hits \u0003(\u00000\u00048\u0002\u0014\u0013\u001a\u0005items \u0004(\u00000\u00048\u0002\u0014\u0013\u001a\u0005bytes \u0005(\u00000\u00048\u0002\u0014\u0013\u001a\u000foldest_item_age \u0006(\u00050\u00078\u0002\u0014", new ProtocolType.FieldType("hits", "hits", 1, 0, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("misses", "misses", 2, 1, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("byte_hits", "byte_hits", 3, 2, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("items", "items", 4, 3, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("bytes", "bytes", 5, 4, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("oldest_item_age", "oldest_item_age", 6, 5, ProtocolType.FieldBaseType.FIXED32, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheStatsRequest
    extends ProtocolMessage<MemcacheStatsRequest> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheStatsRequest IMMUTABLE_DEFAULT_INSTANCE = new MemcacheStatsRequest(){
            private static final long serialVersionUID = 1L;

            public MemcacheStatsRequest mergeFrom(MemcacheStatsRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheStatsRequest freeze() {
                return this;
            }

            public MemcacheStatsRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public MemcacheStatsRequest mergeFrom(MemcacheStatsRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheStatsRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheStatsRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheStatsRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheStatsRequest && this.equals((MemcacheStatsRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = -1330505714;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheStatsRequest newInstance() {
            return new MemcacheStatsRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MemcacheStatsRequest.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            MemcacheStatsRequest.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheStatsRequest.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001fapphosting.MemcacheStatsRequest", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheFlushResponse
    extends ProtocolMessage<MemcacheFlushResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheFlushResponse IMMUTABLE_DEFAULT_INSTANCE = new MemcacheFlushResponse(){
            private static final long serialVersionUID = 1L;

            public MemcacheFlushResponse mergeFrom(MemcacheFlushResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheFlushResponse freeze() {
                return this;
            }

            public MemcacheFlushResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public MemcacheFlushResponse mergeFrom(MemcacheFlushResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheFlushResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheFlushResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheFlushResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheFlushResponse && this.equals((MemcacheFlushResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = 1359734866;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheFlushResponse newInstance() {
            return new MemcacheFlushResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MemcacheFlushResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            MemcacheFlushResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheFlushResponse.class, "Z.apphosting/api/memcache/memcache_service.proto\n apphosting.MemcacheFlushResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheFlushRequest
    extends ProtocolMessage<MemcacheFlushRequest> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheFlushRequest IMMUTABLE_DEFAULT_INSTANCE = new MemcacheFlushRequest(){
            private static final long serialVersionUID = 1L;

            public MemcacheFlushRequest mergeFrom(MemcacheFlushRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheFlushRequest freeze() {
                return this;
            }

            public MemcacheFlushRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public MemcacheFlushRequest mergeFrom(MemcacheFlushRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheFlushRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheFlushRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheFlushRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheFlushRequest && this.equals((MemcacheFlushRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = -568295652;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheFlushRequest newInstance() {
            return new MemcacheFlushRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MemcacheFlushRequest.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            MemcacheFlushRequest.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheFlushRequest.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001fapphosting.MemcacheFlushRequest", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheIncrementResponse
    extends ProtocolMessage<MemcacheIncrementResponse> {
        private static final long serialVersionUID = 1L;
        private long new_value_ = 0L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheIncrementResponse IMMUTABLE_DEFAULT_INSTANCE = new MemcacheIncrementResponse(){
            private static final long serialVersionUID = 1L;

            public MemcacheIncrementResponse clearNewValue() {
                return this;
            }

            public MemcacheIncrementResponse setNewValue(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementResponse mergeFrom(MemcacheIncrementResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheIncrementResponse freeze() {
                return this;
            }

            public MemcacheIncrementResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int knew_value = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final long getNewValue() {
            return this.new_value_;
        }

        public final boolean hasNewValue() {
            return (this.optional_0_ & 1) != 0;
        }

        public MemcacheIncrementResponse clearNewValue() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.new_value_ = 0L;
            return this;
        }

        public MemcacheIncrementResponse setNewValue(long x) {
            this.optional_0_ |= 1;
            this.new_value_ = x;
            return this;
        }

        @Override
        public MemcacheIncrementResponse mergeFrom(MemcacheIncrementResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.new_value_ = that.new_value_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheIncrementResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheIncrementResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheIncrementResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.new_value_ != that.new_value_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheIncrementResponse && this.equals((MemcacheIncrementResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -652169356;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode(this.new_value_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.varLongSize(this.new_value_);
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 11;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.new_value_ = 0L;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheIncrementResponse newInstance() {
            return new MemcacheIncrementResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)8);
                sink.putVarLong(this.new_value_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 8: {
                        this.new_value_ = source.getVarLong();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MemcacheIncrementResponse.text[0] = "ErrorCode";
            MemcacheIncrementResponse.text[1] = "new_value";
            types = new int[2];
            Arrays.fill(types, 6);
            MemcacheIncrementResponse.types[0] = 0;
            MemcacheIncrementResponse.types[1] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheIncrementResponse.class, "Z.apphosting/api/memcache/memcache_service.proto\n$apphosting.MemcacheIncrementResponse\u0013\u001a\tnew_value \u0001(\u00000\u00048\u0001\u0014", new ProtocolType.FieldType("new_value", "new_value", 1, 0, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheIncrementRequest
    extends ProtocolMessage<MemcacheIncrementRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private long delta_ = 1L;
        private int direction_ = 1;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheIncrementRequest IMMUTABLE_DEFAULT_INSTANCE = new MemcacheIncrementRequest(){
            private static final long serialVersionUID = 1L;

            public MemcacheIncrementRequest clearKey() {
                return this;
            }

            public MemcacheIncrementRequest setKeyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest setKey(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest setKey(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest clearNameSpace() {
                return this;
            }

            public MemcacheIncrementRequest setNameSpaceAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest setNameSpace(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest setNameSpace(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest clearDelta() {
                return this;
            }

            public MemcacheIncrementRequest setDelta(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest clearDirection() {
                return this;
            }

            public MemcacheIncrementRequest setDirection(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheIncrementRequest mergeFrom(MemcacheIncrementRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheIncrementRequest freeze() {
                return this;
            }

            public MemcacheIncrementRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kkey = 1;
        public static final int kname_space = 4;
        public static final int kdelta = 2;
        public static final int kdirection = 3;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getKeyAsBytes() {
            return this.key_;
        }

        public final boolean hasKey() {
            return (this.optional_0_ & 1) != 0;
        }

        public MemcacheIncrementRequest clearKey() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MemcacheIncrementRequest setKeyAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.key_ = x;
            return this;
        }

        public final String getKey() {
            return ProtocolSupport.toStringUtf8(this.key_);
        }

        public MemcacheIncrementRequest setKey(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.key_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getKey(Charset cs) {
            return ProtocolSupport.toString(this.key_, cs);
        }

        public MemcacheIncrementRequest setKey(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.key_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getNameSpaceAsBytes() {
            return this.name_space_;
        }

        public final boolean hasNameSpace() {
            return (this.optional_0_ & 2) != 0;
        }

        public MemcacheIncrementRequest clearNameSpace() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MemcacheIncrementRequest setNameSpaceAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.name_space_ = x;
            return this;
        }

        public final String getNameSpace() {
            return ProtocolSupport.toStringUtf8(this.name_space_);
        }

        public MemcacheIncrementRequest setNameSpace(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.name_space_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getNameSpace(Charset cs) {
            return ProtocolSupport.toString(this.name_space_, cs);
        }

        public MemcacheIncrementRequest setNameSpace(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.name_space_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final long getDelta() {
            return this.delta_;
        }

        public final boolean hasDelta() {
            return (this.optional_0_ & 4) != 0;
        }

        public MemcacheIncrementRequest clearDelta() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.delta_ = 1L;
            return this;
        }

        public MemcacheIncrementRequest setDelta(long x) {
            this.optional_0_ |= 4;
            this.delta_ = x;
            return this;
        }

        public final int getDirection() {
            return this.direction_;
        }

        public Direction getDirectionEnum() {
            return Direction.valueOf(this.getDirection());
        }

        public final boolean hasDirection() {
            return (this.optional_0_ & 8) != 0;
        }

        public MemcacheIncrementRequest clearDirection() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.direction_ = 1;
            return this;
        }

        public MemcacheIncrementRequest setDirection(int x) {
            this.optional_0_ |= 8;
            this.direction_ = x;
            return this;
        }

        public MemcacheIncrementRequest setDirection(Direction x) {
            if (x == null) {
                this.optional_0_ &= 0xFFFFFFF7;
                this.direction_ = 1;
            } else {
                this.setDirection(x.getValue());
            }
            return this;
        }

        @Override
        public MemcacheIncrementRequest mergeFrom(MemcacheIncrementRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.key_ = that.key_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.name_space_ = that.name_space_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.delta_ = that.delta_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.direction_ = that.direction_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheIncrementRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheIncrementRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheIncrementRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFEF) != (that_t0 & 0xFFFFFFEF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.name_space_, that.name_space_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.delta_ != that.delta_) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.direction_ != that.direction_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x10) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheIncrementRequest && this.equals((MemcacheIncrementRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = 1125567466;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode(this.delta_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? this.direction_ : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.name_space_) : -113);
            if ((this_t0 & 0x10) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 1) {
                return "missing field: key";
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.key_.length);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xE) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.stringSize(this.name_space_.length);
                }
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.varLongSize(this.delta_);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.varLongSize(this.direction_);
                }
            }
            return (this_t0 & 0x10) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 28 + this.key_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 6 + this.name_space_.length;
            }
            return (this_t0 & 0x10) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x10;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.delta_ = 1L;
            this.direction_ = 1;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheIncrementRequest newInstance() {
            return new MemcacheIncrementRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.key_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)16);
                sink.putVarLong(this.delta_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)24);
                sink.putVarLong(this.direction_);
            }
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.name_space_);
            }
            if ((this_t0 & 0x10) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block7: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block7;
                    }
                    case 10: {
                        this.key_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block7;
                    }
                    case 16: {
                        this.delta_ = source.getVarLong();
                        this_t0 |= 4;
                        continue block7;
                    }
                    case 24: {
                        this.direction_ = source.getVarInt();
                        this_t0 |= 8;
                        continue block7;
                    }
                    case 34: {
                        this.name_space_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block7;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x10;
                        continue block7;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheIncrementRequest freeze() {
            this.key_ = ProtocolSupport.freezeString(this.key_);
            this.name_space_ = ProtocolSupport.freezeString(this.name_space_);
            return this;
        }

        static {
            MemcacheIncrementRequest.text[0] = "ErrorCode";
            MemcacheIncrementRequest.text[1] = "key";
            MemcacheIncrementRequest.text[2] = "delta";
            MemcacheIncrementRequest.text[3] = "direction";
            MemcacheIncrementRequest.text[4] = "name_space";
            types = new int[5];
            Arrays.fill(types, 6);
            MemcacheIncrementRequest.types[0] = 0;
            MemcacheIncrementRequest.types[1] = 2;
            MemcacheIncrementRequest.types[2] = 0;
            MemcacheIncrementRequest.types[3] = 0;
            MemcacheIncrementRequest.types[4] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheIncrementRequest.class, "Z.apphosting/api/memcache/memcache_service.proto\n#apphosting.MemcacheIncrementRequest\u0013\u001a\u0003key \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nname_space \u0004(\u00020\t8\u0001B\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0002\"\"\u00a4\u0001\u0014\u0013\u001a\u0005delta \u0002(\u00000\u00048\u0001B\u00011\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00011\u00a4\u0001\u0014\u0013\u001a\tdirection \u0003(\u00000\u00058\u0001B\u00011h\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\tINCREMENT\u00a4\u0001\u0014sz\tDirection\u008b\u0001\u0092\u0001\tINCREMENT\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\tDECREMENT\u0098\u0001\u0002\u008c\u0001t", new ProtocolType.FieldType("key", "key", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("name_space", "name_space", 4, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("delta", "delta", 2, 2, ProtocolType.FieldBaseType.UINT64, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("direction", "direction", 3, 3, ProtocolType.Presence.OPTIONAL, Direction.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction implements ProtocolMessageEnum
        {
            INCREMENT(1),
            DECREMENT(2);

            public static final Direction Direction_MIN;
            public static final Direction Direction_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static Direction valueOf(int value) {
                switch (value) {
                    case 1: {
                        return INCREMENT;
                    }
                    case 2: {
                        return DECREMENT;
                    }
                }
                return null;
            }

            private Direction(int v) {
                this.value = v;
            }

            static {
                Direction_MIN = INCREMENT;
                Direction_MAX = DECREMENT;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheDeleteResponse
    extends ProtocolMessage<MemcacheDeleteResponse> {
        private static final long serialVersionUID = 1L;
        private int[] delete_status_ = ProtocolSupport.EMPTY_INT_ARRAY;
        private int delete_status_elts_;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheDeleteResponse IMMUTABLE_DEFAULT_INSTANCE = new MemcacheDeleteResponse(){
            private static final long serialVersionUID = 1L;

            public MemcacheDeleteResponse clearDeleteStatus() {
                return this;
            }

            public MemcacheDeleteResponse setDeleteStatus(int i, int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheDeleteResponse addDeleteStatus(int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheDeleteResponse mergeFrom(MemcacheDeleteResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheDeleteResponse freeze() {
                return this;
            }

            public MemcacheDeleteResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kdelete_status = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int deleteStatusSize() {
            return this.delete_status_elts_;
        }

        public final int getDeleteStatus(int i) {
            assert (i >= 0 && i < this.delete_status_elts_);
            return this.delete_status_[i];
        }

        public MemcacheDeleteResponse clearDeleteStatus() {
            this.delete_status_elts_ = 0;
            this.delete_status_ = ProtocolSupport.EMPTY_INT_ARRAY;
            return this;
        }

        public MemcacheDeleteResponse setDeleteStatus(int i, int v) {
            assert (i >= 0 && i < this.delete_status_elts_);
            this.delete_status_[i] = v;
            return this;
        }

        public MemcacheDeleteResponse addDeleteStatus(int v) {
            if (this.delete_status_elts_ == this.delete_status_.length) {
                this.delete_status_ = ProtocolSupport.growArray(this.delete_status_);
            }
            this.delete_status_[this.delete_status_elts_++] = v;
            return this;
        }

        public final Iterator<Integer> deleteStatusIterator() {
            return ProtocolSupport.asList(this.delete_status_, 0, this.delete_status_elts_).iterator();
        }

        public final List<Integer> deleteStatuss() {
            return ProtocolSupport.asList(this.delete_status_, 0, this.delete_status_elts_);
        }

        @Override
        public MemcacheDeleteResponse mergeFrom(MemcacheDeleteResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.delete_status_elts_ > 0) {
                this.delete_status_ = ProtocolSupport.ensureCapacity(this.delete_status_, this.delete_status_elts_ + that.delete_status_elts_);
                System.arraycopy(that.delete_status_, 0, this.delete_status_, this.delete_status_elts_, that.delete_status_elts_);
                this.delete_status_elts_ += that.delete_status_elts_;
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheDeleteResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheDeleteResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheDeleteResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.delete_status_elts_;
            if (n != that.delete_status_elts_) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.delete_status_[i] == that.delete_status_[i]) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheDeleteResponse && this.equals((MemcacheDeleteResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -1002842237;
            hash *= 31;
            int n = this.delete_status_elts_;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.delete_status_[i];
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.delete_status_elts_;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.varLongSize(this.delete_status_[i]);
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : (n += 11 * this.delete_status_elts_);
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.delete_status_elts_ = 0;
            this.delete_status_ = ProtocolSupport.EMPTY_INT_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheDeleteResponse newInstance() {
            return new MemcacheDeleteResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m = this.delete_status_elts_;
            for (int i = 0; i < m; ++i) {
                int v = this.delete_status_[i];
                sink.putByte((byte)8);
                sink.putVarLong(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 8: {
                        this.addDeleteStatus(source.getVarInt());
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheDeleteResponse freeze() {
            this.delete_status_ = ProtocolSupport.freezeArray(this.delete_status_, this.delete_status_elts_);
            return this;
        }

        static {
            MemcacheDeleteResponse.text[0] = "ErrorCode";
            MemcacheDeleteResponse.text[1] = "delete_status";
            types = new int[2];
            Arrays.fill(types, 6);
            MemcacheDeleteResponse.types[0] = 0;
            MemcacheDeleteResponse.types[1] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheDeleteResponse.class, "Z.apphosting/api/memcache/memcache_service.proto\n!apphosting.MemcacheDeleteResponse\u0013\u001a\rdelete_status \u0001(\u00000\u00058\u0003h\u0000\u0014sz\u0010DeleteStatusCode\u008b\u0001\u0092\u0001\u0007DELETED\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\tNOT_FOUND\u0098\u0001\u0002\u008c\u0001t", new ProtocolType.FieldType("delete_status", "delete_status", 1, -1, ProtocolType.Presence.REPEATED, DeleteStatusCode.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DeleteStatusCode implements ProtocolMessageEnum
        {
            DELETED(1),
            NOT_FOUND(2);

            public static final DeleteStatusCode DeleteStatusCode_MIN;
            public static final DeleteStatusCode DeleteStatusCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static DeleteStatusCode valueOf(int value) {
                switch (value) {
                    case 1: {
                        return DELETED;
                    }
                    case 2: {
                        return NOT_FOUND;
                    }
                }
                return null;
            }

            private DeleteStatusCode(int v) {
                this.value = v;
            }

            static {
                DeleteStatusCode_MIN = DELETED;
                DeleteStatusCode_MAX = NOT_FOUND;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheDeleteRequest
    extends ProtocolMessage<MemcacheDeleteRequest> {
        private static final long serialVersionUID = 1L;
        private List<Item> item_ = null;
        private byte[] name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheDeleteRequest IMMUTABLE_DEFAULT_INSTANCE = new MemcacheDeleteRequest(){
            private static final long serialVersionUID = 1L;

            public MemcacheDeleteRequest clearItem() {
                return this;
            }

            public Item getMutableItem(int i) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item addItem() {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item addItem(Item v) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item insertItem(int i, Item v) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item removeItem(int i) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public MemcacheDeleteRequest clearNameSpace() {
                return this;
            }

            public MemcacheDeleteRequest setNameSpaceAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheDeleteRequest setNameSpace(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheDeleteRequest setNameSpace(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheDeleteRequest mergeFrom(MemcacheDeleteRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheDeleteRequest freeze() {
                return this;
            }

            public MemcacheDeleteRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kItemGroup = 1;
        public static final int kItemkey = 2;
        public static final int kItemdelete_time = 3;
        public static final int kname_space = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int itemSize() {
            return this.item_ != null ? this.item_.size() : 0;
        }

        public final Item getItem(int i) {
            assert (i >= 0 && i < (this.item_ != null ? this.item_.size() : 0));
            return this.item_.get(i);
        }

        public MemcacheDeleteRequest clearItem() {
            if (this.item_ != null) {
                this.item_.clear();
            }
            return this;
        }

        public Item getMutableItem(int i) {
            assert (i >= 0 && this.item_ != null && i < this.item_.size());
            return this.item_.get(i);
        }

        public Item addItem() {
            Item v = new Item();
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(v);
            return v;
        }

        public Item addItem(Item v) {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(v);
            return v;
        }

        public Item insertItem(int i, Item v) {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(i, v);
            return v;
        }

        public Item removeItem(int i) {
            return this.item_.remove(i);
        }

        public final Iterator<Item> itemIterator() {
            if (this.item_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.item_.iterator();
        }

        public final List<Item> items() {
            return ProtocolSupport.unmodifiableList(this.item_);
        }

        public final List<Item> mutableItems() {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            return this.item_;
        }

        public final byte[] getNameSpaceAsBytes() {
            return this.name_space_;
        }

        public final boolean hasNameSpace() {
            return (this.optional_0_ & 1) != 0;
        }

        public MemcacheDeleteRequest clearNameSpace() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MemcacheDeleteRequest setNameSpaceAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.name_space_ = x;
            return this;
        }

        public final String getNameSpace() {
            return ProtocolSupport.toStringUtf8(this.name_space_);
        }

        public MemcacheDeleteRequest setNameSpace(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_space_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getNameSpace(Charset cs) {
            return ProtocolSupport.toString(this.name_space_, cs);
        }

        public MemcacheDeleteRequest setNameSpace(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_space_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public MemcacheDeleteRequest mergeFrom(MemcacheDeleteRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.item_ != null) {
                for (Item v : that.item_) {
                    this.addItem().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.name_space_ = that.name_space_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheDeleteRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheDeleteRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheDeleteRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            int n = this.item_ != null ? this.item_.size() : 0;
            if (n != (that.item_ != null ? that.item_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.item_.get(i).equals(that.item_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.name_space_, that.name_space_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheDeleteRequest && this.equals((MemcacheDeleteRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 8295504;
            hash *= 31;
            int n2 = n = this.item_ != null ? this.item_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.item_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.name_space_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.item_ != null) {
                for (Item v : this.item_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.item_ != null ? this.item_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.item_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.name_space_.length);
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.item_ != null ? this.item_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.item_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.name_space_.length;
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.item_ != null) {
                this.item_.clear();
            }
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheDeleteRequest newInstance() {
            return new MemcacheDeleteRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.item_ != null ? this.item_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Item v = this.item_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.name_space_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 11: {
                        if (this.addItem().merge(source)) continue block5;
                        result = false;
                        break block5;
                    }
                    case 34: {
                        this.name_space_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheDeleteRequest freeze() {
            this.item_ = ProtocolSupport.freezeMessages(this.item_);
            this.name_space_ = ProtocolSupport.freezeString(this.name_space_);
            return this;
        }

        @Override
        public MemcacheDeleteRequest unfreeze() {
            this.item_ = ProtocolSupport.unfreezeMessages(this.item_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.item_);
        }

        static {
            MemcacheDeleteRequest.text[0] = "ErrorCode";
            MemcacheDeleteRequest.text[1] = "Item";
            MemcacheDeleteRequest.text[2] = "key";
            MemcacheDeleteRequest.text[3] = "delete_time";
            MemcacheDeleteRequest.text[4] = "name_space";
            types = new int[5];
            Arrays.fill(types, 6);
            MemcacheDeleteRequest.types[0] = 0;
            MemcacheDeleteRequest.types[1] = 3;
            MemcacheDeleteRequest.types[2] = 2;
            MemcacheDeleteRequest.types[3] = 5;
            MemcacheDeleteRequest.types[4] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheDeleteRequest.class, "Z.apphosting/api/memcache/memcache_service.proto\n apphosting.MemcacheDeleteRequest\u0013\u001a\u0004Item \u0001(\u00030\n8\u0003\u0014\u0013\u001a\bItem.key \u0002(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\u0010Item.delete_time \u0003(\u00050\u00078\u0001B\u00010`\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00010\u00a4\u0001\u0014\u0013\u001a\nname_space \u0004(\u00020\t8\u0001B\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0002\"\"\u00a4\u0001\u0014", new ProtocolType.FieldType("Item", "item", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Item.class), new ProtocolType.FieldType("name_space", "name_space", 4, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Item
        extends ProtocolMessage<Item> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private int delete_time_ = 0;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Item IMMUTABLE_DEFAULT_INSTANCE = new Item(){
                private static final long serialVersionUID = 1L;

                public Item clearKey() {
                    return this;
                }

                public Item setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearDeleteTime() {
                    return this;
                }

                public Item setDeleteTime(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item mergeFrom(Item that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Item freeze() {
                    return this;
                }

                public Item unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public Item clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Item setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8(this.key_);
            }

            public Item setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString(this.key_, cs);
            }

            public Item setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final int getDeleteTime() {
                return this.delete_time_;
            }

            public final boolean hasDeleteTime() {
                return (this.optional_0_ & 2) != 0;
            }

            public Item clearDeleteTime() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.delete_time_ = 0;
                return this;
            }

            public Item setDeleteTime(int x) {
                this.optional_0_ |= 2;
                this.delete_time_ = x;
                return this;
            }

            @Override
            public Item mergeFrom(Item that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.delete_time_ = that.delete_time_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Item that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Item that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Item that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && this.delete_time_ != that.delete_time_) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Item && this.equals((Item)that);
            }

            @Override
            public int hashCode() {
                int hash = 1201602346;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? this.delete_time_ : -113);
                if ((this_t0 & 4) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 1) {
                    return "missing field: Item.key";
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 2 + Protocol.stringSize(this.key_.length);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    n += 5;
                }
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 12 + this.key_.length;
                int this_t0 = this.optional_0_;
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 4;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.delete_time_ = 0;
                this.uninterpreted = null;
            }

            @Override
            public Item newInstance() {
                return new Item();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.key_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    sink.putByte((byte)29);
                    sink.putInt(this.delete_time_);
                }
                if ((this_t0 & 4) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 18: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 29: {
                            this.delete_time_ = source.getInt();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 4;
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Item freeze() {
                this.key_ = ProtocolSupport.freezeString(this.key_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Item.class, null, new ProtocolType.FieldType("key", "key", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("delete_time", "delete_time", 3, 1, ProtocolType.FieldBaseType.FIXED32, ProtocolType.Presence.OPTIONAL));

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheSetResponse
    extends ProtocolMessage<MemcacheSetResponse> {
        private static final long serialVersionUID = 1L;
        private int[] set_status_ = ProtocolSupport.EMPTY_INT_ARRAY;
        private int set_status_elts_;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheSetResponse IMMUTABLE_DEFAULT_INSTANCE = new MemcacheSetResponse(){
            private static final long serialVersionUID = 1L;

            public MemcacheSetResponse clearSetStatus() {
                return this;
            }

            public MemcacheSetResponse setSetStatus(int i, int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheSetResponse addSetStatus(int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheSetResponse mergeFrom(MemcacheSetResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheSetResponse freeze() {
                return this;
            }

            public MemcacheSetResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kset_status = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int setStatusSize() {
            return this.set_status_elts_;
        }

        public final int getSetStatus(int i) {
            assert (i >= 0 && i < this.set_status_elts_);
            return this.set_status_[i];
        }

        public MemcacheSetResponse clearSetStatus() {
            this.set_status_elts_ = 0;
            this.set_status_ = ProtocolSupport.EMPTY_INT_ARRAY;
            return this;
        }

        public MemcacheSetResponse setSetStatus(int i, int v) {
            assert (i >= 0 && i < this.set_status_elts_);
            this.set_status_[i] = v;
            return this;
        }

        public MemcacheSetResponse addSetStatus(int v) {
            if (this.set_status_elts_ == this.set_status_.length) {
                this.set_status_ = ProtocolSupport.growArray(this.set_status_);
            }
            this.set_status_[this.set_status_elts_++] = v;
            return this;
        }

        public final Iterator<Integer> setStatusIterator() {
            return ProtocolSupport.asList(this.set_status_, 0, this.set_status_elts_).iterator();
        }

        public final List<Integer> setStatuss() {
            return ProtocolSupport.asList(this.set_status_, 0, this.set_status_elts_);
        }

        @Override
        public MemcacheSetResponse mergeFrom(MemcacheSetResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.set_status_elts_ > 0) {
                this.set_status_ = ProtocolSupport.ensureCapacity(this.set_status_, this.set_status_elts_ + that.set_status_elts_);
                System.arraycopy(that.set_status_, 0, this.set_status_, this.set_status_elts_, that.set_status_elts_);
                this.set_status_elts_ += that.set_status_elts_;
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheSetResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheSetResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheSetResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.set_status_elts_;
            if (n != that.set_status_elts_) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.set_status_[i] == that.set_status_[i]) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheSetResponse && this.equals((MemcacheSetResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -894774349;
            hash *= 31;
            int n = this.set_status_elts_;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.set_status_[i];
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.set_status_elts_;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.varLongSize(this.set_status_[i]);
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : (n += 11 * this.set_status_elts_);
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.set_status_elts_ = 0;
            this.set_status_ = ProtocolSupport.EMPTY_INT_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheSetResponse newInstance() {
            return new MemcacheSetResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m = this.set_status_elts_;
            for (int i = 0; i < m; ++i) {
                int v = this.set_status_[i];
                sink.putByte((byte)8);
                sink.putVarLong(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 8: {
                        this.addSetStatus(source.getVarInt());
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheSetResponse freeze() {
            this.set_status_ = ProtocolSupport.freezeArray(this.set_status_, this.set_status_elts_);
            return this;
        }

        static {
            MemcacheSetResponse.text[0] = "ErrorCode";
            MemcacheSetResponse.text[1] = "set_status";
            types = new int[2];
            Arrays.fill(types, 6);
            MemcacheSetResponse.types[0] = 0;
            MemcacheSetResponse.types[1] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheSetResponse.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001eapphosting.MemcacheSetResponse\u0013\u001a\nset_status \u0001(\u00000\u00058\u0003h\u0000\u0014sz\rSetStatusCode\u008b\u0001\u0092\u0001\u0006STORED\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\nNOT_STORED\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0005ERROR\u0098\u0001\u0003\u008c\u0001t", new ProtocolType.FieldType("set_status", "set_status", 1, -1, ProtocolType.Presence.REPEATED, SetStatusCode.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SetStatusCode implements ProtocolMessageEnum
        {
            STORED(1),
            NOT_STORED(2),
            ERROR(3);

            public static final SetStatusCode SetStatusCode_MIN;
            public static final SetStatusCode SetStatusCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static SetStatusCode valueOf(int value) {
                switch (value) {
                    case 1: {
                        return STORED;
                    }
                    case 2: {
                        return NOT_STORED;
                    }
                    case 3: {
                        return ERROR;
                    }
                }
                return null;
            }

            private SetStatusCode(int v) {
                this.value = v;
            }

            static {
                SetStatusCode_MIN = STORED;
                SetStatusCode_MAX = ERROR;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheSetRequest
    extends ProtocolMessage<MemcacheSetRequest> {
        private static final long serialVersionUID = 1L;
        private List<Item> item_ = null;
        private byte[] name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheSetRequest IMMUTABLE_DEFAULT_INSTANCE = new MemcacheSetRequest(){
            private static final long serialVersionUID = 1L;

            public MemcacheSetRequest clearItem() {
                return this;
            }

            public Item getMutableItem(int i) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item addItem() {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item addItem(Item v) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item insertItem(int i, Item v) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item removeItem(int i) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public MemcacheSetRequest clearNameSpace() {
                return this;
            }

            public MemcacheSetRequest setNameSpaceAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheSetRequest setNameSpace(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheSetRequest setNameSpace(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheSetRequest mergeFrom(MemcacheSetRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheSetRequest freeze() {
                return this;
            }

            public MemcacheSetRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kItemGroup = 1;
        public static final int kItemkey = 2;
        public static final int kItemvalue = 3;
        public static final int kItemflags = 4;
        public static final int kItemset_policy = 5;
        public static final int kItemexpiration_time = 6;
        public static final int kname_space = 7;
        public static final String[] text = new String[8];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int itemSize() {
            return this.item_ != null ? this.item_.size() : 0;
        }

        public final Item getItem(int i) {
            assert (i >= 0 && i < (this.item_ != null ? this.item_.size() : 0));
            return this.item_.get(i);
        }

        public MemcacheSetRequest clearItem() {
            if (this.item_ != null) {
                this.item_.clear();
            }
            return this;
        }

        public Item getMutableItem(int i) {
            assert (i >= 0 && this.item_ != null && i < this.item_.size());
            return this.item_.get(i);
        }

        public Item addItem() {
            Item v = new Item();
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(v);
            return v;
        }

        public Item addItem(Item v) {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(v);
            return v;
        }

        public Item insertItem(int i, Item v) {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(i, v);
            return v;
        }

        public Item removeItem(int i) {
            return this.item_.remove(i);
        }

        public final Iterator<Item> itemIterator() {
            if (this.item_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.item_.iterator();
        }

        public final List<Item> items() {
            return ProtocolSupport.unmodifiableList(this.item_);
        }

        public final List<Item> mutableItems() {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            return this.item_;
        }

        public final byte[] getNameSpaceAsBytes() {
            return this.name_space_;
        }

        public final boolean hasNameSpace() {
            return (this.optional_0_ & 1) != 0;
        }

        public MemcacheSetRequest clearNameSpace() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MemcacheSetRequest setNameSpaceAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.name_space_ = x;
            return this;
        }

        public final String getNameSpace() {
            return ProtocolSupport.toStringUtf8(this.name_space_);
        }

        public MemcacheSetRequest setNameSpace(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_space_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getNameSpace(Charset cs) {
            return ProtocolSupport.toString(this.name_space_, cs);
        }

        public MemcacheSetRequest setNameSpace(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_space_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public MemcacheSetRequest mergeFrom(MemcacheSetRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.item_ != null) {
                for (Item v : that.item_) {
                    this.addItem().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.name_space_ = that.name_space_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheSetRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheSetRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheSetRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            int n = this.item_ != null ? this.item_.size() : 0;
            if (n != (that.item_ != null ? that.item_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.item_.get(i).equals(that.item_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.name_space_, that.name_space_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheSetRequest && this.equals((MemcacheSetRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -2005122228;
            hash *= 31;
            int n2 = n = this.item_ != null ? this.item_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.item_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.name_space_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.item_ != null) {
                for (Item v : this.item_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.item_ != null ? this.item_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.item_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.name_space_.length);
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.item_ != null ? this.item_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.item_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.name_space_.length;
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.item_ != null) {
                this.item_.clear();
            }
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheSetRequest newInstance() {
            return new MemcacheSetRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.item_ != null ? this.item_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Item v = this.item_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)58);
                sink.putPrefixedData(this.name_space_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 11: {
                        if (this.addItem().merge(source)) continue block5;
                        result = false;
                        break block5;
                    }
                    case 58: {
                        this.name_space_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheSetRequest freeze() {
            this.item_ = ProtocolSupport.freezeMessages(this.item_);
            this.name_space_ = ProtocolSupport.freezeString(this.name_space_);
            return this;
        }

        @Override
        public MemcacheSetRequest unfreeze() {
            this.item_ = ProtocolSupport.unfreezeMessages(this.item_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.item_);
        }

        static {
            MemcacheSetRequest.text[0] = "ErrorCode";
            MemcacheSetRequest.text[1] = "Item";
            MemcacheSetRequest.text[2] = "key";
            MemcacheSetRequest.text[3] = "value";
            MemcacheSetRequest.text[4] = "flags";
            MemcacheSetRequest.text[5] = "set_policy";
            MemcacheSetRequest.text[6] = "expiration_time";
            MemcacheSetRequest.text[7] = "name_space";
            types = new int[8];
            Arrays.fill(types, 6);
            MemcacheSetRequest.types[0] = 0;
            MemcacheSetRequest.types[1] = 3;
            MemcacheSetRequest.types[2] = 2;
            MemcacheSetRequest.types[3] = 2;
            MemcacheSetRequest.types[4] = 5;
            MemcacheSetRequest.types[5] = 0;
            MemcacheSetRequest.types[6] = 5;
            MemcacheSetRequest.types[7] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheSetRequest.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001dapphosting.MemcacheSetRequest\u0013\u001a\u0004Item \u0001(\u00030\n8\u0003\u0014\u0013\u001a\bItem.key \u0002(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\nItem.value \u0003(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\nItem.flags \u0004(\u00050\u00078\u0001`\u0000\u0014\u0013\u001a\u000fItem.set_policy \u0005(\u00000\u00058\u0001B\u00011`\u0000h\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0003SET\u00a4\u0001\u0014\u0013\u001a\u0014Item.expiration_time \u0006(\u00050\u00078\u0001B\u00010`\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00010\u00a4\u0001\u0014\u0013\u001a\nname_space \u0007(\u00020\t8\u0001B\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0002\"\"\u00a4\u0001\u0014sz\tSetPolicy\u008b\u0001\u0092\u0001\u0003SET\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u0003ADD\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0007REPLACE\u0098\u0001\u0003\u008c\u0001t", new ProtocolType.FieldType("Item", "item", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Item.class), new ProtocolType.FieldType("name_space", "name_space", 7, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SetPolicy implements ProtocolMessageEnum
        {
            SET(1),
            ADD(2),
            REPLACE(3);

            public static final SetPolicy SetPolicy_MIN;
            public static final SetPolicy SetPolicy_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static SetPolicy valueOf(int value) {
                switch (value) {
                    case 1: {
                        return SET;
                    }
                    case 2: {
                        return ADD;
                    }
                    case 3: {
                        return REPLACE;
                    }
                }
                return null;
            }

            private SetPolicy(int v) {
                this.value = v;
            }

            static {
                SetPolicy_MIN = SET;
                SetPolicy_MAX = REPLACE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Item
        extends ProtocolMessage<Item> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private int flags_ = 0;
            private int set_policy_ = 1;
            private int expiration_time_ = 0;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Item IMMUTABLE_DEFAULT_INSTANCE = new Item(){
                private static final long serialVersionUID = 1L;

                public Item clearKey() {
                    return this;
                }

                public Item setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearValue() {
                    return this;
                }

                public Item setValueAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setValue(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setValue(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearFlags() {
                    return this;
                }

                public Item setFlags(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearSetPolicy() {
                    return this;
                }

                public Item setSetPolicy(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearExpirationTime() {
                    return this;
                }

                public Item setExpirationTime(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item mergeFrom(Item that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Item freeze() {
                    return this;
                }

                public Item unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public Item clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Item setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8(this.key_);
            }

            public Item setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString(this.key_, cs);
            }

            public Item setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final byte[] getValueAsBytes() {
                return this.value_;
            }

            public final boolean hasValue() {
                return (this.optional_0_ & 2) != 0;
            }

            public Item clearValue() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Item setValueAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.value_ = x;
                return this;
            }

            public final String getValue() {
                return ProtocolSupport.toStringUtf8(this.value_);
            }

            public Item setValue(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getValue(Charset cs) {
                return ProtocolSupport.toString(this.value_, cs);
            }

            public Item setValue(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final int getFlags() {
                return this.flags_;
            }

            public final boolean hasFlags() {
                return (this.optional_0_ & 4) != 0;
            }

            public Item clearFlags() {
                this.optional_0_ &= 0xFFFFFFFB;
                this.flags_ = 0;
                return this;
            }

            public Item setFlags(int x) {
                this.optional_0_ |= 4;
                this.flags_ = x;
                return this;
            }

            public final int getSetPolicy() {
                return this.set_policy_;
            }

            public SetPolicy getSetPolicyEnum() {
                return SetPolicy.valueOf(this.getSetPolicy());
            }

            public final boolean hasSetPolicy() {
                return (this.optional_0_ & 8) != 0;
            }

            public Item clearSetPolicy() {
                this.optional_0_ &= 0xFFFFFFF7;
                this.set_policy_ = 1;
                return this;
            }

            public Item setSetPolicy(int x) {
                this.optional_0_ |= 8;
                this.set_policy_ = x;
                return this;
            }

            public Item setSetPolicy(SetPolicy x) {
                if (x == null) {
                    this.optional_0_ &= 0xFFFFFFF7;
                    this.set_policy_ = 1;
                } else {
                    this.setSetPolicy(x.getValue());
                }
                return this;
            }

            public final int getExpirationTime() {
                return this.expiration_time_;
            }

            public final boolean hasExpirationTime() {
                return (this.optional_0_ & 0x10) != 0;
            }

            public Item clearExpirationTime() {
                this.optional_0_ &= 0xFFFFFFEF;
                this.expiration_time_ = 0;
                return this;
            }

            public Item setExpirationTime(int x) {
                this.optional_0_ |= 0x10;
                this.expiration_time_ = x;
                return this;
            }

            @Override
            public Item mergeFrom(Item that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.value_ = that.value_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    this.flags_ = that.flags_;
                }
                if ((that_t0 & 8) != 0) {
                    this_t0 |= 8;
                    this.set_policy_ = that.set_policy_;
                }
                if ((that_t0 & 0x10) != 0) {
                    this_t0 |= 0x10;
                    this.expiration_time_ = that.expiration_time_;
                }
                if ((that_t0 & 0x20) != 0) {
                    this_t0 |= 0x20;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Item that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Item that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Item that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFDF) != (that_t0 & 0xFFFFFFDF)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.value_, that.value_)) {
                    return false;
                }
                if ((this_t0 & 4) != 0 && this.flags_ != that.flags_) {
                    return false;
                }
                if ((this_t0 & 8) != 0 && this.set_policy_ != that.set_policy_) {
                    return false;
                }
                if ((this_t0 & 0x10) != 0 && this.expiration_time_ != that.expiration_time_) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 0x20) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Item && this.equals((Item)that);
            }

            @Override
            public int hashCode() {
                int hash = 1201602346;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.value_) : -113);
                hash = hash * 31 + ((this_t0 & 4) != 0 ? this.flags_ : -113);
                hash = hash * 31 + ((this_t0 & 8) != 0 ? this.set_policy_ : -113);
                hash = hash * 31 + ((this_t0 & 0x10) != 0 ? this.expiration_time_ : -113);
                if ((this_t0 & 0x20) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return "missing field: Item.key";
                    }
                    return "missing field: Item.value";
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 3 + Protocol.stringSize(this.key_.length) + Protocol.stringSize(this.value_.length);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 0x1C) != 0) {
                    if ((this_t0 & 4) != 0) {
                        n += 5;
                    }
                    if ((this_t0 & 8) != 0) {
                        n += 1 + Protocol.varLongSize(this.set_policy_);
                    }
                    if ((this_t0 & 0x10) != 0) {
                        n += 5;
                    }
                }
                return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 34 + this.key_.length + this.value_.length;
                int this_t0 = this.optional_0_;
                return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 0x20;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.flags_ = 0;
                this.set_policy_ = 1;
                this.expiration_time_ = 0;
                this.uninterpreted = null;
            }

            @Override
            public Item newInstance() {
                return new Item();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.key_);
                sink.putByte((byte)26);
                sink.putPrefixedData(this.value_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    sink.putByte((byte)37);
                    sink.putInt(this.flags_);
                }
                if ((this_t0 & 8) != 0) {
                    sink.putByte((byte)40);
                    sink.putVarLong(this.set_policy_);
                }
                if ((this_t0 & 0x10) != 0) {
                    sink.putByte((byte)53);
                    sink.putInt(this.expiration_time_);
                }
                if ((this_t0 & 0x20) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block9: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block9;
                        }
                        case 0: {
                            result = false;
                            break block9;
                        }
                        case 18: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block9;
                        }
                        case 26: {
                            this.value_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block9;
                        }
                        case 37: {
                            this.flags_ = source.getInt();
                            this_t0 |= 4;
                            continue block9;
                        }
                        case 40: {
                            this.set_policy_ = source.getVarInt();
                            this_t0 |= 8;
                            continue block9;
                        }
                        case 53: {
                            this.expiration_time_ = source.getInt();
                            this_t0 |= 0x10;
                            continue block9;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 0x20;
                            continue block9;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Item freeze() {
                this.key_ = ProtocolSupport.freezeString(this.key_);
                this.value_ = ProtocolSupport.freezeString(this.value_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Item.class, null, new ProtocolType.FieldType("key", "key", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("value", "value", 3, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("flags", "flags", 4, 2, ProtocolType.FieldBaseType.FIXED32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("set_policy", "set_policy", 5, 3, ProtocolType.Presence.OPTIONAL, SetPolicy.class), new ProtocolType.FieldType("expiration_time", "expiration_time", 6, 4, ProtocolType.FieldBaseType.FIXED32, ProtocolType.Presence.OPTIONAL));

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheGetResponse
    extends ProtocolMessage<MemcacheGetResponse> {
        private static final long serialVersionUID = 1L;
        private List<Item> item_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheGetResponse IMMUTABLE_DEFAULT_INSTANCE = new MemcacheGetResponse(){
            private static final long serialVersionUID = 1L;

            public MemcacheGetResponse clearItem() {
                return this;
            }

            public Item getMutableItem(int i) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item addItem() {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item addItem(Item v) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item insertItem(int i, Item v) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public Item removeItem(int i) {
                return (Item)ProtocolSupport.unsupportedOperation();
            }

            public MemcacheGetResponse mergeFrom(MemcacheGetResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheGetResponse freeze() {
                return this;
            }

            public MemcacheGetResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kItemGroup = 1;
        public static final int kItemkey = 2;
        public static final int kItemvalue = 3;
        public static final int kItemflags = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int itemSize() {
            return this.item_ != null ? this.item_.size() : 0;
        }

        public final Item getItem(int i) {
            assert (i >= 0 && i < (this.item_ != null ? this.item_.size() : 0));
            return this.item_.get(i);
        }

        public MemcacheGetResponse clearItem() {
            if (this.item_ != null) {
                this.item_.clear();
            }
            return this;
        }

        public Item getMutableItem(int i) {
            assert (i >= 0 && this.item_ != null && i < this.item_.size());
            return this.item_.get(i);
        }

        public Item addItem() {
            Item v = new Item();
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(v);
            return v;
        }

        public Item addItem(Item v) {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(v);
            return v;
        }

        public Item insertItem(int i, Item v) {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            this.item_.add(i, v);
            return v;
        }

        public Item removeItem(int i) {
            return this.item_.remove(i);
        }

        public final Iterator<Item> itemIterator() {
            if (this.item_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.item_.iterator();
        }

        public final List<Item> items() {
            return ProtocolSupport.unmodifiableList(this.item_);
        }

        public final List<Item> mutableItems() {
            if (this.item_ == null) {
                this.item_ = new ArrayList<Item>(4);
            }
            return this.item_;
        }

        @Override
        public MemcacheGetResponse mergeFrom(MemcacheGetResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.item_ != null) {
                for (Item v : that.item_) {
                    this.addItem().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheGetResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheGetResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheGetResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.item_ != null ? this.item_.size() : 0;
            if (n != (that.item_ != null ? that.item_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.item_.get(i).equals(that.item_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheGetResponse && this.equals((MemcacheGetResponse)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 1686779062;
            hash *= 31;
            int n2 = n = this.item_ != null ? this.item_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.item_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.item_ != null) {
                for (Item v : this.item_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.item_ != null ? this.item_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.item_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.item_ != null ? this.item_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.item_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.item_ != null) {
                this.item_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public MemcacheGetResponse newInstance() {
            return new MemcacheGetResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.item_ != null ? this.item_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Item v = this.item_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 11: {
                        if (this.addItem().merge(source)) continue block4;
                        result = false;
                        break block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheGetResponse freeze() {
            this.item_ = ProtocolSupport.freezeMessages(this.item_);
            return this;
        }

        @Override
        public MemcacheGetResponse unfreeze() {
            this.item_ = ProtocolSupport.unfreezeMessages(this.item_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.item_);
        }

        static {
            MemcacheGetResponse.text[0] = "ErrorCode";
            MemcacheGetResponse.text[1] = "Item";
            MemcacheGetResponse.text[2] = "key";
            MemcacheGetResponse.text[3] = "value";
            MemcacheGetResponse.text[4] = "flags";
            types = new int[5];
            Arrays.fill(types, 6);
            MemcacheGetResponse.types[0] = 0;
            MemcacheGetResponse.types[1] = 3;
            MemcacheGetResponse.types[2] = 2;
            MemcacheGetResponse.types[3] = 2;
            MemcacheGetResponse.types[4] = 5;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheGetResponse.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001eapphosting.MemcacheGetResponse\u0013\u001a\u0004Item \u0001(\u00030\n8\u0003\u0014\u0013\u001a\bItem.key \u0002(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\nItem.value \u0003(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\nItem.flags \u0004(\u00050\u00078\u0001`\u0000\u0014", new ProtocolType.FieldType("Item", "item", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Item.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Item
        extends ProtocolMessage<Item> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private int flags_ = 0;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Item IMMUTABLE_DEFAULT_INSTANCE = new Item(){
                private static final long serialVersionUID = 1L;

                public Item clearKey() {
                    return this;
                }

                public Item setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearValue() {
                    return this;
                }

                public Item setValueAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setValue(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item setValue(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item clearFlags() {
                    return this;
                }

                public Item setFlags(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Item mergeFrom(Item that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Item freeze() {
                    return this;
                }

                public Item unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public Item clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Item setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8(this.key_);
            }

            public Item setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString(this.key_, cs);
            }

            public Item setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final byte[] getValueAsBytes() {
                return this.value_;
            }

            public final boolean hasValue() {
                return (this.optional_0_ & 2) != 0;
            }

            public Item clearValue() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Item setValueAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.value_ = x;
                return this;
            }

            public final String getValue() {
                return ProtocolSupport.toStringUtf8(this.value_);
            }

            public Item setValue(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getValue(Charset cs) {
                return ProtocolSupport.toString(this.value_, cs);
            }

            public Item setValue(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final int getFlags() {
                return this.flags_;
            }

            public final boolean hasFlags() {
                return (this.optional_0_ & 4) != 0;
            }

            public Item clearFlags() {
                this.optional_0_ &= 0xFFFFFFFB;
                this.flags_ = 0;
                return this;
            }

            public Item setFlags(int x) {
                this.optional_0_ |= 4;
                this.flags_ = x;
                return this;
            }

            @Override
            public Item mergeFrom(Item that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.value_ = that.value_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    this.flags_ = that.flags_;
                }
                if ((that_t0 & 8) != 0) {
                    this_t0 |= 8;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Item that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Item that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Item that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFF7) != (that_t0 & 0xFFFFFFF7)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.value_, that.value_)) {
                    return false;
                }
                if ((this_t0 & 4) != 0 && this.flags_ != that.flags_) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 8) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Item && this.equals((Item)that);
            }

            @Override
            public int hashCode() {
                int hash = 1201602346;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.value_) : -113);
                hash = hash * 31 + ((this_t0 & 4) != 0 ? this.flags_ : -113);
                if ((this_t0 & 8) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return "missing field: Item.key";
                    }
                    return "missing field: Item.value";
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 3 + Protocol.stringSize(this.key_.length) + Protocol.stringSize(this.value_.length);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    n += 5;
                }
                return (this_t0 & 8) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 18 + this.key_.length + this.value_.length;
                int this_t0 = this.optional_0_;
                return (this_t0 & 8) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 8;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.flags_ = 0;
                this.uninterpreted = null;
            }

            @Override
            public Item newInstance() {
                return new Item();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.key_);
                sink.putByte((byte)26);
                sink.putPrefixedData(this.value_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    sink.putByte((byte)37);
                    sink.putInt(this.flags_);
                }
                if ((this_t0 & 8) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block7: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block7;
                        }
                        case 0: {
                            result = false;
                            break block7;
                        }
                        case 18: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block7;
                        }
                        case 26: {
                            this.value_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block7;
                        }
                        case 37: {
                            this.flags_ = source.getInt();
                            this_t0 |= 4;
                            continue block7;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 8;
                            continue block7;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Item freeze() {
                this.key_ = ProtocolSupport.freezeString(this.key_);
                this.value_ = ProtocolSupport.freezeString(this.value_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Item.class, null, new ProtocolType.FieldType("key", "key", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("value", "value", 3, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("flags", "flags", 4, 2, ProtocolType.FieldBaseType.FIXED32, ProtocolType.Presence.OPTIONAL));

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheGetRequest
    extends ProtocolMessage<MemcacheGetRequest> {
        private static final long serialVersionUID = 1L;
        private List<byte[]> key_ = null;
        private byte[] name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheGetRequest IMMUTABLE_DEFAULT_INSTANCE = new MemcacheGetRequest(){
            private static final long serialVersionUID = 1L;

            public MemcacheGetRequest clearKey() {
                return this;
            }

            public MemcacheGetRequest setKeyAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest setKey(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest addKeyAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest addKey(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest setKey(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest addKey(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest clearNameSpace() {
                return this;
            }

            public MemcacheGetRequest setNameSpaceAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest setNameSpace(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest setNameSpace(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MemcacheGetRequest mergeFrom(MemcacheGetRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheGetRequest freeze() {
                return this;
            }

            public MemcacheGetRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kkey = 1;
        public static final int kname_space = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int keySize() {
            return this.key_ != null ? this.key_.size() : 0;
        }

        public final byte[] getKeyAsBytes(int i) {
            assert (i >= 0 && i < (this.key_ != null ? this.key_.size() : 0));
            return this.key_.get(i);
        }

        public MemcacheGetRequest clearKey() {
            if (this.key_ != null) {
                this.key_.clear();
            }
            return this;
        }

        public final String getKey(int i) {
            return ProtocolSupport.toStringUtf8(this.key_.get(i));
        }

        public MemcacheGetRequest setKeyAsBytes(int i, byte[] v) {
            this.key_.set(i, v);
            return this;
        }

        public MemcacheGetRequest setKey(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.key_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MemcacheGetRequest addKeyAsBytes(byte[] v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<byte[]>(4);
            }
            this.key_.add(v);
            return this;
        }

        public MemcacheGetRequest addKey(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.key_ == null) {
                this.key_ = new ArrayList<byte[]>(4);
            }
            this.key_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> keyIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.key_);
        }

        public final List<String> keys() {
            return ProtocolSupport.byteArrayToUnicodeList(this.key_);
        }

        public final Iterator<byte[]> keyAsBytesIterator() {
            return this.key_ == null ? ProtocolSupport.emptyIterator() : this.key_.iterator();
        }

        public final List<byte[]> keysAsBytes() {
            return ProtocolSupport.unmodifiableList(this.key_);
        }

        public final List<byte[]> mutableKeysAsBytes() {
            if (this.key_ == null) {
                this.key_ = new ArrayList<byte[]>(4);
            }
            return this.key_;
        }

        public final String getKey(int i, Charset cs) {
            return ProtocolSupport.toString(this.key_.get(i), cs);
        }

        public MemcacheGetRequest setKey(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.key_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MemcacheGetRequest addKey(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.key_ == null) {
                this.key_ = new ArrayList<byte[]>(4);
            }
            this.key_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> keyIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.key_, cs);
        }

        public final List<String> keys(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.key_, cs);
        }

        public final byte[] getNameSpaceAsBytes() {
            return this.name_space_;
        }

        public final boolean hasNameSpace() {
            return (this.optional_0_ & 1) != 0;
        }

        public MemcacheGetRequest clearNameSpace() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MemcacheGetRequest setNameSpaceAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.name_space_ = x;
            return this;
        }

        public final String getNameSpace() {
            return ProtocolSupport.toStringUtf8(this.name_space_);
        }

        public MemcacheGetRequest setNameSpace(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_space_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getNameSpace(Charset cs) {
            return ProtocolSupport.toString(this.name_space_, cs);
        }

        public MemcacheGetRequest setNameSpace(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_space_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public MemcacheGetRequest mergeFrom(MemcacheGetRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.key_ != null && that.key_.size() > 0) {
                if (this.key_ == null) {
                    this.key_ = new ArrayList<byte[]>(that.key_);
                } else {
                    this.key_.addAll(that.key_);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.name_space_ = that.name_space_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheGetRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheGetRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheGetRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            int n = this.key_ != null ? this.key_.size() : 0;
            if (n != (that.key_ != null ? that.key_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.key_.get(i), that.key_.get(i))) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.name_space_, that.name_space_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheGetRequest && this.equals((MemcacheGetRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -117418490;
            hash *= 31;
            int n2 = n = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.key_.get(i));
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.name_space_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.key_.get(i).length);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.name_space_.length);
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.key_.get(i).length;
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.name_space_.length;
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.key_ != null) {
                this.key_.clear();
            }
            this.name_space_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheGetRequest newInstance() {
            return new MemcacheGetRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.key_.get(i);
                sink.putByte((byte)10);
                sink.putPrefixedData(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.name_space_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.addKeyAsBytes(source.getPrefixedData());
                        continue block5;
                    }
                    case 18: {
                        this.name_space_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MemcacheGetRequest freeze() {
            this.key_ = ProtocolSupport.freezeStrings(this.key_);
            this.name_space_ = ProtocolSupport.freezeString(this.name_space_);
            return this;
        }

        @Override
        public MemcacheGetRequest unfreeze() {
            this.key_ = ProtocolSupport.unfreezeStrings(this.key_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.key_);
        }

        static {
            MemcacheGetRequest.text[0] = "ErrorCode";
            MemcacheGetRequest.text[1] = "key";
            MemcacheGetRequest.text[2] = "name_space";
            types = new int[3];
            Arrays.fill(types, 6);
            MemcacheGetRequest.types[0] = 0;
            MemcacheGetRequest.types[1] = 2;
            MemcacheGetRequest.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheGetRequest.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001dapphosting.MemcacheGetRequest\u0013\u001a\u0003key \u0001(\u00020\t8\u0003\u0014\u0013\u001a\nname_space \u0002(\u00020\t8\u0001B\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0002\"\"\u00a4\u0001\u0014", new ProtocolType.FieldType("key", "key", 1, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("name_space", "name_space", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemcacheServiceError
    extends ProtocolMessage<MemcacheServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MemcacheServiceError IMMUTABLE_DEFAULT_INSTANCE = new MemcacheServiceError(){
            private static final long serialVersionUID = 1L;

            public MemcacheServiceError mergeFrom(MemcacheServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MemcacheServiceError freeze() {
                return this;
            }

            public MemcacheServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public MemcacheServiceError mergeFrom(MemcacheServiceError that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MemcacheServiceError that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MemcacheServiceError that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MemcacheServiceError that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MemcacheServiceError && this.equals((MemcacheServiceError)that);
        }

        @Override
        public int hashCode() {
            int hash = -615263633;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public MemcacheServiceError newInstance() {
            return new MemcacheServiceError();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MemcacheServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            MemcacheServiceError.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MemcacheServiceError.class, "Z.apphosting/api/memcache/memcache_service.proto\n\u001fapphosting.MemcacheServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0002OK\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u0011UNSPECIFIED_ERROR\u0098\u0001\u0001\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            OK(0),
            UNSPECIFIED_ERROR(1);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 0: {
                        return OK;
                    }
                    case 1: {
                        return UNSPECIFIED_ERROR;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = OK;
                ErrorCode_MAX = UNSPECIFIED_ERROR;
            }
        }
    }
}

