/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.ee.jms;

import javax.inject.ExecutionException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.ee.jms.ConnectionContextual;
import org.jboss.webbeans.bean.ee.jms.JmsMethodHandler;
import org.jboss.webbeans.bean.ee.jms.MessageConsumerContextual;
import org.jboss.webbeans.bean.ee.jms.MessageProducerContextual;
import org.jboss.webbeans.bean.ee.jms.SessionContextual;
import org.jboss.webbeans.messaging.spi.JmsServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JmsQueueMethodHandler
extends JmsMethodHandler<QueueConnection, QueueSession, QueueSender, QueueReceiver> {
    private static final long serialVersionUID = -1498128944732531956L;
    private final ConnectionContextual<QueueConnection> connectionContexual;
    private final SessionContextual<QueueSession> sessionContextual;
    private final MessageProducerContextual<QueueSender> messageProducerContextual;
    private final MessageConsumerContextual<QueueReceiver> messageConsumerContextual;

    public JmsQueueMethodHandler(String jndiName, String mappedName) {
        super(jndiName, mappedName);
        final JmsServices jmsServices = CurrentManager.rootManager().getServices().get(JmsServices.class);
        this.connectionContexual = new ConnectionContextual<QueueConnection>(){
            private static final long serialVersionUID = 7830020942920371399L;

            @Override
            protected QueueConnection createConnection() throws JMSException {
                return jmsServices.getQueueConnectionFactory().createQueueConnection();
            }
        };
        this.sessionContextual = new SessionContextual<QueueSession>(){
            private static final long serialVersionUID = -5964106446504141417L;

            @Override
            protected QueueSession createSession() throws JMSException {
                return JmsQueueMethodHandler.this.createSessionFromConnection(JmsQueueMethodHandler.this.connectionContexual);
            }
        };
        this.messageProducerContextual = new MessageProducerContextual<QueueSender>(){
            private static final long serialVersionUID = 3215720243380210179L;

            @Override
            protected QueueSender createMessageProducer() throws JMSException {
                Queue queue = (Queue)jmsServices.resolveDestination(JmsQueueMethodHandler.this.getJndiName(), JmsQueueMethodHandler.this.getMappedName());
                try {
                    return JmsQueueMethodHandler.this.createSessionFromConnection(JmsQueueMethodHandler.this.connectionContexual).createSender(queue);
                }
                catch (JMSException e) {
                    throw new ExecutionException("Error creating QueueSender", e);
                }
            }
        };
        this.messageConsumerContextual = new MessageConsumerContextual<QueueReceiver>(){
            private static final long serialVersionUID = -5461921479716229659L;

            @Override
            protected QueueReceiver createMessageConsumer() throws JMSException {
                Queue queue = (Queue)jmsServices.resolveDestination(JmsQueueMethodHandler.this.getJndiName(), JmsQueueMethodHandler.this.getMappedName());
                try {
                    return JmsQueueMethodHandler.this.createSessionFromConnection(JmsQueueMethodHandler.this.connectionContexual).createReceiver(queue);
                }
                catch (JMSException e) {
                    throw new ExecutionException("Error creating QueueReceiver", e);
                }
            }
        };
    }

    @Override
    protected QueueSession createSessionFromConnection(ConnectionContextual<QueueConnection> connectionContexual) {
        try {
            return this.getConnection(connectionContexual).createQueueSession(false, 1);
        }
        catch (JMSException e) {
            throw new ExecutionException("Error creating session", e);
        }
    }

    @Override
    protected ConnectionContextual<QueueConnection> getConnectionContextual() {
        return this.connectionContexual;
    }

    @Override
    protected MessageConsumerContextual<QueueReceiver> getMessageConsumerContextual() {
        return this.messageConsumerContextual;
    }

    @Override
    protected MessageProducerContextual<QueueSender> getMessageProducerContextual() {
        return this.messageProducerContextual;
    }

    @Override
    protected SessionContextual<QueueSession> getSessionContextual() {
        return this.sessionContextual;
    }
}

