/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.util.Arrays;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignatureImpl
implements MethodSignature {
    private final String methodName;
    private final String[] parameterTypes;

    public MethodSignatureImpl(AnnotatedMethod<?> method) {
        this.methodName = method.getName();
        this.parameterTypes = new String[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            this.parameterTypes[i] = method.getParameters().get(i).getRawType().getName();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodSignatureImpl) {
            MethodSignature that = (MethodSignature)obj;
            return this.getMethodName().equals(that.getMethodName()) && Arrays.equals(this.getParameterTypes(), that.getParameterTypes());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode += this.getMethodName().hashCode() * 5;
        return hashCode += this.getParameterTypes().hashCode() * 7;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return this.getMethodName() + Arrays.asList(this.getParameterTypes()).toString().replace('[', '(').replace(']', ')');
    }
}

