/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.version.undo.Change;

abstract class AbstractChoice
extends FormComponent {
    private static final long serialVersionUID = 1L;
    private IModel choices;
    private IChoiceRenderer renderer;

    public AbstractChoice(String id) {
        this(id, (IModel)new Model(new ArrayList()), (IChoiceRenderer)new ChoiceRenderer());
    }

    public AbstractChoice(String id, List choices) {
        this(id, (IModel)new Model((Serializable)((Object)choices)), (IChoiceRenderer)new ChoiceRenderer());
    }

    public AbstractChoice(String id, List choices, IChoiceRenderer renderer) {
        this(id, (IModel)new Model((Serializable)((Object)choices)), renderer);
    }

    public AbstractChoice(String id, IModel model, List choices) {
        this(id, model, new Model((Serializable)((Object)choices)), (IChoiceRenderer)new ChoiceRenderer());
    }

    public AbstractChoice(String id, IModel model, List choices, IChoiceRenderer renderer) {
        this(id, model, new Model((Serializable)((Object)choices)), renderer);
    }

    public AbstractChoice(String id, IModel choices) {
        this(id, choices, (IChoiceRenderer)new ChoiceRenderer());
    }

    public AbstractChoice(String id, IModel choices, IChoiceRenderer renderer) {
        super(id);
        this.choices = this.wrap(choices);
        this.setChoiceRenderer(renderer);
    }

    public AbstractChoice(String id, IModel model, IModel choices) {
        this(id, model, choices, (IChoiceRenderer)new ChoiceRenderer());
    }

    public AbstractChoice(String id, IModel model, IModel choices, IChoiceRenderer renderer) {
        super(id, model);
        this.choices = this.wrap(choices);
        this.setChoiceRenderer(renderer);
    }

    public List getChoices() {
        List choices;
        List list = choices = this.choices != null ? (List)this.choices.getObject() : null;
        if (choices == null) {
            throw new NullPointerException("List of choices is null - Was the supplied 'Choices' model empty?");
        }
        return choices;
    }

    public final AbstractChoice setChoices(IModel choices) {
        if (this.choices != null && this.choices != choices && this.isVersioned()) {
            this.addStateChange(new ChoicesListChange());
        }
        this.choices = this.wrap(choices);
        return this;
    }

    public final AbstractChoice setChoices(List choices) {
        if (this.choices != null && this.isVersioned()) {
            this.addStateChange(new ChoicesListChange());
        }
        this.choices = new Model((Serializable)((Object)choices));
        return this;
    }

    public final IChoiceRenderer getChoiceRenderer() {
        return this.renderer;
    }

    public final AbstractChoice setChoiceRenderer(IChoiceRenderer renderer) {
        if (renderer == null) {
            renderer = new ChoiceRenderer();
        }
        this.renderer = renderer;
        return this;
    }

    protected void detachModel() {
        super.detachModel();
        if (this.choices != null) {
            this.choices.detach();
        }
    }

    protected CharSequence getDefaultChoice(Object selected) {
        return "";
    }

    protected abstract boolean isSelected(Object var1, int var2, String var3);

    protected boolean isDisabled(Object object, int index, String selected) {
        return false;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer(choices.size() * 50 + 16);
        String selected = this.getValue();
        buffer.append(this.getDefaultChoice(selected));
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            this.appendOptionHtml(buffer, choice, index, selected);
        }
        buffer.append("\n");
        this.replaceComponentTagBody(markupStream, openTag, buffer);
    }

    protected void appendOptionHtml(AppendingStringBuffer buffer, Object choice, int index, String selected) {
        Object objectValue = this.renderer.getDisplayValue(choice);
        Class<?> objectClass = objectValue == null ? null : objectValue.getClass();
        String displayValue = "";
        if (objectClass != null && objectClass != String.class) {
            displayValue = this.getConverter(objectClass).convertToString(objectValue, this.getLocale());
        } else if (objectValue != null) {
            displayValue = objectValue.toString();
        }
        buffer.append("\n<option ");
        if (this.isSelected(choice, index, selected)) {
            buffer.append("selected=\"selected\" ");
        }
        if (this.isDisabled(choice, index, selected)) {
            buffer.append("disabled=\"disabled\" ");
        }
        buffer.append("value=\"");
        buffer.append(Strings.escapeMarkup(this.renderer.getIdValue(choice, index)));
        buffer.append("\">");
        String display = displayValue;
        if (this.localizeDisplayValues()) {
            display = this.getLocalizer().getString(displayValue, (Component)this, displayValue);
        }
        CharSequence escaped = display;
        if (this.getEscapeModelStrings()) {
            escaped = this.escapeOptionHtml(display);
        }
        buffer.append(escaped);
        buffer.append("</option>");
    }

    protected CharSequence escapeOptionHtml(String displayValue) {
        return Strings.escapeMarkup(displayValue, false, true);
    }

    protected boolean supportsPersistence() {
        return true;
    }

    protected boolean localizeDisplayValues() {
        return false;
    }

    private class ChoicesListChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IModel oldChoices;

        public ChoicesListChange() {
            this.oldChoices = AbstractChoice.this.choices;
        }

        public void undo() {
            AbstractChoice.this.choices = this.oldChoices;
        }

        public String toString() {
            return "ChoiceListChange[component: " + AbstractChoice.this.getPath() + ", old choices: " + this.oldChoices + "]";
        }
    }
}

