/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.util.upload.FileItem;

public class FileUploadField
extends FormComponent {
    private static final long serialVersionUID = 1L;
    private boolean hasExplicitModel;
    private transient FileUpload fileUpload;

    public FileUploadField(String id) {
        super(id);
    }

    public FileUploadField(String id, IModel model) {
        super(id, model);
        this.hasExplicitModel = true;
    }

    public FileUpload getFileUpload() {
        FileItem item;
        Request request = this.getRequest();
        if (request instanceof IMultipartWebRequest && (item = ((IMultipartWebRequest)((Object)request)).getFile(this.getInputName())) != null && item.getSize() > 0L) {
            if (this.fileUpload == null) {
                this.fileUpload = new FileUpload(item);
            }
            return this.fileUpload;
        }
        return null;
    }

    public Component setModel(IModel model) {
        this.hasExplicitModel = true;
        return super.setModel(model);
    }

    public void updateModel() {
        if (this.hasExplicitModel) {
            this.setModelObject(this.getFileUpload());
        }
    }

    public String[] getInputAsArray() {
        FileUpload fu = this.getFileUpload();
        if (fu != null) {
            return new String[]{fu.getClientFileName()};
        }
        return null;
    }

    public boolean isMultiPart() {
        return true;
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "file");
        super.onComponentTag(tag);
    }

    protected boolean supportsPersistence() {
        return false;
    }

    protected void onDetach() {
        if (this.fileUpload != null && this.forceCloseStreamsOnDetach()) {
            this.fileUpload.closeStreams();
            this.fileUpload = null;
        }
        super.onDetach();
    }

    protected boolean forceCloseStreamsOnDetach() {
        return true;
    }
}

