/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.wicket.IClusterable;
import org.apache.wicket.markup.html.tree.ITreeState;
import org.apache.wicket.markup.html.tree.ITreeStateListener;

public class DefaultTreeState
implements ITreeState,
IClusterable {
    private static final long serialVersionUID = 1L;
    private boolean allowSelectMultiple = false;
    private final List listeners = new ArrayList(1);
    private final Set nodes = new HashSet();
    private boolean nodesCollapsed = false;
    private final Set selectedNodes = new HashSet();

    public void addTreeStateListener(ITreeStateListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void collapseAll() {
        if (!this.nodes.isEmpty() || this.nodesCollapsed) {
            this.nodes.clear();
            this.nodesCollapsed = false;
            Object[] listenersCopy = this.listeners.toArray();
            for (int i = 0; i < listenersCopy.length; ++i) {
                ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
                l.allNodesCollapsed();
            }
        }
    }

    public void collapseNode(TreeNode node) {
        if (this.nodesCollapsed) {
            this.nodes.add(node);
        } else {
            this.nodes.remove(node);
        }
        Object[] listenersCopy = this.listeners.toArray();
        for (int i = 0; i < listenersCopy.length; ++i) {
            ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
            l.nodeCollapsed(node);
        }
    }

    public void expandAll() {
        if (!this.nodes.isEmpty() || !this.nodesCollapsed) {
            this.nodes.clear();
            this.nodesCollapsed = true;
            Object[] listenersCopy = this.listeners.toArray();
            for (int i = 0; i < listenersCopy.length; ++i) {
                ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
                l.allNodesExpanded();
            }
        }
    }

    public void expandNode(TreeNode node) {
        if (!this.nodesCollapsed) {
            this.nodes.add(node);
        } else {
            this.nodes.remove(node);
        }
        Object[] listenersCopy = this.listeners.toArray();
        for (int i = 0; i < listenersCopy.length; ++i) {
            ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
            l.nodeExpanded(node);
        }
    }

    public Collection getSelectedNodes() {
        return Collections.unmodifiableList(new ArrayList(this.selectedNodes));
    }

    public boolean isAllowSelectMultiple() {
        return this.allowSelectMultiple;
    }

    public boolean isNodeExpanded(TreeNode node) {
        if (!this.nodesCollapsed) {
            return this.nodes.contains(node);
        }
        return !this.nodes.contains(node);
    }

    public boolean isNodeSelected(TreeNode node) {
        return this.selectedNodes.contains(node);
    }

    public void removeTreeStateListener(ITreeStateListener l) {
        this.listeners.remove(l);
    }

    public void selectNode(TreeNode node, boolean selected) {
        block6: {
            ITreeStateListener l;
            Object[] listenersCopy;
            block5: {
                if (!this.isAllowSelectMultiple() && this.selectedNodes.size() > 0) {
                    Iterator i = this.selectedNodes.iterator();
                    while (i.hasNext()) {
                        TreeNode current = (TreeNode)i.next();
                        if (current.equals(node)) continue;
                        i.remove();
                        Object[] listenersCopy2 = this.listeners.toArray();
                        for (int j = 0; j < listenersCopy2.length; ++j) {
                            ITreeStateListener l2 = (ITreeStateListener)listenersCopy2[j];
                            l2.nodeUnselected(current);
                        }
                    }
                }
                if (!selected || this.selectedNodes.contains(node)) break block5;
                this.selectedNodes.add(node);
                listenersCopy = this.listeners.toArray();
                for (int i = 0; i < listenersCopy.length; ++i) {
                    l = (ITreeStateListener)listenersCopy[i];
                    l.nodeSelected(node);
                }
                break block6;
            }
            if (selected || !this.selectedNodes.contains(node)) break block6;
            this.selectedNodes.remove(node);
            listenersCopy = this.listeners.toArray();
            for (int i = 0; i < listenersCopy.length; ++i) {
                l = (ITreeStateListener)listenersCopy[i];
                l.nodeUnselected(node);
            }
        }
    }

    public void setAllowSelectMultiple(boolean value) {
        this.allowSelectMultiple = value;
    }
}

