/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.PropertyVariableInterpolator;

public class StringResourceModel
extends LoadableDetachableModel
implements IComponentAssignedModel {
    private static final long serialVersionUID = 1L;
    private transient Locale locale;
    private transient Localizer localizer;
    private final IModel model;
    private final Object[] parameters;
    private Component component;
    private final String resourceKey;
    private final String defaultValue;

    public IWrapModel wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component);
    }

    public StringResourceModel(String resourceKey, Component component, IModel model) {
        this(resourceKey, component, model, null, null);
    }

    public StringResourceModel(String resourceKey, Component component, IModel model, String defaultValue) {
        this(resourceKey, component, model, null, defaultValue);
    }

    public StringResourceModel(String resourceKey, Component component, IModel model, Object[] parameters) {
        this(resourceKey, component, model, parameters, null);
    }

    public StringResourceModel(String resourceKey, Component component, IModel model, Object[] parameters, String defaultValue) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("Resource key must not be null");
        }
        this.resourceKey = resourceKey;
        this.component = component;
        this.model = model;
        this.parameters = parameters;
        this.defaultValue = defaultValue;
    }

    public StringResourceModel(String resourceKey, IModel model) {
        this(resourceKey, null, model, null, null);
    }

    public StringResourceModel(String resourceKey, IModel model, String defaultValue) {
        this(resourceKey, null, model, null, defaultValue);
    }

    public StringResourceModel(String resourceKey, IModel model, Object[] parameters) {
        this(resourceKey, null, model, parameters, null);
    }

    public StringResourceModel(String resourceKey, IModel model, Object[] parameters, String defaultValue) {
        this(resourceKey, null, model, parameters, defaultValue);
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public final String getString() {
        if (this.getLocalizer() == null) {
            if (this.component != null) {
                this.setLocalizer(this.component.getLocalizer());
            } else {
                throw new IllegalStateException("No localizer has been set");
            }
        }
        if (this.locale == null) {
            this.locale = Session.get().getLocale();
        }
        String value = null;
        Object[] parameters = this.getParameters();
        if (parameters == null) {
            value = this.localizer.getString(this.getResourceKey(), this.component, this.model, this.defaultValue);
            if (value == null) {
                value = this.defaultValue;
            }
        } else {
            value = this.localizer.getString(this.getResourceKey(), this.component, null, this.defaultValue);
            if (value == null) {
                value = this.defaultValue;
            }
            if (value != null) {
                Object[] realParams = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    realParams[i] = parameters[i] instanceof IModel ? ((IModel)parameters[i]).getObject() : (this.model != null && parameters[i] instanceof String ? PropertyVariableInterpolator.interpolate((String)parameters[i], this.model.getObject()) : parameters[i]);
                }
                if (this.model != null) {
                    value = ((Object)Strings.replaceAll(value, "${", "$'{'")).toString();
                }
                MessageFormat format = new MessageFormat(value, this.component != null ? this.component.getLocale() : this.locale);
                value = format.format(realParams);
                if (this.model != null) {
                    value = ((Object)Strings.replaceAll(value, "$'{'", "${")).toString();
                    value = this.localizer.substitutePropertyExpressions(this.component, value, this.model);
                }
            }
        }
        return value;
    }

    public void setLocalizer(Localizer localizer) {
        this.localizer = localizer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StringResourceModel[");
        sb.append("key:");
        sb.append(this.resourceKey);
        sb.append(",default:");
        sb.append(this.defaultValue);
        sb.append(",params:");
        if (this.parameters != null) {
            sb.append(Arrays.asList(this.parameters));
        }
        sb.append("]");
        return sb.toString();
    }

    protected Object[] getParameters() {
        return this.parameters;
    }

    protected final String getResourceKey() {
        if (this.model != null) {
            return PropertyVariableInterpolator.interpolate(this.resourceKey, this.model.getObject());
        }
        return this.resourceKey;
    }

    protected Object load() {
        Session session = Session.get();
        if (session == null) {
            throw new WicketRuntimeException("Cannot attach a string resource model without a Session context because that is required to get a Localizer");
        }
        this.localizer = Application.get().getResourceSettings().getLocalizer();
        this.locale = session.getLocale();
        return this.getString();
    }

    protected final void onDetach() {
        if (this.model != null) {
            this.model.detach();
        }
        this.localizer = null;
        this.locale = null;
    }

    private class AssignmentWrapper
    implements IWrapModel {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(Component component) {
            this.component = component;
        }

        public void detach() {
            StringResourceModel.this.detach();
        }

        public Object getObject() {
            if (StringResourceModel.this.component != null) {
                return StringResourceModel.this.getObject();
            }
            StringResourceModel.this.component = this.component;
            Object res = StringResourceModel.this.getObject();
            StringResourceModel.this.component = null;
            return res;
        }

        public void setObject(Object object) {
            StringResourceModel.this.setObject(object);
        }

        public IModel getWrappedModel() {
            return StringResourceModel.this;
        }
    }
}

