﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace CompleteEraser
{
    class ProgressingEventArgs : EventArgs
    {
        public string fileName;
        public ProgressingEventArgs(string filename)
        {
            this.fileName = filename;
        }
    }
    class ProgressedEventArgs : EventArgs
    {
        public string fileName;
        public bool breaked;
        public bool retry;
        public Exception ex;
        public ProgressedEventArgs(string filename, Exception ex)
        {
            this.fileName = filename;
            this.ex = ex;
            this.breaked = false;
            this.retry = false;
        }
    }

    delegate void ProgressingEventHandler(object sender, ProgressingEventArgs e);
    delegate void ProgressedEventHandler(object sender, ProgressedEventArgs e);
    
    interface IOperation
    {
        event ProgressingEventHandler Progressing;
        event ProgressedEventHandler Progressed;
        event EventHandler Complete;
        void ExecuteAsync(IEnumerable<string> targets, CancellationToken cancelToken);
    }
}
