/**
 * \brief Memory management module for CoolRain template engine.
 *
 */
#if !defined(COOLRAIN__MEMORY__H__)
#define COOLRAIN__MEMORY__H__


#  if COOLRAIN_USE_GLIB
#    include <glib/gmem.h>
#    include <glib/gstrfuncs.h>


#    define coolrain_malloc		g_malloc
#    define coolrain_free		g_free
#    define coolrain_strdup		g_strdup
#    define coolrain_strfreev	g_strfeev


#  else

#    include <stdlib.h>
#    include <stdio.h>
#    include <string.h>

static inline void *coolrain_malloc(size_t n)
{
	void *p = malloc(n);
	if (p == NULL) {
		perror("coolrain_malloc:");
		abort();
	}
	return p;
}

#    define coolrain_free		free

static inline char *coolrain_strdup(char const* str)
{
	char *p = strdup(str);
	if (p == NULL) {
		perror("coolrain_strdup:");
		abort();
	}
	return p;
}

static inline void coolrain_strfreev(char** p)
{
	if (p != NULL) {
		char **tmp = p;
		while (*tmp != NULL) {
			coolrain_free(*tmp);
			tmp++;
		}
		coolrain_free(p);
	}
}

#endif


#endif


