package jp.cssj.server.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 接続後、クライアントとのやり取りを行います 。
 * 
 * @author <a href="miyabe at gnn.co.jp">MIYABE Tatsuhiko</a>
 * @version $Id: ProtocolProcessor.java 286 2009-07-13 10:00:55Z miyabe $
 */
public interface ProtocolProcessor {
	/**
	 * クライアントとのやり取りを行います。
	 * 
	 * @param in
	 * @param out
	 * @param firstLine
	 *            クライアントから送られた最初の行。
	 * @throws IOException
	 */
	public void process(InputStream in, OutputStream out, String firstLine)
			throws IOException;

	/**
	 * クライアントにメッセージを送ります。
	 * 
	 * @param code
	 * @param args
	 * @param message
	 * @throws IOException
	 */
	public void message(short code, String[] args, String message)
			throws IOException;

	/**
	 * 通信を終了します。
	 * 
	 * @throws IOException
	 */
	public void close() throws IOException;
}
