/*

 Copyright 2001  The Apache Software Foundation 

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package net.zamasoft.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * 
 * @author <a href="mailto:david@steadystate.co.uk">David Schweinsberg</a>
 * @version $Id: KerningPair.java 615 2011-08-28 07:31:32Z miyabe $
 */
public class KerningPair {

	private int left;

	private int right;

	private short value;

	/** Creates new KerningPair */
	protected KerningPair(RandomAccessFile raf) throws IOException {
		this.left = raf.readUnsignedShort();
		this.right = raf.readUnsignedShort();
		this.value = raf.readShort();
	}

	public int getLeft() {
		return this.left;
	}

	public int getRight() {
		return this.right;
	}

	public short getValue() {
		return this.value;
	}

}
