package jp.cssj.android;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

import jp.cssj.cr.db.DatabaseHelper;
import jp.cssj.cr.epub.BookshelfItemAdapter;
import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.TabHost;
import android.widget.TabHost.OnTabChangeListener;
import android.widget.TabHost.TabSpec;

import com.google.ads.AdRequest;
import com.google.ads.AdView;

public class BookshelfActivity extends Activity {
	DatabaseHelper dbh;
	final static FileFilter FILTER = new FileFilter() {
		public boolean accept(File file) {
			if (file.isDirectory()) {
				return true;
			}
			return file.getName().toLowerCase().endsWith(".epub");
		}
	};
	final static Comparator<File> COMPARATOR = new Comparator<File>() {
		public int compare(File file1, File file2) {
			if (file1.lastModified() > file2.lastModified()) {
				return -1;
			}
			if (file1.lastModified() < file2.lastModified()) {
				return 1;
			}
			return 0;
		}
	};
	private File dir, root;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		this.requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
		setContentView(R.layout.bookshelf);
		this.getWindow().setFeatureInt(Window.FEATURE_CUSTOM_TITLE,
				R.layout.title);

		this.dbh = new DatabaseHelper(this);

		TabHost tabs = (TabHost) findViewById(R.id.bookshelf_tabhost);
		tabs.setup();
		{
			TabSpec tab = tabs.newTabSpec("tab1");
			tab.setIndicator("最近読んだ本");
			tab.setContent(R.id.bookshelf);
			tabs.addTab(tab);
		}
		{
			TabSpec tab = tabs.newTabSpec("tab2");
			tab.setIndicator("ファイル");
			tab.setContent(R.id.filemanager);
			tabs.addTab(tab);
		}
		tabs.setOnTabChangedListener(new OnTabChangeListener() {
			public void onTabChanged(String tabId) {
				refresh();
			}
		});
		try {
			this.root = this.dir = Environment.getExternalStorageDirectory()
					.getCanonicalFile();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		final AdRequest request = new AdRequest();
		final AdView adView = (AdView) this.findViewById(R.id.adView3);
		adView.setAdListener(new jp.cssj.cr.epub.DefaultAdListener(request));
		adView.loadAd(request);
	}

	@Override
	protected void onResume() {
		super.onResume();
		this.refresh();
	}

	private void refresh() {
		TabHost tabs = (TabHost) findViewById(R.id.bookshelf_tabhost);
		switch (tabs.getCurrentTab()) {
		case 0:
			bookshelf();
			break;
		case 1:
			this.fileManager();
			break;
		}
	}

	private void fileManager() {
		this.files();
	}

	private void files() {
		final BookshelfItemAdapter items = new BookshelfItemAdapter(this,
				R.layout.bookshelf_item);
		if (!this.dir.equals(this.root)) {
			items.add(new File(dir, ".."));
		}

		this.readFiles(dir, items);
		ListView filemanager = (ListView) findViewById(R.id.filemanager);
		filemanager.setAdapter(items);

		filemanager.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> adapter, View view, int pos,
					long id) {
				File file = (File) items.getItem(pos);
				if (file.isDirectory()) {
					try {
						dir = file.getCanonicalFile();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					files();
					return;
				}

				Intent intent = new Intent(BookshelfActivity.this,
						BookActivity.class);
				intent.setData(Uri.fromFile(file));
				BookshelfActivity.this.startActivity(intent);
			}
		});
	}

	private void readFiles(File dir, BookshelfItemAdapter items) {
		final File[] files = dir.listFiles(FILTER);
		if (files == null) {
			return;
		}
		Arrays.sort(files, COMPARATOR);
		for (int i = 0; i < files.length; ++i) {
			File file = files[i];
			items.add(file);
		}
	}

	private void bookshelf() {
		SQLiteDatabase db = this.dbh.getWritableDatabase();
		try {
			// 消えたファイルをDBから削除
			{
				Cursor c = db.rawQuery("SELECT file FROM books", null);
				try {
					SQLiteStatement stmt1 = db
							.compileStatement("DELETE FROM books WHERE file=?");
					SQLiteStatement stmt2 = db
							.compileStatement("DELETE FROM setting WHERE file=?");
					c.moveToFirst();
					while (!c.isAfterLast()) {
						File file = new File(c.getString(0));
						if (!file.exists()) {
							try {
								stmt1.bindString(1, file.getCanonicalPath());
								stmt1.execute();
								stmt2.bindString(1, file.getCanonicalPath());
								stmt2.execute();
							} catch (IOException e) {
								// ignore
							}
						}
						c.moveToNext();
					}
					stmt1.close();
					stmt2.close();
				} finally {
					c.close();
				}
			}

			final BookshelfItemAdapter items = new BookshelfItemAdapter(this,
					R.layout.bookshelf_item);
			ListView bookshelf = (ListView) findViewById(R.id.bookshelf);
			bookshelf.setAdapter(items);
			bookshelf.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> adapter, View view,
						int pos, long id) {
					Intent intent = new Intent(BookshelfActivity.this,
							BookActivity.class);
					File file = (File) items.getItem(pos);
					intent.setData(Uri.fromFile(file));
					BookshelfActivity.this.startActivity(intent);
				}
			});

			Cursor c = db.rawQuery(
					"SELECT file FROM books ORDER BY last_accessed DESC", null);
			try {
				c.moveToFirst();
				while (!c.isAfterLast()) {
					File file = new File(c.getString(0));
					items.add(file);
					c.moveToNext();
				}
			} finally {
				c.close();
			}
		} finally {
			db.close();
		}
	}
}