package jp.cssj.android;

import jp.cssj.cr.compat.XMatrix;
import jp.cssj.cr.epub.BookCallback;
import jp.cssj.cr.gc.AndroidGC;
import jp.cssj.cr.gc.AndroidImage;
import jp.cssj.cr.gc.Annotations;
import jp.cssj.cr.gc.RecorderGC;
import jp.cssj.print.epub.Contents;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;

public class PanelActivity extends Activity implements BookCallback {
	private PanelView mainView;
	private BookActivity parent;
	private FrameLayout frame;
	private TextView head, foot;

	// 本文の表示用
	class PanelView extends SurfaceView {
		private RecorderGC prgc;
		private Bitmap bitmap = null;
		private Annotations annots = new Annotations();

		public PanelView(Context context) {
			super(context);
		}

		protected void onDraw(Canvas canvas) {
			this.redraw(canvas);
		}

		private void redraw(Canvas canvas) {
			if (this.bitmap == null) {
				return;
			}
			canvas.drawBitmap(this.bitmap, 0, 0, null);
			if (annots.getSelectedImage() != null) {
				canvas.setMatrix(null);
				annots.drawSelectedImageFrame(canvas);
			}
		}

		protected void draw() {
			if (this.bitmap == null) {
				this.bitmap = Bitmap.createBitmap(this.getWidth(),
						this.getHeight(), Config.ARGB_8888);
			}
			Canvas canvas = new Canvas(this.bitmap);
			RecorderGC rgc = parent.getRecorderGC();
			canvas.drawColor(parent.setting.reverse ? Color.BLACK : Color.WHITE);
			Annotations s = null;
			if (rgc != null) {
				if (this.prgc != rgc) {
					this.prgc = rgc;
					annots.clear();
					s = annots;
				}
			} else if (this.prgc == null) {
				return;
			}
			AndroidGC agc = new AndroidGC(canvas, s, parent.getFontManager());
			agc.transform(this.getXMatrix());
			this.prgc.flush(agc);
		}

		private float downX;

		public boolean onTouchEvent(MotionEvent e) {
			switch (e.getAction()) {
			case MotionEvent.ACTION_DOWN:
				this.downX = e.getX();
				break;
			case MotionEvent.ACTION_UP:
				// ページめくり
				float diff = e.getX() - this.downX;
				boolean rightToLeft;
				if (Math.abs(diff) < 20) {
					if (e.getY() > mainView.getHeight() - 60) {
						// メニュー表示
						parent.openOptionsMenu();
						break;
					} else {
						// 画像表示
						AndroidImage ximage = annots.getSelectedImage();
						AndroidImage image = annots.selectImage(e.getX(),
								e.getY());
						if (image != null) {
							int index = annots.getSelectedIndex();
							RectF rectf = annots.getSelectedRect();
							Rect rect = new Rect();
							rectf.round(rect);
							Rect xrect = new Rect(rect);
							if (ximage == image) {
								annots.clearSelectedImage();
								ImageView imageView = new ImageView(
										PanelActivity.this, image);
								frame.addView(imageView);
							}
							SurfaceHolder holder = this.getHolder();
							Canvas canvas = holder.lockCanvas(rect);
							try {
								if (xrect.equals(rect)) {
									// 一部を書き直し
									annots.drawImage(canvas, index);
								} else {
									// 全てを書き直し
									this.redraw(canvas);
								}
							} finally {
								holder.unlockCanvasAndPost(canvas);
							}
							break;
						}
					}
					rightToLeft = this.downX > (this.getWidth() / 2);
				} else {
					rightToLeft = diff < 0;
				}
				if (rightToLeft
						^ (parent.setting.direction == 2 || parent.contents.pageProgressionDirection == Contents.PAGE_PROGRESSION_DIRECTION_RTL)) {
					if (parent.hasNextPage()) {
						this.turnUp(rightToLeft);
						parent.nextPage();
					}
				} else {
					if (parent.hasPreviousPage()) {
						this.turnUp(rightToLeft);
						parent.previousPage();
					}
				}
				break;
			}
			return true;
		}

		private void turnUp(boolean rightToLeft) {
			Resources res = this.getResources();
			Bitmap bitmap;
			int x, y;
			if (rightToLeft) {
				bitmap = BitmapFactory.decodeResource(res,
						R.drawable.right_to_left);
				x = this.getWidth() - bitmap.getWidth();
			} else {
				bitmap = BitmapFactory.decodeResource(res,
						R.drawable.left_to_right);
				x = 0;
			}
			y = this.getHeight() - bitmap.getHeight();
			SurfaceHolder holder = this.getHolder();
			Rect rect = new Rect(x, y, x + bitmap.getWidth(), y
					+ bitmap.getHeight());
			Canvas canvas = holder.lockCanvas(rect);
			try {
				canvas.drawBitmap(this.bitmap, rect, rect, null);
				canvas.drawBitmap(bitmap, x, y, null);
			} finally {
				holder.unlockCanvasAndPost(canvas);
			}
		}

		private XMatrix getXMatrix() {
			float pageWidth, pageHeight;
			float paperWidth = this.getWidth();
			float paperHeight = this.getHeight();
			pageWidth = parent.setting.width * 96f / 25.4f;
			pageHeight = parent.setting.height * 96f / 25.4f;
			XMatrix at = XMatrix.getScaleInstance(paperWidth / pageWidth,
					paperHeight / pageHeight);
			at.preTranslate((float) (pageWidth - this.prgc.width) / 2f,
					(float) (pageHeight - this.prgc.height) / 2f);
			return at;
		}

		protected void update() {
			SurfaceHolder holder = this.getHolder();
			Canvas canvas = holder.lockCanvas();
			if (canvas == null) {
				return;
			}
			try {
				this.draw();
				this.redraw(canvas);
			} finally {
				holder.unlockCanvasAndPost(canvas);
			}
		}
	}

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		this.getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
		this.requestWindowFeature(Window.FEATURE_NO_TITLE);

		this.parent = (BookActivity) this.getParent();
		setContentView(R.layout.panel);
		this.frame = (FrameLayout) this.findViewById(R.id.panel);
		this.mainView = new PanelView(this);
		this.mainView.setLayoutParams(new LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));
		this.frame.addView(this.mainView);

		this.head = (TextView) this.findViewById(R.id.head);
		this.foot = (TextView) this.findViewById(R.id.foot);
		this.foot.setOnTouchListener(new OnTouchListener() {
			public boolean onTouch(View v, MotionEvent e) {
				if (e.getAction() == MotionEvent.ACTION_UP) {
					parent.openOptionsMenu();
				}
				return true;
			}
		});

		this.head.setText(this.parent.toc.docTitle);

		// AD1*
		final com.google.ads.AdRequest request = new com.google.ads.AdRequest();
		final com.google.ads.AdView adView = (com.google.ads.AdView) this
				.findViewById(R.id.adView1);
		adView.setAdListener(new jp.cssj.cr.epub.DefaultAdListener(request));
		adView.loadAd(request);
		// *AD1

		this.parent.setBookCallback(this);
	}

	public boolean back() {
		if (this.frame.getChildAt(this.frame.getChildCount() - 1) instanceof ImageView) {
			this.frame.removeViewAt(this.frame.getChildCount() - 1);
			return false;
		}
		return true;
	}

	// 画像の拡大表示用
	class ImageView extends View {
		private final AndroidImage image;

		public ImageView(Context context, AndroidImage image) {
			super(context);
			this.image = image;
		}

		protected void onDraw(Canvas canvas) {
			float xx = (this.getWidth() - (float) this.image.getWidth()) / 2;
			float yy = (this.getHeight() - (float) this.image.getHeight()) / 2;
			canvas.drawARGB(0xA0, 0, 0, 0);
			Drawable d = this.image.getDrawable();
			d.setBounds((int) xx, (int) yy, (int) (this.image.getWidth() + xx),
					(int) (this.image.getHeight() + yy));
			d.draw(canvas);
		}

		float downX, downY, preX, preY;

		public boolean onTouchEvent(MotionEvent e) {
			switch (e.getAction()) {
			case MotionEvent.ACTION_UP:
			case MotionEvent.ACTION_MOVE:
				this.scrollBy((int) (this.preX - e.getX()),
						(int) (this.preY - e.getY()));
				this.preX = e.getX();
				this.preY = e.getY();
				break;
			case MotionEvent.ACTION_DOWN:
				this.downX = this.preX = e.getX();
				this.downY = this.preY = e.getY();
				break;
			}
			return true;
		}
	}

	ProgressDialog loading = null;

	// 読み込み中パネルを表示
	protected void beginLoading() {
		if (this.loading == null) {
			this.loading = ProgressDialog.show(parent, "",
					parent.getString(R.string.loading), true);
		}
	}

	// 読み込み中を解除
	protected void endLoading() {
		if (this.loading != null) {
			this.loading.dismiss();
			this.loading = null;
		}
	}

	public void updateProgress(int event) {
		if (this.parent.setting.direction == 2
				|| parent.contents.pageProgressionDirection == Contents.PAGE_PROGRESSION_DIRECTION_RTL) {
			this.foot.setGravity(Gravity.LEFT);
			this.foot.setText("←　" + this.parent.getProgress());
		} else {
			this.foot.setGravity(Gravity.RIGHT);
			this.foot.setText(this.parent.getProgress() + "　→");
		}
		if (this.parent.setting.reverse) {
			this.head.setBackgroundColor(Color.BLACK);
			this.foot.setBackgroundColor(Color.BLACK);
			this.head.setTextColor(Color.WHITE);
			this.foot.setTextColor(Color.WHITE);
		} else {
			this.head.setBackgroundColor(Color.WHITE);
			this.foot.setBackgroundColor(Color.WHITE);
			this.head.setTextColor(Color.BLACK);
			this.foot.setTextColor(Color.BLACK);
		}

		if (this.parent.goToPage != -1) {
			if (this.parent.getPageCount() <= this.parent.goToPage) {
				if (event == BookCallback.PAGE_FINISHED) {
					this.parent.goToPage = this.parent.getPageCount() - 1;
				} else {
					return;
				}
			}
			this.parent.progressBar.setProgress(this.parent.goToPage);
			this.parent.goToPage = -1;
			this.endLoading();
			this.parent.savePosition();
			if (event != BookCallback.PAGE_CHANGED) {
				this.mainView.update();
			}
		}
		if (event != BookCallback.PAGE_CHANGED) {
			return;
		}

		String title = this.parent.toc.docTitle;
		if (this.parent.item.title != null
				&& this.parent.item.title.length() > 0) {
			title += " - " + this.parent.item.title;
		}
		this.head.setText(title);

		this.mainView.update();
	}
}