package jp.cssj.cr.gc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

import jp.cssj.sakae.font.FontSource;
import jp.cssj.sakae.font.FontSourceManager;
import jp.cssj.sakae.font.otf.OpenTypeFontSource;
import jp.cssj.sakae.gc.font.FontFamily;
import jp.cssj.sakae.gc.font.FontStyle;
import android.app.Activity;
import android.content.res.Resources;
import android.util.Log;

public class OpenTypeFontSourceManager implements FontSourceManager,
		Serializable {
	private static final long serialVersionUID = 1L;

	final FontSource[] sFontSourcesH;
	final FontSource[] sFontSourcesV;
	final FontSource[] ssFontSourcesH;
	final FontSource[] ssFontSourcesV;

	public OpenTypeFontSourceManager(Activity ac) {
		try {
			Resources res = ac.getResources();
			File dir = ac.getCacheDir();
			dir.mkdirs();

			byte[] buff = new byte[1024];
			File ipam = new File(dir, "ipam.otf");
			this.join(buff, res, ipam, 5);
			File ipag = new File(dir, "ipag.otf");
			this.join(buff, res, ipag, 4);
			{
				Log.d(this.getClass().getName(), "Read:" + ipam.getName());
				OpenTypeFontSource m = new OpenTypeFontSource(ipam, 0,
						FontStyle.DIRECTION_LTR);
				Log.d(this.getClass().getName(), "Read:" + ipag.getName());
				OpenTypeFontSource g = new OpenTypeFontSource(ipag, 0,
						FontStyle.DIRECTION_LTR);
				sFontSourcesH = new FontSource[] { m };
				ssFontSourcesH = new FontSource[] { g };
			}
			{
				Log.d(this.getClass().getName(), "Read:" + ipam.getName());
				OpenTypeFontSource m = new OpenTypeFontSource(ipam, 0,
						FontStyle.DIRECTION_TB);
				Log.d(this.getClass().getName(), "Read:" + ipag.getName());
				OpenTypeFontSource g = new OpenTypeFontSource(ipag, 0,
						FontStyle.DIRECTION_TB);
				Log.d(this.getClass().getName(), "Read:" + ipam.getName());
				OpenTypeFontSource mh = new OpenTypeFontSource(ipam, 0,
						FontStyle.DIRECTION_LTR) {
					private static final long serialVersionUID = 0L;

					public boolean canDisplay(int c) {
						if (c > 0xFF) {
							return false;
						}
						return super.canDisplay(c);
					}
				};
				Log.d(this.getClass().getName(), "Read:" + ipag.getName());
				OpenTypeFontSource gh = new OpenTypeFontSource(ipag, 0,
						FontStyle.DIRECTION_LTR) {
					private static final long serialVersionUID = 0L;

					public boolean canDisplay(int c) {
						if (c > 0xFF) {
							return false;
						}
						return super.canDisplay(c);
					}
				};
				sFontSourcesV = new FontSource[] { m, mh };
				ssFontSourcesV = new FontSource[] { g, gh };
			}
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	private void join(byte[] buff, Resources res, File file, int count)
			throws IOException {
		Log.d(this.getClass().getName(), "Copy:" + file.getName());
		if (file.exists()) {
			return;
		}
		OutputStream out = new FileOutputStream(file);
		try {
			for (int i = 1; i <= count; ++i) {
				InputStream in = res.getAssets().open(file.getName() + "/" + i);
				try {
					for (int len = in.read(buff); len != -1; len = in
							.read(buff)) {
						out.write(buff, 0, len);
					}
				} finally {
					in.close();
				}
			}
		} finally {
			out.close();
		}
	}

	public FontSource[] lookup(FontStyle fontStyle) {
		if (fontStyle.getFamily().get(0).getGenericFamily() == FontFamily.SANS_SERIF) {
			if (fontStyle.getDirection() == FontStyle.DIRECTION_TB) {
				return ssFontSourcesV;
			}
			return ssFontSourcesH;
		}
		if (fontStyle.getDirection() == FontStyle.DIRECTION_TB) {
			return sFontSourcesV;
		}
		return sFontSourcesH;
	}

}
