package jp.cssj.cr.epub;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.cssj.cr.gc.AndroidImage;
import jp.cssj.cr.gc.RecorderGC;

public class Cache {
	private final List<List<RecorderGC>> results = new ArrayList<List<RecorderGC>>();
	private final Map<URI, AndroidImage> images = new HashMap<URI, AndroidImage>();

	public synchronized void addResult(List<RecorderGC> result) {
		this.results.add(result);
	}

	public synchronized void setResult(int ix, List<RecorderGC> result) {
		this.results.set(ix, result);
	}

	public synchronized int getResultsCount() {
		return this.results.size();
	}

	public synchronized List<RecorderGC> getResult(int ix) {
		return this.results.get(ix);
	}

	public synchronized AndroidImage getImage(URI uri) {
		return this.images.get(uri);
	}

	public synchronized void putImage(URI uri, AndroidImage image) {
		this.images.put(uri, image);
	}

	public synchronized void free() {
		Runtime runtime = Runtime.getRuntime();
		for (AndroidImage im : this.images.values()) {
			if (runtime.freeMemory() > 5 * 1024 * 1024) {
				break;
			}
			im.free();
			System.gc();
		}
	}

	public synchronized boolean forceFree() {
		for (AndroidImage im : this.images.values()) {
			if (im.free()) {
				System.gc();
				return true;
			}
		}
		return false;
	}
}
