package jp.cssj.sakae.gc;

import jp.cssj.cr.compat.XLine;
import jp.cssj.cr.compat.XMatrix;
import jp.cssj.sakae.gc.font.FontManager;
import jp.cssj.sakae.gc.image.Image;
import jp.cssj.sakae.gc.text.Text;
import android.graphics.Path;
import android.graphics.RectF;

/**
 * グラフィックコンテキストです。
 * 
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: GC.java,v 1.3 2007-05-06 04:27:03 miyabe Exp $
 */
public interface GC {
	public static final short LINE_JOIN_MITER = 0;

	public static final short LINE_JOIN_ROUND = 1;

	public static final short LINE_JOIN_BEVEL = 2;

	public static final short LINE_CAP_BUTT = 0;

	public static final short LINE_CAP_ROUND = 1;

	public static final short LINE_CAP_SQUARE = 2;

	public static final short TEXT_MODE_FILL_STROKE = 2;

	public static final double[] STROKE_SOLID = new double[0];

	public FontManager getFontManager();

	public void begin() throws GraphicsException;

	public void resetState() throws GraphicsException;

	public void end() throws GraphicsException;

	public void setComposite(Object composite) throws GraphicsException;

	public void setStrokePaint(Object paint) throws GraphicsException;

	public void setFillPaint(Object paint) throws GraphicsException;

	public void setLineWidth(double width) throws GraphicsException;

	public void setLinePattern(double[] pattern) throws GraphicsException;

	public void setLineJoin(short style) throws GraphicsException;

	public void setLineCap(short style) throws GraphicsException;

	public void setTextMode(short textMode) throws GraphicsException;

	public void transform(XMatrix at) throws GraphicsException;

	public XMatrix getTransform() throws GraphicsException;

	public void clip(Path shape) throws GraphicsException;

	public void clip(RectF shape) throws GraphicsException;

	public void draw(Path shape) throws GraphicsException;

	public void draw(RectF shape) throws GraphicsException;

	public void draw(XLine shape) throws GraphicsException;

	public void drawOval(RectF shape) throws GraphicsException;

	public void fill(Path shape) throws GraphicsException;

	public void fill(RectF shape) throws GraphicsException;

	public void fillOval(RectF shape) throws GraphicsException;

	public void fillDraw(Path shape) throws GraphicsException;

	public void fillDraw(RectF shape) throws GraphicsException;

	public void fillDrawOval(RectF shape) throws GraphicsException;

	public void drawImage(Image image) throws GraphicsException;

	public void drawText(Text text, double x, double y)
			throws GraphicsException;
}