package jp.cssj.android;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import android.app.Activity;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.widget.TextView;

public class AboutActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.about);
		TextView ipa = (TextView) this.findViewById(R.id.ipa);
		StringBuffer buff = new StringBuffer();
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(this
					.getAssets().open("IPA_Font_License_Agreement_v1.0.txt"),
					"UTF-8"));
			try {
				for (String line = in.readLine(); line != null; line = in
						.readLine()) {
					buff.append(line).append('\n');
				}
			} finally {
				in.close();
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		DisplayMetrics metrics = new DisplayMetrics();
		Display display = this.getWindowManager().getDefaultDisplay();
		display.getMetrics(metrics);
		buff.append("\ndensity=" + metrics.density);
		buff.append("\nscaledDensity=" + metrics.scaledDensity);
		buff.append("\nwidthPixels=" + metrics.widthPixels);
		buff.append("\nheightPixels=" + metrics.heightPixels);
		buff.append("\nxdpi=" + metrics.xdpi);
		buff.append("\nydpi=" + metrics.ydpi);

		buff.append("\nnan=" + nan + "/" + Double.isNaN(nan) + "/"
				+ Double.isNaN(real));

		ipa.setText(buff.toString());
	}

	double nan = Double.NaN, real = 0;
}