package jp.cssj.homare.impl.css.part;

import jp.cssj.cr.compat.XPath;
import jp.cssj.homare.css.util.ColorValueUtils;
import jp.cssj.homare.style.util.StyleUtils;
import jp.cssj.homare.ua.UserAgent;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.image.Image;
import jp.cssj.sakae.gc.paint.CMYKColor;
import jp.cssj.sakae.gc.paint.GrayColor;

/**
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: BrokenImage.java,v 1.5.2.1 2006/04/06 05:01:28 harumanx Exp $
 */
public class BrokenImage implements Image {
	protected static final double WIDTH = 40, HEIGHT = 40;

	protected final String alt;

	protected final UserAgent ua;

	public BrokenImage(UserAgent ua, String alt) {
		this.ua = ua;
		this.alt = alt;
	}

	public double getWidth() {
		return WIDTH;
	}

	public double getHeight() {
		return HEIGHT;
	}

	public String getAltString() {
		return this.alt;
	}

	public void drawTo(GC gc) throws GraphicsException {
		XPath path = new XPath();
		gc.begin();

		float x = 1f;
		float y = 1f;
		float w = (float) WIDTH - 2;
		float h = (float) HEIGHT - 2;

		gc.setLineWidth(2.0);
		gc.setLinePattern(GC.STROKE_SOLID);
		gc.setStrokePaint(GrayColor.BLACK);
		path.moveTo(x + w, y);
		path.lineTo(x, y);
		path.lineTo(x, y + h);
		gc.draw(path);

		gc.setStrokePaint(CMYKColor.create(0, 0, 0, 211));
		path.reset();
		path.moveTo(x, y + h);
		path.lineTo(x + w, y + h);
		path.lineTo(x + w, y);
		gc.draw(path);

		gc.setLineWidth(3.0);
		gc.setLinePattern(GC.STROKE_SOLID);
		gc.setStrokePaint(ColorValueUtils.RED);

		path.reset();
		path.moveTo(x + 5f, y + 5f);
		path.lineTo(x + 15f, y + 15f);
		gc.draw(path);

		path.reset();
		path.moveTo(x + 15f, y + 5f);
		path.lineTo(x + 5f, y + 15f);
		gc.draw(path);

		if (this.alt != null) {
			StyleUtils.drawText(this.ua.getFontManager(), gc, 5, this.alt, 3,
					3, WIDTH - 6);
		}

		gc.end();
	}
}
