package org.apache.commons.logging;

public class Log {
	private final String tag;

	public Log(String tag) {
		this.tag = tag;
	}

	public void debug(String msg) {
		android.util.Log.d(this.tag, msg);
	}

	public void debug(String msg, Throwable t) {
		android.util.Log.d(this.tag, msg, t);
	}

	public void warn(String msg) {
		android.util.Log.w(this.tag, msg);
	}

	public void warn(String msg, Throwable t) {
		android.util.Log.w(this.tag, msg, t);
	}
}
