/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

class CSSHandler
implements DocumentHandler {
    String path;
    XRefChecker xrefChecker;
    Report report;
    boolean fontFace = false;
    EPUBVersion version;

    @Override
    public void comment(String text) throws CSSException {
    }

    @Override
    public void endDocument(InputSource source) throws CSSException {
    }

    @Override
    public void endFontFace() throws CSSException {
        this.fontFace = false;
    }

    @Override
    public void endMedia(SACMediaList media) throws CSSException {
    }

    @Override
    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void endSelector(SelectorList selectors) throws CSSException {
    }

    @Override
    public void ignorableAtRule(String atRule) throws CSSException {
    }

    @Override
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    public CSSHandler(String path, XRefChecker xrefChecker, Report report, EPUBVersion version) {
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.version = version;
    }

    @Override
    public void property(String name, LexicalUnit value, boolean arg2) throws CSSException {
        if (name != null && name.equals("src") && value != null && value.getLexicalUnitType() == 24) {
            if (value.getStringValue() != null) {
                String fontMimeType;
                String uri = value.getStringValue();
                uri = PathUtil.resolveRelativeReference(this.path, uri);
                this.xrefChecker.registerReference(this.path, -1, -1, uri, 0);
                if (this.fontFace && this.version == EPUBVersion.VERSION_3 && !OPFChecker30.isBlessedFontType(fontMimeType = this.xrefChecker.getMimeType(uri))) {
                    this.report.error(this.path, -1, -1, "Font-face reference " + uri + "to non-standard font type " + fontMimeType);
                }
            } else {
                this.report.error(this.path, -1, -1, Messages.NULL_REF);
            }
        }
    }

    @Override
    public void startDocument(InputSource source) throws CSSException {
    }

    @Override
    public void startFontFace() throws CSSException {
        this.fontFace = true;
    }

    @Override
    public void startMedia(SACMediaList media) throws CSSException {
    }

    @Override
    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void startSelector(SelectorList selectors) throws CSSException {
    }
}

