/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package nicobrowser;

import java.net.MalformedURLException;
import java.util.List;
import nicobrowser.entity.NicoContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

/**
 *
 * @author yuki
 */
public class NicoHttpClientRssTest {

    static final Log log = LogFactory.getLog(NicoHttpClientRssTest.class);
    final NicoHttpClient client = NicoHttpClient.getInstance();

    @Test
    public void testNewArraivalCategory() throws MalformedURLException {
        log.info("testNewArraivalCategory");

        String page = "http://www.nicovideo.jp/tag/科学?sort=f&rss=2.0";
        List<NicoContent> contents = client.getContentsFromRss(page);
        for (NicoContent c : contents) {
            System.out.println(c.getNicoId() + ": " + c.getTitle());
        }
    }

    @Test
    public void testNewArraival() {
        log.info("testNewArraival");

        String page = "http://www.nicovideo.jp/newarrival?rss=2.0";
        List<NicoContent> contents = client.getContentsFromRss(page);
        for (NicoContent c : contents) {
            System.out.println(c.getNicoId() + ": " + c.getTitle());
        }
    }

    @Test
    public void testNewArraivalCommentMovie() {
        log.info("testNewArraivalCommentMovie");

        String page = "http://www.nicovideo.jp/recent?rss=2.0";
        List<NicoContent> contents = client.getContentsFromRss(page);
        for (NicoContent c : contents) {
            System.out.println(c.getNicoId() + ": " + c.getTitle());
        }
    }

    @Test
    public void testRanking() {
        log.info("testRanking");

        String page = "http://www.nicovideo.jp/ranking/mylist/daily/science?rss=2.0";
        List<NicoContent> contents = client.getContentsFromRss(page);
        for (NicoContent c : contents) {
            System.out.println(c.getNicoId() + ": " + c.getTitle());
        }
    }
}
