/**
 * ドラック・アンド・ドロップを実現するためのクラス。
 */
package saccubus.util;

import java.awt.datatransfer.*;
import java.awt.dnd.*;
import java.io.File;
import java.io.IOException;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author PSI
 *
 */
public class FileDropTarget extends DropTargetAdapter {

    private static final Logger logger = LoggerFactory.getLogger(FileDropTarget.class);

	private final JTextField Field;

	private final boolean isFolder;

	public FileDropTarget(JTextField field, boolean is_folder) {
		isFolder = is_folder;
		Field = field;
	}

    @Override
	public void dragOver(DropTargetDragEvent dtde) {
		if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
			dtde.acceptDrag(DnDConstants.ACTION_COPY);
			return;
		}
		dtde.rejectDrag();
	}

    @Override
	public void drop(DropTargetDropEvent dtde) {
		try {
			if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
				dtde.acceptDrop(DnDConstants.ACTION_COPY);
				Transferable t = dtde.getTransferable();
				java.util.List<?> list = (java.util.List) t
						.getTransferData(DataFlavor.javaFileListFlavor);
				for (Object o : list) {
					if (o instanceof File) {
						File file = (File) o;
						if (isFolder) {
							if (file.isDirectory()) {
								Field.setText(file.getPath());
							} else {
								Field.setText(file.getParent());
							}
						} else {
							if (file.isFile()) {
								Field.setText(file.getPath());
							}
						}
					}
				}
				dtde.dropComplete(true);
			}
		} catch (UnsupportedFlavorException | IOException e) {
			logger.error(null, e);
		}
	}

}
