package saccubus.worker.profile;

import java.util.Map;

/**
 * ニコニコ動画サービスへのログイン情報を保持するためのプロファイルです.
 * @author yuki
 */
public interface LoginProfile {

    /** @return ログイン情報を使用してログインする場合はtrue, cookieを使用する場合はfalse. */
    boolean needsLogin();

    /** @return ログインID(メールアドレス). */
    String getMail();

    /** @return ログインパスワード. */
    String getPassword();

    /**
     * @return 追加のCookie.
     * {@link #needsLogin()} がfalseの場合, ここにユーザセッション情報を含める必要があります.
     */
    Map<String, String> getCookies();
}
