package yukihane.inqubus.saccubus.prompt;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import saccubus.util.WayBackTimeParser;
import saccubus.worker.impl.convert.Convert;
import saccubus.worker.impl.convert.ConvertResult;
import saccubus.worker.impl.download.Download;
import saccubus.worker.impl.download.DownloadResult;
import saccubus.worker.profile.ConvertProfile;
import saccubus.worker.profile.DownloadProfile;

/**
 * <p>
 * タイトル: さきゅばす
 * </p>
 *
 * <p>
 * 説明: ニコニコ動画の動画をコメントつきで保存
 * </p>
 *
 * <p>
 * 著作権: Copyright (c) 2007 PSI
 * </p>
 *
 * <p>
 * 会社名:
 * </p>
 *
 * @author 未入力
 * @version 1.0
 */
public class Prompt {

    private static final Logger logger = LoggerFactory.getLogger(Prompt.class);

    public void main(String[] args) throws IOException, Exception {
        final String mail = args[0];
        final String pass = args[1];
        final String tag = args[2];
        final long time = args.length < 4 ? -1L : WayBackTimeParser.parse(args[3]);
        final DownloadProfile downloadSetting = new DownloadProfileImpl(mail, pass, time);
        final Download down = new Download(downloadSetting, tag);
        logger.info("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        logger.info("Saccubus on CUI");
        logger.info("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        logger.info("Mailaddr: " + mail);
        logger.info("Password: hidden");
        logger.info("VideoID: " + tag);
        logger.info("WaybackTime: " + time);
        logger.info("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        final DownloadResult dRes = down.call();

        final ConvertProfile setting = new ConvertProfileImpl(tag, "");
        final Convert conv = new Convert(setting, dRes.getDownloadVideo(), dRes.getDownloadComment());
        final ConvertResult cRes = conv.call();
        logger.info("RESULT CODE: {}", cRes);

        logger.info("Finished.");
    }
}
