/*
 * TestRunner.h
 */

#ifndef cppunit_TestRunner_h
#define cppunit_TestRunner_h

#include "cuconfig.h"
#include "TestRegistry.h"

cu_NAMESPACE_BEGIN(cppunit)

class Test;
class TestResult;

/**
 * eLXgŃeXgi<br>
 * A text mode test runner.
 *
 * The test runner manage the life cycle of the added tests.
 *
 * TestRunner prints out a trace as the tests are executed followed by
 * a summary at the end.
 *
 * Here is an example:
 * <pre>
 * class ATestCase : public TestCase { ... };
 *
 * int main(int argc, char* argv[]) {
 *     TestRunner runner;
 *     runner.addTest("ATestCase", new ATestCase("ATestCase"));
 *     return runner.run(argc, argv);
 * }
 * </pre>
 */
class TestRunner
{
  public:
	/** RXgN^B */
	TestRunner();

	/** fXgN^B */
	~TestRunner() {}

	/**
	 * eXgǉB
	 * @param test ǉeXgB
	 */
	void addTest(Test* test);

	/**
	 * eXgǉB
	 * @param name eXgB
	 * @param test ǉeXgB
	 */
	void addTest(const char* name, Test* test);

	/**
	 * eXgsB
	 * @param argc R}hČB
	 * @param argv R}hC̔zB
	 * @return sʁB0: SUCCESS, 1: FAILURE, etc.
	 */
	int run(int argc, char* argv[]);

  protected:
	/**
	 * R}hC͂B
	 * @param argc R}hČB
	 * @param argv R}hC̔zB
	 */
	int parseArgs(int argc, char* argv[]);

	/** eXgsB */
	int runTests();

	/** L[{[h̓͂҂B */
	void wait();

	/**
	 * gp@\B
	 * @param command R}hB
	 */
	void printUsage(const char* command) const;

	/**
	 * eXgʂ\B
	 * @param result eXgʁB
	 */
	void printResult(const TestResult& result) const;

	/**
	 * eXgʂ̃wb_\B
	 * @param result eXgʁB
	 */
	void printHeader(const TestResult& result) const;

	/**
	 * seXg̃Xg\B
	 * @param failures seXg̃XgB
	 */
	void printFailures(const cu_List& failures) const;

	/**
	 * G[̃Xg\B
	 * @param errors G[̃XgB
	 */
	void printErrors(const cu_List& errors) const;

  private:
	TestRunner(const TestRunner& rhs);
	TestRunner& operator=(const TestRunner& rhs);

  private:
	bool m_help;
	bool m_wait;
	bool m_verbose;
	const char*  m_logfile;
	TestRegistry m_registry;

  private:
	class SimpleListener;
	class Logger;
};

cu_NAMESPACE_END

#endif /* !cppunit_TestRunner_h */
