/*
 * TestCaseTest.cpp
 */

#include <cppunit/cudebug.h>
#include "TestCaseTest.h"
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestFailure.h>

USING_NAMESPACE_CPPUNIT

void TestCaseTest::testSuccess()
{
	SuccessTestCase testCase("SuccessTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(result.wasSuccessful());
}

void TestCaseTest::testFailure()
{
	FailureTestCase testCase("FailureTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());
}

void TestCaseTest::testAssertMessage()
{
	MessageTestCase testCase("MessageTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("fail", failure->what());
}

void TestCaseTest::testIntEqualsSuccess()
{
	IntEqualsSuccessTestCase testCase("IntEqualsSuccessTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(result.wasSuccessful());
}

void TestCaseTest::IntEqualsFailureTestCase::runTest()
{
	int n = 12;
	TEST_ASSERT_EQUALS(12, ++n);
}

void TestCaseTest::testIntEqualsFailure()
{
	IntEqualsFailureTestCase testCase("IntEqualsFailureTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("expected:<12> but was:<13>", failure->what());
}

void TestCaseTest::testLongEqualsSuccess()
{
	LongEqualsSuccessTestCase testCase("LongEqualsSuccessTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(result.wasSuccessful());
}

void TestCaseTest::LongEqualsFailureTestCase::runTest()
{
	long n = 12L;
	TEST_ASSERT_EQUALS(12L, ++n);
}

void TestCaseTest::testLongEqualsFailure()
{
	LongEqualsFailureTestCase testCase("LongEqualsFailureTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("expected:<12> but was:<13>", failure->what());
}

void TestCaseTest::DoubleEqualsSuccessTestCase::runTest()
{
	TEST_ASSERT_EQUALS(1.2, 1.2);
	TEST_ASSERT_EQUALS_DOUBLE(1.0, 1.02, 0.3);
}

void TestCaseTest::testDoubleEqualsSuccess()
{
	DoubleEqualsSuccessTestCase testCase("DoubleEqualsSuccessTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(result.wasSuccessful());
}

void TestCaseTest::DoubleEqualsFailureTestCase::runTest()
{
	double x = 1.0;
	TEST_ASSERT_EQUALS_DOUBLE(1.0, x += 0.2, 0.1);
}

void TestCaseTest::testDoubleEqualsFailure()
{
	DoubleEqualsFailureTestCase testCase("DoubleEqualsFailureTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS(notEqualsMessage(1.0, 1.2), failure->what());
}

void TestCaseTest::StringEqualsSuccessTestCase::runTest()
{
	const char* s1 = "abc";
	cu_String   s2 = "xyz";
	TEST_ASSERT_EQUALS("abc", s1);
	TEST_ASSERT_EQUALS(cu_String("abc"), s1);
	TEST_ASSERT_EQUALS("xyz", s2);
	TEST_ASSERT_EQUALS(cu_String("xyz"), s2);
}

void TestCaseTest::testStringEqualsSuccess()
{
	StringEqualsSuccessTestCase testCase("StringEqualsSuccessTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(result.wasSuccessful());
}

void TestCaseTest::StringEqualsFailureTestCase1::runTest()
{
	const char* s = "abcd";
	TEST_ASSERT_EQUALS("abc", s);
}

void TestCaseTest::testStringEqualsFailure1()
{
	StringEqualsFailureTestCase1 testCase("StringEqualsFailureTestCase1");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("expected:<abc> but was:<abcd>", failure->what());
}

void TestCaseTest::StringEqualsFailureTestCase2::runTest()
{
	TEST_ASSERT_EQUALS("abc", 0);
}

void TestCaseTest::testStringEqualsFailure2()
{
	StringEqualsFailureTestCase2 testCase("StringEqualsFailureTestCase2");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("expected:<abc> but was:<(null)>", failure->what());
}

void TestCaseTest::StringEqualsFailureTestCase3::runTest()
{
	cu_String s = "xy";
	TEST_ASSERT_EQUALS("xy", s += 'z');
}

void TestCaseTest::testStringEqualsFailure3()
{
	StringEqualsFailureTestCase3 testCase("StringEqualsFailureTestCase3");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("expected:<xy> but was:<xyz>", failure->what());
}

void TestCaseTest::testFail()
{
	FailTestCase testCase("FailTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(0, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* failure = (TestFailure*)result.failures().front();
	TEST_ASSERT_EQUALS("fail", failure->what());
}

void TestCaseTest::testSetUpError()
{
	SetUpErrorTestCase testCase("SetUpErrorTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(!testCase.wasSetUp);
	TEST_ASSERT(!testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(1, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* error = (TestFailure*)result.errors().front();
	TEST_ASSERT_EQUALS("setup error", error->what());
}

void TestCaseTest::testTearDownError()
{
	TearDownErrorTestCase testCase("TearDownErrorTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(!testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(1, result.failureCount());
	TEST_ASSERT_EQUALS(1, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());

	TestFailure* error = (TestFailure*)result.errors().front();
	TEST_ASSERT_EQUALS("tear down error", error->what());
}

#ifndef cu_NO_EXCEPTIONS
void TestCaseTest::testException()
{
	ExceptionTestCase testCase("ExceptionTestCase");
	TestResult result;
	testCase.run(&result);
	TEST_ASSERT(testCase.wasSetUp);
	TEST_ASSERT(testCase.wasTornDown);
	TEST_ASSERT_EQUALS(1, result.runCount());
	TEST_ASSERT_EQUALS(0, result.failureCount());
	TEST_ASSERT_EQUALS(1, result.errorCount());
	TEST_ASSERT(!result.wasSuccessful());
}
#endif

DECLARE_TEST_CALLER(TestCaseTest)

Test* TestCaseTest::suite()
{
	TestSuite* suite = new TestSuite("TestCaseTest");
	suite->addTest(new TEST_CALLER(TestCaseTest, testSuccess));
	suite->addTest(new TEST_CALLER(TestCaseTest, testFailure));
	suite->addTest(new TEST_CALLER(TestCaseTest, testAssertMessage));
	suite->addTest(new TEST_CALLER(TestCaseTest, testIntEqualsSuccess));
	suite->addTest(new TEST_CALLER(TestCaseTest, testIntEqualsFailure));
	suite->addTest(new TEST_CALLER(TestCaseTest, testLongEqualsSuccess));
	suite->addTest(new TEST_CALLER(TestCaseTest, testLongEqualsFailure));
	suite->addTest(new TEST_CALLER(TestCaseTest, testDoubleEqualsSuccess));
	suite->addTest(new TEST_CALLER(TestCaseTest, testDoubleEqualsFailure));
	suite->addTest(new TEST_CALLER(TestCaseTest, testStringEqualsSuccess));
	suite->addTest(new TEST_CALLER(TestCaseTest, testStringEqualsFailure1));
	suite->addTest(new TEST_CALLER(TestCaseTest, testStringEqualsFailure2));
	suite->addTest(new TEST_CALLER(TestCaseTest, testStringEqualsFailure3));
	suite->addTest(new TEST_CALLER(TestCaseTest, testFail));
	suite->addTest(new TEST_CALLER(TestCaseTest, testSetUpError));
	suite->addTest(new TEST_CALLER(TestCaseTest, testTearDownError));
#ifndef cu_NO_EXCEPTIONS
	suite->addTest(new TEST_CALLER(TestCaseTest, testException));
#endif
	return suite;
}
