/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
//
//  FTP Command
//

// # interface class #####
Inf_T::Inf_T(char *host,char *id,char *pass,char *csv_file,char *log_file,char *p_port){  // Ver 0.92
  int port = SujiConvEx(p_port);  // Ver 0.92
  if (port < 0) {port = 21;}      // Ver 0.92
  log_fp = fopen(log_file,"wt");  // Ver 0.92
  ftpInf = new ftpInf_T(host,id,pass,port,log_fp); // Ver 0.92
  csvi   = new CsvInf_T(csv_file);

  if (csvi->CsvError_Rd() != 0       ){printf("csv-file read error(%s)\n",csv_file);}
  if (ftpInf->connectCheck() == false){printf("ftp connect error.\n");}
  if (log_fp == NULL                 ){printf("log-file open error(%s)\n",log_file);}
  }
Inf_T::~Inf_T(){
  delete ftpInf;
  delete csvi;
  if (log_fp != NULL){fclose(log_fp);}
  }


// ---------------
// Main
// ---------------
void Inf_T::Main()
  {
  char *str;

  if (csvi->CsvError_Rd()    != 0    ){return;}
  if (ftpInf->connectCheck() == false){return;}
//  if (log_fp == NULL                 ){return;}

  csvi->sp_push_set(true);  // Ver 0.99
  for(;;)
    {
    if (csvi->CsvFgets() == -1) {break;}
    if (csvi->CsvSelSu_Rd() == 0) {continue;}
    if ((str = csvi->CsvSel_Rd(0)) == MM_NULL) {continue;}
    if (strcmp(str,"#time_stamp"   )==0) {ftpInf->timeconSet();   continue;} // Ver 0.95
    if (strcmp(str,"#down"         )==0) {ftp_rtn    (3,DOWNLOAD     ); continue;}
    if (strcmp(str,"#up"           )==0) {ftp_rtn    (3,UPLOAD       ); continue;}
    if (strcmp(str,"#up_ex"        )==0) {ftp_rtn    (4,UPLOAD_EX    ); continue;} // Ver 0.94
    if (strcmp(str,"#dir_down"     )==0) {ftp_rtn    (3,D_DOWNLOAD   ); continue;}
    if (strcmp(str,"#dir_up"       )==0) {ftp_rtn    (3,D_UPLOAD     ); continue;}
    if (strcmp(str,"#dir_del_serv" )==0) {ftp_rtn    (2,DIR_DEL_SERV ); continue;} // Ver 0.92
    if (strcmp(str,"#dir_del_host" )==0) {ftp_rtn    (2,DIR_DEL_HOST ); continue;} // Ver 0.92
    if (strcmp(str,"#list"         )==0) {ftp_rtn    (3,LIST         ); continue;}
    if (strcmp(str,"#xmode"        )==0) {xmode_rtn  (               ); continue;} // Ver 0.91
    if (strcmp(str,"#mode"         )==0) {mode_rtn   (               ); continue;}
    if (strcmp(str,"#timeout"      )==0) {timeout_rtn(               ); continue;}
    if (strcmp(str,"#retry"        )==0) {retry_rtn  (               ); continue;} // Ver 0.96
    if (strcmp(str,"#del_serv"     )==0) {ftp_rtn    (2,DEL_SERV     ); continue;} // Ver 0.92
    if (strcmp(str,"#del_host"     )==0) {ftp_rtn    (2,DEL_HOST     ); continue;} // Ver 0.92
    if (strcmp(str,"#rename_serv"  )==0) {ftp_rtn    (3,RENAME_SERV  ); continue;} // Ver 0.94
    if (strcmp(str,"#rename_host"  )==0) {ftp_rtn    (3,RENAME_HOST  ); continue;} // Ver 0.94
    if (strcmp(str,"#make_dir_serv")==0) {ftp_rtn    (2,DIR_MAKE_SERV); continue;} // Ver 0.93
    if (strcmp(str,"#make_dir_host")==0) {ftp_rtn    (2,DIR_MAKE_HOST); continue;} // Ver 0.93
    if (strcmp(str,"#sel_mask"     )==0) {sel_mask_rtn(true          ); continue;} // Ver 0.97
    if (strcmp(str,"#unsel_mask"   )==0) {sel_mask_rtn(false         ); continue;} // Ver 0.97
    if (strcmp(str,"#sel_clear"    )==0) {ftpInf->file_fp_clear(     ); continue;} // Ver 0.97
    }
  };


// ----------------------
// #mode
// ----------------------
void Inf_T::mode_rtn()
  {
  int i;
  char *str;

  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (strcmp(str,"ascii"  ) == 0){ftpInf->ascSet(); printf("mode -> ascii mode\n");}
    if (strcmp(str,"binary" ) == 0){ftpInf->binSet(); printf("mode -> binary mode\n");}
    }
  }

// ----------------------
// #xmode
// ----------------------
void Inf_T::xmode_rtn()
  {
  int i;
  char *str;
  ftpInf->xmode_set();
  printf("remote file name space separate mode\n");
  }


// ----------------------
// #timeout
// ----------------------
void Inf_T::timeout_rtn()
  {
  int i;
  char *str;

  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    i = SujiConvEx(str);
   // printf("timeout=%ds set\n",i);
    ftpInf->timeoutSet(i);
    return;
    }
  }

// ----------------------
// #retry
// ----------------------
void Inf_T::retry_rtn()
  {
  int i;
  char *cnt=NULL;
  char *str;

  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (cnt == NULL){cnt = str; continue;}
    ftpInf->retrySet(SujiConvEx(cnt),SujiConvEx(str));
    return;
    }
  }

// ----------------------------------
// #sel_mask/#unsel_mask (ver 0.97)
// ----------------------------------
void Inf_T::sel_mask_rtn(bool sel)
  {
  int i;
  char *str;
  
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (sel){ftpInf->s_file_fp_add(str);}
    else    {ftpInf->u_file_fp_add(str);}
    }
  }



// ----------------------
// #down/#up/#del/#mkdir
// ----------------------
void Inf_T::ftp_rtn(int parm_su,int kbn)
  {
  int i;
  char *str;
  char *p0;
  char *p1;
  char *p2;
  char *p3;   // Ver 0.94

  p0 = NULL;
  p1 = NULL;
  p2 = NULL;
  p3 = NULL;  // Ver 0.94
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (p0 == NULL){p0 = str; continue;}
    if (p1 == NULL){p1 = str; continue;}
    if (p2 == NULL){p2 = str; continue;}
    if (p3 == NULL){p3 = str; continue;}  // Ver 0.94
    break;
    }

  if (kbn == DOWNLOAD     ){printf("Download : "          );}
  if (kbn == UPLOAD_EX    ){printf("Upload extend: "      );} // Ver 0.94
  if (kbn == UPLOAD       ){printf("Upload : "            );}
  if (kbn == DEL_SERV     ){printf("Delete (Server): "    );} // Ver 0.92
  if (kbn == DEL_HOST     ){printf("Delete (Host): "      );} // Ver 0.92
  if (kbn == DIR_DEL_SERV ){printf("Dir Delete (Server): ");} // Ver 0.92
  if (kbn == DIR_DEL_HOST ){printf("Dir Delete (Host): "  );} // Ver 0.92
  if (kbn == RENAME_SERV  ){printf("Rename (Server): "    );} // Ver 0.94
  if (kbn == RENAME_HOST  ){printf("Rename (Host): "      );} // Ver 0.94
  if (kbn == D_DOWNLOAD   ){printf("Dir Download : "      );}
  if (kbn == D_UPLOAD     ){printf("Dir Upload : "        );}
  if (kbn == LIST         ){printf("List : "              );}
  if (kbn == DIR_MAKE_SERV){printf("Dir Make (Server): "  );} // Ver 0.93
  if (kbn == DIR_MAKE_HOST){printf("Dir Make (Host): "    );} // Ver 0.93

  if (parm_su == 2){str = p1;}
  if (parm_su == 3){str = p2;}
  if (parm_su == 4){str = p3;} // Ver 0.94
  if (str == NULL){printf("parameter error\n"); return;}

  // Ver 0.92
  if (kbn == DOWNLOAD     ){fprintf(log_fp,"#cmd,#down,%s,%s,%s\n"       ,p0,p1,p2);}
  if (kbn == UPLOAD_EX    ){fprintf(log_fp,"#cmd,#up,%s,%s,%s,%s\n"      ,p0,p1,p2,p3);} // Ver 0.94
  if (kbn == UPLOAD       ){fprintf(log_fp,"#cmd,#up,%s,%s,%s\n"         ,p0,p1,p2);}
  if (kbn == DEL_SERV     ){fprintf(log_fp,"#cmd,#del_serv,%s,%s\n"      ,p0,p1   );}
  if (kbn == DEL_HOST     ){fprintf(log_fp,"#cmd,#del_host,%s,%s\n"      ,p0,p1   );}
  if (kbn == RENAME_SERV  ){fprintf(log_fp,"#cmd,#rename_serv,%s,%s,%s\n",p0,p1,p2   );} // Ver 0.94
  if (kbn == RENAME_HOST  ){fprintf(log_fp,"#cmd,#rename_host,%s,%s,%s\n",p0,p1,p2   );} // Ver 0.94
  if (kbn == DIR_DEL_SERV ){fprintf(log_fp,"#cmd,#dir_del_serv,%s,%s\n"  ,p0,p1   );}
  if (kbn == DIR_DEL_HOST ){fprintf(log_fp,"#cmd,#dir_del_host,%s,%s\n"  ,p0,p1   );}
  if (kbn == D_DOWNLOAD   ){fprintf(log_fp,"#cmd,#dir_down,%s,%s,%s\n"   ,p0,p1,p2);}
  if (kbn == D_UPLOAD     ){fprintf(log_fp,"#cmd,#dir_up,%s,%s,%s\n"     ,p0,p1,p2);}
  if (kbn == LIST         ){fprintf(log_fp,"#cmd,#list,%s,%s,%s\n"       ,p0,p1,p2);}
  if (kbn == DIR_MAKE_SERV){fprintf(log_fp,"#cmd,#dir_make_serv,%s,%s\n" ,p0,p1   );}
  if (kbn == DIR_MAKE_HOST){fprintf(log_fp,"#cmd,#dir_make_host,%s,%s\n" ,p0,p1   );}


  if (kbn == DOWNLOAD     ){printf("%s -> %s\n" ,p0,p1     ); ftpInf->fileDownLoad(p1,p0,p2);}
  if (kbn == UPLOAD_EX    ){printf("%s -> %s (%s)\n" ,p1,p0,p3  ); ftpInf->fileUpLoad(p1,p0,p2,p3);} // Ver 0.94
  if (kbn == UPLOAD       ){printf("%s -> %s\n" ,p1,p0     ); ftpInf->fileUpLoad  (p1,p0,p2);}
  if (kbn == D_DOWNLOAD   ){printf("%s -> %s\n" ,p0,p1     ); ftpInf->dirDownLoad (p1,p0,p2);}
  if (kbn == D_UPLOAD     ){printf("%s -> %s\n" ,p1,p0     ); ftpInf->dirUpLoad   (p1,p0,p2);}
  if (kbn == DIR_DEL_SERV ){printf("%s(%s)\n" ,p0,p1       ); ftpInf->dirDelServ  (p0,p1   );} // Ver 0.92
  if (kbn == DIR_DEL_HOST ){printf("%s(%s)\n" ,p0,p1       ); ftpInf->dirDelHost  (p0,p1   );} // Ver 0.92
  if (kbn == DEL_SERV     ){printf("%s(%s)\n" ,p0,p1       ); ftpInf->fileDelServ (p0,p1   );} // Ver 0.92
  if (kbn == DEL_HOST     ){printf("%s(%s)\n" ,p0,p1       ); ftpInf->fileDelHost (p0,p1   );} // Ver 0.92
  if (kbn == RENAME_SERV  ){printf("%s %s ->%s\n" ,p0,p1,p2); ftpInf->fileRenameServ (p0,p1,p2);} // Ver 0.94
  if (kbn == RENAME_HOST  ){printf("%s %s ->%s\n" ,p0,p1,p2); ftpInf->fileRenameHost (p0,p1,p2);} // Ver 0.94
  if (kbn == LIST         ){printf("%s -> %s,%s\n",p0,p1,p2); ftpInf->ListOutput  (p0,p1,p2);}
  if (kbn == DIR_MAKE_SERV){printf("%s(%s)\n" ,p0,p1       ); ftpInf->dirMakeServ (p0,p1   );} // Ver 0.93
  if (kbn == DIR_MAKE_HOST){printf("%s(%s)\n" ,p0,p1       ); ftpInf->dirMakeHost (p0,p1   );} // Ver 0.93
  }


