/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
//
//  CSV-File -> HTML-File
//

// interface class -----------------
class Inf_T
{
public:
  sChar    *string;
  CsvInf_T *csvi;
  FILE     *out_fp;
  sChar    *g_key;
  sChar    *g_br;

void output(){
  if (*(string->c_str()) == 0x00){return;}
  fprintf(out_fp,"%s%s\n",string->c_str(),g_br->c_str());
  string->set("");
  g_br->set("");
  g_key->set("");
  }

Inf_T(){
  string = new sChar("");
  g_key  = new sChar("");
  g_br   = new sChar("");
  };
~Inf_T(){
  output();
  delete string;
  delete g_key;
  delete g_br;
  }

void Conv(char *csv_file,char *html_file);
void tag_rtn();
void wr_rtn();
void c_start_rtn();
void c_end_rtn();

};

// ---------------
// Main
// ---------------
void Inf_T::Conv(char *csv_file,char *html_file)
  {
  char *str;

  out_fp = fopen(html_file,"wt");
  csvi   = new CsvInf_T(csv_file);

  if ((out_fp == NULL) || (csvi->CsvError_Rd() != 0))
    {
    if (out_fp != NULL){fclose(out_fp);}
    else               {printf("open error.(file=%s)\n",html_file);}
    delete csvi;
    return;
    }

  printf("conver %s->%s\n",csv_file,html_file);

  for(;;)
    {
    if (csvi->CsvFgets() == -1) {break;}
    if (csvi->CsvSelSu_Rd() == 0) {continue;}
    if ((str = csvi->CsvSel_Rd(0)) == MM_NULL) {continue;}

    sp_push(str); sp_push2(str); // Ver 1.02

    if (strcmp(str,"#tag"    )==0) {tag_rtn    ();}
    if (strcmp(str,"#wr"     )==0) {wr_rtn     ();}
    if (strcmp(str,"#cmd"    )==0) {wr_rtn     ();}
    if (strcmp(str,"#tagchg" )==0) {output     ();}
    }
  output();
  delete csvi;
  fclose(out_fp);
  }

// ---------------
// #tag
// ---------------
void Inf_T::tag_rtn()
  {
  int i;
  char *str;
  char *key;
  char *prop;
  char *val;
  bool chk_flg;

  key  = NULL;
  prop = NULL;
  val  = NULL;
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (key == NULL)
      {
      key = str;
      if (strcmp(g_key->c_str(),key) != 0)
        {
        output();
        g_key->set(str);
        string->set("<");
        string->cat(key);
        g_br->set(">");
        }
      continue;
      }
    if (prop == NULL){prop = str; continue;}
    val = str;
    break;
    }
  if (prop != NULL)
    {
    chk_flg = false;
    for(i=0;i<(int)strlen(prop);++i)
      {
      if (*(prop+i) == ' '){chk_flg = true; break;}
      }
    if (chk_flg == false){string->cat(" ");}
    else                 {string->cat(" \"");}
    string->cat(prop);
    if (chk_flg == true){string->cat("\"");}
    }
  if (val  != NULL){string->cat("=\""); string->cat(val); string->cat("\"");}
  }

// ---------------
// #wr
// ---------------
void Inf_T::wr_rtn()
  {
  int i;
  char *str;

  output();
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    string->cat(str);
    }
  }


