/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

//
//  HTTP Command Line downloader
//


// ---------------------
// # http callback
// ---------------------
void CALLBACK InternetStatusCallback(
  IN HINTERNET hInternet,
  IN DWORD Context,
  IN DWORD Status,
  IN LPVOID StatusInfo,
  IN DWORD StatusInfoSize){

  LPDWORD lpdwByte;
  switch(Status) {
//    case INTERNET_STATUS_CONNECTING_TO_SERVER:printf("CONNECTING TO %s\n", (char*)StatusInfo); break;
//    case INTERNET_STATUS_CONNECTED_TO_SERVER :printf("CONNECTED TO %s\n" , (char*)StatusInfo); break;
    case INTERNET_STATUS_RESPONSE_RECEIVED   :lpdwByte = (LPDWORD)StatusInfo; length += *lpdwByte; printf("%dbyte\r",length); break;
//    case INTERNET_STATUS_CONNECTION_CLOSED   :printf("CONNECTION CLOSED\n");                   break;

    }
  }

// ---------------
// Constructor
// ---------------
httpC::httpC(char *csv_file,char *log_file)
  {
  int        i;
  char      *str;
  Head_T    *head;
  UrlParm_T *url;

  it         = new MemHeader_T;
  head_fp    = new MEM_FP(it);
  parm_fp    = new MEM_FP(it);
  sv_parm_fp = new MEM_FP(it);
  log_fp     = fopen(log_file,"wt");
  csvi       = new CsvInf_T(csv_file);
  id         = new sChar("");
  pass       = new sChar("");
  proxyFlg   = false;
  proxyHost  = new sChar("");
  proxyPort  = 0;
  execUrl    = new sChar("");
  execFile   = new sChar("");
  execKbn    = K_NONE;
  headStr    = new sChar("");
  parmStr    = new sChar("");

  if (log_fp              == NULL){printf("file open error.(file=%s)\n",log_file);}
  if (csvi->CsvError_Rd() != 0   ){printf("file open error.(file=%s)\n",csv_file);}
  if ((log_fp == NULL) || (csvi->CsvError_Rd() != 0))
    {
    if (log_fp != NULL){fclose(log_fp);}
    delete csvi;
    log_fp = NULL;
    csvi   = NULL;
    return;
    }


  csvi->sp_push_set(true);  
  for(;;)
    {
    if (csvi->CsvFgets() == -1) {break;}
    if (csvi->CsvSelSu_Rd() == 0) {continue;}
    if ((str = csvi->CsvSel_Rd(0)) == MM_NULL) {continue;}

    if (strcmp(str,"#get"    )==0) {get_post_rtn(K_GET); continue;}
    if (strcmp(str,"#post"    )==0) {get_post_rtn(K_POST); continue;}
    if (strcmp(str,"#snd_head")==0) {snd_head_rtn (      ); continue;}
    if (strcmp(str,"#proxy"   )==0) {proxy_rtn    (      ); continue;}
    if (strcmp(str,"#parm"    )==0) {parm_rtn     (      ); continue;}
    if (strcmp(str,"#parmchg" )==0) {parmchg_rtn  (      ); continue;}
    }

  UrlExec();
  fclose(log_fp);
  MEM_LOOP(head,Head_T   ,head_fp   ) delete head; LOOP_END
  MEM_LOOP(url ,UrlParm_T,parm_fp   ) delete url;  LOOP_END
  MEM_LOOP(url ,UrlParm_T,sv_parm_fp) delete url;  LOOP_END
  delete csvi;
  delete execUrl;
  delete execFile;
  delete headStr;
  delete parmStr;
  delete id;
  delete pass;
  delete proxyHost;
  delete head_fp;
  delete parm_fp;
  delete sv_parm_fp;
  delete it;
  }

// ----------------------
// #parm
// ----------------------
void httpC::parm_rtn()
  {
  int i;
  char *str;
  char *key;
  sChar *s_str;
  char crlf[3];
  UrlParm_T *p;

  key= NULL;
  crlf[0] = 0x0d;
  crlf[1] = 0x0a;
  crlf[2] = 0x00;

  s_str = new sChar("");
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (key==NULL)
      {
      key = str;
      it->srch_key = key;
      if (parm_fp->mem_srch() == 0)
        {
        p = (UrlParm_T *)parm_fp->mem_link_ptr_rd();
        s_str->cat(p->value->c_str());
        s_str->cat(crlf);
        }
      continue;
      }
    s_str->cat(str);
    }

  if (key == NULL){return;}
  it->srch_key = key;
  if (parm_fp->mem_srch() == 0)
    {
    p = (UrlParm_T *)parm_fp->mem_link_ptr_rd();
    p->value->set(s_str->c_str());
    }
  else
    {
    it->alloc_ptr = new UrlParm_T(key,s_str->c_str(),0);
    parm_fp->mem_srch_alloc();
    }
  delete s_str;
  }

// ----------------------
// #parmchg
// ----------------------
void httpC::parmchg_rtn()
  {
  UrlParm_T *p;
  MEM_LOOP(p,UrlParm_T,parm_fp)
    it->alloc_ptr = (MM_PTR_T *)p;
    sv_parm_fp->mem_alloc();
  LOOP_END
  parm_fp->mem_del_all();
  }

// ----------------------
// #auth
// ----------------------
void httpC::auth_rtn()
  {
  int i;
  char *str;
  char *p_id;

  p_id = NULL;
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (p_id == NULL){p_id = str; continue;}
    id->set(p_id);
    pass->set(str);
    break;
    }
  }

// ----------------------
// #proxy
// ----------------------
void httpC::proxy_rtn()
  {
  int i;
  char *str;
  char *proxy;

  proxy = NULL;
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (proxy == NULL){proxy = str; continue;}
    proxyFlg = true;
    proxyHost->set(proxy);
    proxyPort = SujiConvEx(str);
    if (proxyPort <= 0){proxyPort = 8080;}
    printf("ProxySet[%s:%d]\n", proxyHost->c_str(),proxyPort);
    break;
    }
  }


// ----------------------
// #snd_head
// ----------------------
void httpC::snd_head_rtn()
  {
  int i;
  char *str;
  char *key;
  sChar *val;
  Head_T *head;
//  bool first;

  key = NULL;
//  first = true;
  val = new sChar("");
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (key == NULL){key = str; continue;}
//    if (first == true){first = false;}
    else              {val->cat(" ");}
    val->cat(str);
    break;
    }

  if (key == NULL){delete val; return;}
  head = new Head_T(key,val->c_str());
  it->alloc_ptr = (MM_PTR_T *)head;
  head_fp->mem_alloc();
  delete val;
  }

// ----------------------
// #get/#post
// ----------------------
void httpC::get_post_rtn(int kbn)
  {
  int i;
  char *str;
  char *w_url;
  char *w_local;
  char *w_file;

  w_url   = NULL;
  w_local = NULL;
  w_file  = NULL;
  UrlExec();
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (w_url   == NULL){w_url   = str; continue;}
    if (w_local == NULL){w_local = str; continue;}
    w_file = str;
    break;
    }

  if (w_local == NULL){return;}
  execUrl->set (w_url  );
  execFile->set(w_local);
  if (w_file != NULL)
    {
    if (*(w_url  +strlen(w_url  )-1) != '/' ){execUrl->cat("/"  );} execUrl->cat(w_file);
    if (*(w_local+strlen(w_local)-1) != '\\'){execFile->cat("\\");} execFile->cat(w_file);
    }
  execKbn = kbn;
  }


// ----------------------
// initialize
// ----------------------
void httpC::init()
  {
  Head_T    *head;
  UrlParm_T *url;

  MEM_LOOP(head,Head_T   ,head_fp   ) delete head; LOOP_END
  MEM_LOOP(url ,UrlParm_T,parm_fp   ) delete url;  LOOP_END
  MEM_LOOP(url ,UrlParm_T,sv_parm_fp) delete url;  LOOP_END

  head_fp->mem_del_all();
  parm_fp->mem_del_all();
  sv_parm_fp->mem_del_all();
  id->set("");
  pass->set("");
  execUrl->set("");
  execFile->set("");
  execKbn = K_NONE;
  }


// ----------------------
// url exec
// ----------------------
void httpC::UrlExec()
  {
  sChar     *w;
  UrlParm_T *p;
  Head_T    *h;
  bool       first;
  char szScheme[256], szServerName[256], szUserName[256], szPassword[256],szObjectName[256], szExtraInfo[256];
  URL_COMPONENTSA UrlComponents;  

  if (execKbn == K_NONE){return;}

  headStr->set("");
  MEM_LOOP(h,Head_T,head_fp)
    headStr->cat(h->key->c_str());
    headStr->cat(":");
    headStr->cat(h->value->c_str());
    headStr->cat("\r\n\r\n");
  LOOP_END

  parmStr->set("");
  first = true;
  MEM_LOOP(p,UrlParm_T,sv_parm_fp)
    if (first){first = false;}
    else      {parmStr->cat("&");}
    parmStr->cat(p->key->c_str());
    parmStr->cat("=");
    parmStr->cat(p->value->c_str());
  LOOP_END
  MEM_LOOP(p,UrlParm_T,parm_fp)
    if (first){first = false;}
    else      {parmStr->cat("&");}
    parmStr->cat(p->key->c_str());
    parmStr->cat("=");
    parmStr->cat(p->value->c_str());
  LOOP_END

//  if (strcmp(headStr->c_str(),"")!=0){printf("[snd_head]\n%s",headStr->c_str());}
//  if (strcmp(parmStr->c_str(),"")!=0){printf("[parameter]\n%s",parmStr->c_str());}
//  if (first == false){printf("\n");}

  hSession = NULL;
  hService = NULL;
  hHttpRequest = NULL;
  fp = NULL;

  if (execKbn == K_GET ){fprintf(log_fp,"#command,GET,%s\n",execUrl->c_str()); printf("get %s\n",execUrl->c_str());}
  if (execKbn == K_POST){fprintf(log_fp,"#command,POST,%s\n",execUrl->c_str()); printf("post %s\n",execUrl->c_str());}

  if (proxyFlg)
    {
    w = new sChar(proxyHost->c_str());
    w->cat(":");
    w->intcat(proxyPort);
    hSession = InternetOpen( "csvhttp", INTERNET_OPEN_TYPE_PROXY, w->c_str(), NULL, 0 );
    delete w;
    }
  else
    {
    hSession = InternetOpen( "csvhttp", INTERNET_OPEN_TYPE_DIRECT, NULL, NULL, 0 );
    }
  if(!hSession){UrlExecClose("NG","session error"); return;}

  length = 0;
  InternetSetStatusCallback(hSession, InternetStatusCallback);

  if (execKbn == K_GET)
    {
    if (strcmp(headStr->c_str(),"")==0){hService=InternetOpenUrl(hSession,execUrl->c_str(),NULL,0,0,1);}
    else                               {hService=InternetOpenUrl(hSession,execUrl->c_str(),headStr->c_str(),strlen(headStr->c_str()),0,1);}
    if(!hService){UrlExecClose("NG","service error"); return;}
    }
  else
    {
    UrlComponents.dwStructSize = sizeof(URL_COMPONENTSA);	//R|[lg̃TCYm
    UrlComponents.nScheme = INTERNET_SCHEME_DEFAULT;
    UrlComponents.lpszScheme    = szScheme;	// Schemë̗̊m
    UrlComponents.dwSchemeLength    = 256;
    UrlComponents.lpszHostName  = szServerName;	// HostNamë̗̊m
    UrlComponents.dwHostNameLength  = 256;
    UrlComponents.lpszUserName  = szUserName;	// UserNamë̗̊m
    UrlComponents.dwUserNameLength  = 256;
    UrlComponents.lpszPassword  = szPassword;	// Password̗̈̊m
    UrlComponents.dwPasswordLength  = 256;
    UrlComponents.lpszUrlPath   = szObjectName;	// UrlPatḧ̗̊m
    UrlComponents.dwUrlPathLength   = 256;
    UrlComponents.lpszExtraInfo = szExtraInfo;	// ExtraInfö̗̊m
    UrlComponents.dwExtraInfoLength = 256;

    InternetCrackUrl( execUrl->c_str(), strlen(execUrl->c_str()), ICU_DECODE, &UrlComponents );
    hService = InternetConnect(hSession,szServerName,UrlComponents.nPort,NULL,NULL,INTERNET_SERVICE_HTTP,0,0);
    if(!hService){UrlExecClose("NG","service error"); return;}
    hHttpRequest = HttpOpenRequest(hService,"POST",szObjectName,NULL,NULL,0,0,0);
    if(!hHttpRequest){UrlExecClose("NG","request error"); return;}
    }

  if (strcmp(id->c_str(),"") != 0)
    {
    InternetSetOption( hService, INTERNET_OPTION_USERNAME, id->c_str()  , strlen(id->c_str()  ));
    InternetSetOption( hService, INTERNET_OPTION_PASSWORD, pass->c_str(), strlen(pass->c_str()));
    }

  char lpBuffer[1024+1];
  DWORD dwBytesRead = 1024;

  if (execKbn == K_POST)
    {
    if (strcmp(headStr->c_str(),"")==0)
      {
      if(!HttpSendRequest(hHttpRequest,NULL,0,parmStr->c_str(),strlen(parmStr->c_str()))){UrlExecClose("NG","post error"); return;}
      }
    else
      {
      if(!HttpSendRequest(hHttpRequest,headStr->c_str(),strlen(headStr->c_str()),parmStr->c_str(),strlen(parmStr->c_str()))){UrlExecClose("NG","post error"); return;}
      }

    if(!HttpQueryInfo(hHttpRequest,HTTP_QUERY_RAW_HEADERS_CRLF | HTTP_QUERY_FLAG_REQUEST_HEADERS,lpBuffer,&dwBytesRead,NULL)){UrlExecClose("NG","header error"); return;}
    }
  else
    {
    if(!HttpQueryInfo(hService,HTTP_QUERY_RAW_HEADERS_CRLF | HTTP_QUERY_FLAG_REQUEST_HEADERS,lpBuffer,&dwBytesRead,NULL)){UrlExecClose("NG","header error"); return;}
    }

  StrSrchInf_T *ssc,*ssc2;
  ssc = new StrSrchInf_T;
  ssc2 = new StrSrchInf_T;
  ssc->Set('\r');
  ssc->Set('\n');
  ssc2->Set(':'); ssc2->SetFlg();
  ssc->Main(lpBuffer);
  for(int i=0;i<ssc->GetSu();i++)
    {
    sChar *ss = ssc->Get(i);
    ssc2->Main(ss->c_str());
    for(int j=0;j<ssc2->GetSu();j++)
      {
      sChar *s = ssc2->Get(j);
      if (j == 0){fprintf(log_fp,"#snd_head,%s,",s->c_str());}
      if (j >  1){fprintf(log_fp,"%s",s->c_str());}
      }
    fprintf(log_fp,"\n");
    }


  if (execKbn == K_POST)
    {
    HttpQueryInfo(hHttpRequest,HTTP_QUERY_RAW_HEADERS_CRLF,lpBuffer,&dwBytesRead,NULL);
    }
  else
    {
    HttpQueryInfo(hService,HTTP_QUERY_RAW_HEADERS_CRLF,lpBuffer,&dwBytesRead,NULL);
    }

  ssc->Main(lpBuffer);
  for(int i=0;i<ssc->GetSu();i++)
    {
    sChar *ss = ssc->Get(i);
    ssc2->Main(ss->c_str());
    for(int j=0;j<ssc2->GetSu();j++)
      {
      sChar *s = ssc2->Get(j);
      if (j == 0){fprintf(log_fp,"#rcv_head,%s,",s->c_str());}
      if (j >  1){fprintf(log_fp,"%s",s->c_str());}
      }
    fprintf(log_fp,"\n");
    }

  delete ssc;
  delete ssc2;

  if((fp=fopen(execFile->c_str(), "wb")) != NULL )
    {
    while(1)
      {
      if (execKbn == K_POST)
        {
        InternetReadFile( hHttpRequest, lpBuffer, 1024, &dwBytesRead );
        }
      else
        {
        InternetReadFile( hService, lpBuffer, 1024, &dwBytesRead );
        }

      if( dwBytesRead == 0 ) {break;}
      fwrite( lpBuffer, dwBytesRead, 1, fp );
      }
    UrlExecClose("OK","");
    }
  else
    {
    UrlExecClose("NG","file open error");
    }
  }


// ----------------------
// url exec close
// ----------------------
void httpC::UrlExecClose(char *msg,char *msg2)
  {
  if (hHttpRequest != NULL){InternetCloseHandle(hHttpRequest);}
  if (hService     != NULL){InternetCloseHandle(hService);}
  if (hSession     != NULL){InternetCloseHandle(hSession);}
  if (fp           != NULL){fclose(fp);}

  if (strcmp(msg,"OK") == 0)
    {
    fprintf(log_fp,"#resp,SUCCESS,");
    printf("complete.                                   \n");
    }
  else
    {
    fprintf(log_fp,"#resp,FAIL,");
    printf("%s ... %s                                   \n",msg,msg2);
    }
  if   (execKbn == K_GET){fprintf(log_fp,"GET,");}
  else                   {fprintf(log_fp,"POST,");}
  if (strcmp(msg,"OK") == 0){fprintf(log_fp,"\n");}
  else                      {fprintf(log_fp,"%s\n",msg2);}

  init();
  return;
  }


