/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

//
//  HTTP Command Line downloader
//
// parameter ----------------------------
#define K_NONE 0
#define K_GET 1
#define K_POST 2

int length;

class UrlParm_T
{
  public:
  sChar *key;
  sChar *value;
  int    kbn;
  UrlParm_T(char *p_key,char *p_val,int p_kbn){
    key   = new sChar(p_key);
    value = new sChar(p_val);
    kbn   = p_kbn;
    }
  ~UrlParm_T(){
    delete key;
    delete value;
    }
};

// head ----------------------------
class Head_T
{
  public:
  sChar *key;
  sChar *value;
  Head_T(char *p_key,char *p_val){
    key   = new sChar(p_key);
    value = new sChar(p_val);
    }
  ~Head_T(){
    delete key;
    delete value;
    }
};

// interface class -----------------
class httpC{
public:
  MemHeader_T *it;
  MEM_FP   *head_fp;     // cell:Head_T
  MEM_FP   *parm_fp;     // cell:UrlParm_T
  MEM_FP   *sv_parm_fp;  // cell:UrlParm_T
  CsvInf_T *csvi;
  FILE     *log_fp;
  sChar    *id;
  sChar    *pass;
  bool      proxyFlg;
  sChar    *proxyHost;
  int       proxyPort;
  sChar    *execUrl;
  int       execKbn;
  sChar    *execFile;
  sChar    *headStr;
  sChar    *parmStr;
  HINTERNET hSession;
  HINTERNET hService;
  HINTERNET hHttpRequest;
  FILE     *fp;


  httpC(char *csv_file,char *log_file);
  void parm_rtn();
  void parmchg_rtn();
  void auth_rtn();
  void proxy_rtn();
  void snd_head_rtn();
  void get_post_rtn(int kbn);
  void init();
  void UrlExec();
  void UrlExecClose(char *msg,char *msg2);
};
