/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
//
//  mail decode Control
//

decodeInf_T::decodeInf_T(char *in_file,char *out_file,char *p_dir)
  {
  char *w;
  in_fp      = fopen(in_file,"rt");
  out_fp     = fopen(out_file,"wt");
  iso_body   = new Iso2022_T(0);
  base64     = new Base64_T();
  sstr       = new sChar("");
  boundaryFlg = false;
  boundaryStr = new sChar("--");
  boundaryStrEnd = new sChar("");
  boundaryCnt = 0;
  attachFlg   = false;
  attachStr   = new sCharGrep("");
  attachFile  = new sChar("");
  attachCnt   = 0;
  attachFp    = -1;
  state       = S_HEADER;
  dir         = new sChar(p_dir);
  it          = new MemHeader_T; // Ver 0.92
  header_fp   = new MEM_FP(it);  // Ver 0.92
  header_str  = NULL;            // Ver 0.92
  p_en_sep[0] = 0x1b;
  p_en_sep[1] = 0x24;
  p_en_sep[2] = 0x42;
  p_en_sep[3] = 0x00;
  p_dis_sep[0] = 0x1b;
  p_dis_sep[1] = 0x28;
  p_dis_sep[2] = 0x42;
  p_dis_sep[3] = 0x00;
  body_str     = new sChar("");
  sjisFlg      = false;

  w = dir->c_str();
  if (*(w+strlen(w)-1) != '\\'){dir->cat("\\");}

  if ((in_fp == NULL) || (out_fp == NULL))
    {
    if (in_fp  != NULL){fclose(in_fp);}
    if (out_fp != NULL){fclose(out_fp);}
    in_fp  = NULL;
    out_fp = NULL;
    return;
    }

  for(;;)
    {
    if (fgets(buff,sizeof(buff),in_fp) == NULL){break;}
    int len = strlen(buff);

    if (len > 0)
      {
      if (*(buff+strlen(buff)-1) < 0x20){*(buff+strlen(buff)-1) = 0x00;}
      }
    if (mem_cmp(buff,"#getno,",7) == 0)
      {
      fprintf(out_fp,"%s\n",buff);
      state = S_HEADER;
      boundaryFlg = false;
      attachFlg   = false;
      boundaryStr->set("--");
      continue;
      }
    if (mem_cmp(buff,"#wr,"   ,4) == 0)
      {

      if (state == S_HEADER){header_rtn(buff+4); continue;}
      if (state == S_BODY  ){body_rtn  (buff+4); continue;}
      if (state == S_ATTACH){attach_rtn(buff+4); continue;}
      }
    }
  
  }

decodeInf_T::~decodeInf_T()
  {
  sChar *str;
  MEM_LOOP(str,sChar,header_fp) delete str; LOOP_END  // Ver 0.92
  delete header_fp;                                   // Ver 0.92
  delete body_str;

  delete iso_body;
  delete base64;
  delete sstr;
  delete boundaryStr;
  delete boundaryStrEnd;
  delete attachStr;
  delete attachFile;
  delete dir;

  if (attachFp != -1  ){close (attachFp);}
  if (in_fp    != NULL){fclose(in_fp   );}
  if (out_fp   != NULL){fclose(out_fp  );}
  }

// # colon Check Ver 0.92 #####
bool decodeInf_T::colonCheck(char *w)
  {
  bool flg=false;
  for(;;w++)
    {
    if (*w == 0x00){break;}
    if (*w == ':'){return(true);}
//    if (flg)
//      {
//      if (*w != ' '){return(true);}
//      }
    }
  return(false);
  }

// # Header routine #####
void decodeInf_T::header_rtn(char *str)
  {
  sChar *s_str;
  // # result skip #####
  if (mem_cmp(str,"+OK ",4) == 0){return;}
  // # header end #####
  if (*str == 0x00)
    {
    header_str = NULL;
    MEM_LOOP(s_str,sChar,header_fp)
      header_output(s_str->c_str());
    LOOP_END
    MEM_LOOP(s_str,sChar,header_fp)
      delete s_str;
    LOOP_END
    header_fp->mem_del_all();

    if (attachFlg)
      {
      state = S_ATTACH;
      attachFile->set(dir->c_str());
      attachFile->cat("attach");
      attachFile->intcat(attachCnt++);
      attachFile->cat(".dat");
      if (attachFp != -1){close(attachFp);}
      FILE *dmy_fp = fopen(attachFile->c_str(),"wt");
      fclose(dmy_fp);
      attachFp = open(attachFile->c_str(),O_WRONLY|O_BINARY);
      fprintf(out_fp,"#attach,%s,%s\n",attachStr->c_str(),attachFile->c_str());
      sstr->set("");
      }
    else
      {
      state = S_BODY;
      }

    return;
    }

  // # first string #####
  if (header_str == NULL)
    {
    header_str    = new sChar(str);
    it->alloc_ptr = header_str;
    header_fp->mem_alloc();
    return;
    }

  // # adding string #####
  if ((*str == ' ') || (*str == '\t'))
    {
    header_str->cat(" ");
    header_str->cat(str+1);
    return;
    }

  // # colon Check #####
  if (colonCheck(str) == false)
    {
    header_str->cat(str);
    return;
    }

  // # colon Check #####
  //  -> colon nahi no toki adding string
  if (colonCheck(header_str->c_str()) == false)
    {
    header_str->cat(str);
    return;
    }

  // # new line #####
  header_str    = new sChar(str);
  it->alloc_ptr = header_str;
  header_fp->mem_alloc();
  }

// # string search Ver 0.92 #####
char *decodeInf_T::strSrch(char *str,char *srch)
  {
  if (str == NULL){return(NULL);}
  int len = strlen(srch);
  for(;;str++)
    {
    if (*str == 0x00){break;}
    if (mem_cmp(str,srch,len) == 0){return(str+len);}
    }
  return(NULL);
  }

// # string search Ver 0.92 #####
char *decodeInf_T::strSrch(char *str,char *srch,char *srch2)
  {
  return(strSrch(strSrch(str,srch),srch2));
  }

// # header output #####
void decodeInf_T::header_output(char *str)
  {
  char *w,*context;

  // # NULL SKIP #####
  if (*str == 0x00){return;}

  // # TAG Check #####
  if ((context = strSrch(str,":")) == NULL) // TAG NONE
    {
    fprintf(out_fp,"#head,%s\n",str);
    return;
    }
  else
    {
    *(context-1) = 0x00;
    }

  // # komoji convert #####
  for(w=str;;w++)
    {
    if (*w == 0x00){break;}
    if ((*w >= 'A') && (*w <= 'Z')) {*w = *w - 'A' + 'a';}
    }

  // # boundary string get #####
  if (strcmp(str,"content-type") == 0)
    {
    if ((boundaryFlg == false) && ((w = strSrch(context,"boundary","=")) != NULL))
      {
      boundaryFlg = true;
      sCharGrep *ss = new sCharGrep(w+1);
      ss->replace_all("\""," ");
      ss->Push();
      boundaryStr->cat(ss->c_str());
      boundaryStrEnd->set(boundaryStr->c_str());
      boundaryStrEnd->cat("--");
      delete ss;
      }
    }

  // # attach string get #####
  if ((strcmp(str,"content-disposition") == 0)
   || (strcmp(str,"content-type"       ) == 0))
    {
    attachChk(context);
    }

  char *ww = base64->decode(context);
  fprintf(out_fp,"#head,%s,%s\n",str,ww);

  // Ver 0.94
  if (strcmp(str,"date") == 0)
    {
    StrSrchInf_T *ssc = new StrSrchInf_T;
    ssc->Set(',');
    ssc->Set(' ');

    ssc->Main(ww);
    if (ssc->GetSu()>5)
      {
      sChar *s;
      s = ssc->Get(3);
      fprintf(out_fp,"#date,%s/",s->c_str());
      s = ssc->Get(2);
      if (strcmp(s->c_str(),"Jan")==0){fprintf(out_fp,"1");}
      if (strcmp(s->c_str(),"Feb")==0){fprintf(out_fp,"2");}
      if (strcmp(s->c_str(),"Mar")==0){fprintf(out_fp,"3");}
      if (strcmp(s->c_str(),"Apr")==0){fprintf(out_fp,"4");}
      if (strcmp(s->c_str(),"May")==0){fprintf(out_fp,"5");}
      if (strcmp(s->c_str(),"Jun")==0){fprintf(out_fp,"6");}
      if (strcmp(s->c_str(),"Jul")==0){fprintf(out_fp,"7");}
      if (strcmp(s->c_str(),"Aug")==0){fprintf(out_fp,"8");}
      if (strcmp(s->c_str(),"Sep")==0){fprintf(out_fp,"9");}
      if (strcmp(s->c_str(),"Oct")==0){fprintf(out_fp,"10");}
      if (strcmp(s->c_str(),"Nov")==0){fprintf(out_fp,"11");}
      if (strcmp(s->c_str(),"Dec")==0){fprintf(out_fp,"12");}
      s = ssc->Get(1);
      fprintf(out_fp,"/%s\n",s->c_str());
      s = ssc->Get(4);
      fprintf(out_fp,"#time,%s\n",s->c_str());
      }

    delete ssc;
    }

  }

// # body routine #####
void decodeInf_T::body_rtn(char *str)
  {
  if (boundaryFlg)
    {
    if ((strcmp(boundaryStr->c_str(),str) == 0) || (strcmp(boundaryStrEnd->c_str(),str) == 0))
      {
      sstr->set("");  // Ver 0.91

      state = S_HEADER;
      ++boundaryCnt;
      fprintf(out_fp,"#boundary\n");
      attachFlg = false;
      return;
      }
    }

  char *w=str;
  for(;;)
    {
    if (sjisFlg)
      {
      if ((w=strSrch(w,p_dis_sep)) == NULL){break;}
      sjisFlg = false;
      }
    else
      {
      if ((w=strSrch(w,p_en_sep)) == NULL){break;}
      sjisFlg = true;
      }
    }
  body_str->cat(str);
  if (sjisFlg==false)
    {
    fprintf(out_fp,"#wr,%s\n",iso_body->decord(body_str->c_str()));
    body_str->set("");
    }
  }

// # attach routine #####
void decodeInf_T::attach_rtn(char *str)
  {
  if (boundaryFlg == false){return;}

  if ((strcmp(boundaryStr->c_str(),str) == 0) || (strcmp(boundaryStrEnd->c_str(),str) == 0))
    {
    state = S_HEADER;
    ++boundaryCnt;
    fprintf(out_fp,"#boundary\n");
    attachFlg = false;
    write(attachFp, base64->base64_sjis_attach(sstr->c_str()),(strlen(sstr->c_str())/4)*3);
    sstr->set("");
    return;
    }
  else
    {
    sstr->cat(str);
    }
  }



// # attach file name get #####
void decodeInf_T::attachChk(char *str)
  {
  char *w;
  bool kanji = false;

  // # Check ####
  if ((strSrch(str,"attachment") == NULL)
   && (strSrch(str,"image"     ) == NULL)){return;}
  if ((str = strSrch(str,"name" )) == NULL) {return;}

  // # kanji check #####
  if (strSrch(str,"*") != NULL){kanji = true;}

  // # file name pointer get #####
  if ((str = strSrch(str,"=" )) == NULL) {return;}

  // # non kanji get #####
  if (kanji == false)
    {
    attachFlg = true;
    attachStr->set(str);
    attachStr->replace_all("\""," ");
    attachStr->Push();
    return;
    }

  // # kanji file get #####
  if ((str = strSrch(str,"'","'")) == NULL) {return;}

  attachFlg = true;

  int mode;
  char *kk;
  char *kkk;
  int a0;
  int a1;
  sChar *dmy;
  sChar *dmy2;
  dmy = new sChar(str);
  dmy2 = new sChar("");

  mode = 0;
  kk = dmy->c_str();
  kkk = dmy->c_str();

  for(;;str++)
    {
    if (*str == 0x00){break;}
    if (*str == ';')
      {
      for(;;str++)
        {
        if (*str == 0x00){str--; break;}
        if (*str == '='){ break;}
        }
      continue;
      }

    if (mode == 0)
      {
      if (*str == '%')
        {
        mode = 1;
        }
      else
        {
        *kk++ = *str;
        }
      continue;
      }
    if (mode == 1)
      {
      mode = 2;
      if ((*str >= '0') && (*str <= '9')){a0 = *str - '0';}
      if ((*str >= 'A') && (*str <= 'F')){a0 = *str - 'A' + 10;}
      if ((*str >= 'a') && (*str <= 'f')){a0 = *str - 'a' + 10;}
      continue;
      }
    if (mode == 2)
      {
      mode = 0;
      if ((*str >= '0') && (*str <= '9')){a1 = *str - '0';}
      if ((*str >= 'A') && (*str <= 'F')){a1 = *str - 'A' + 10;}
      if ((*str >= 'a') && (*str <= 'f')){a1 = *str - 'a' + 10;}
      *kk = (a0<<4) + a1;
      kk++;
      continue;
      }
    }
  *kk = 0x00;

  kk = kkk;
  dmy2->set(kkk);
  kkk = dmy2->c_str();
  bool flg;
  flg = false;
  for(;;)
    {
    if (*kk == 0x00){break;}
    if (flg == false)
      {
      if (*kk == 0x1b)
        {
        if (*(kk+1) == 0x24)
          {
          flg = true;
          kk += 3;
          continue;
          }
        }
      *kkk++ = *kk++;
      continue;
      }

    if (*kk == 0x1b)
      {
      if (*(kk+1) == 0x28)
        {
        flg = false;
        kk += 3;
        continue;
        }
      }
    jis_sjis(*(kk),*(kk+1));
    *kkk++ = g_c1;
    *kkk++ = g_c2;

    kk += 2;
    }
  *kkk = 0x00;

  attachStr->set(dmy2->c_str());
  delete dmy;
  delete dmy2;
  }


void decodeInf_T::jis_sjis(unsigned char p_c1,unsigned p_c2)
  {
  g_c1 = p_c1;
  g_c2 = p_c2;

  if (g_c1 % 2)
    {
    g_c1 =((g_c1 +1)/2)+0x70;
    g_c2 =g_c2 +0x1f;
    }
  else
    {
    g_c1 =(g_c1 /2)+0x70;
    g_c2 =g_c2 +0x7d;
    }
  if (g_c1 >=0xa0){g_c1 =g_c1 +0x40;}
  if (g_c2 >=0x7f){g_c2 =g_c2 +1;}
  }



