/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
//
//  mail encode Control
//
encodeInf_T::encodeInf_T(char *in_file,char *out_file){
  char *str;
  sChar *sstr;
  to_T  *w_to;
  bool first;

  iso_body  = new Iso2022_T();
  base64    = new Base64_T();
  from_addr = new sChar("");
  from_name = new sChar("");
  subject   = new sChar("");
  timeout   = new sChar("10000");
  it        = new MemHeader_T;
  wr_fp     = new MEM_FP(it);
  to_fp     = new MEM_FP(it);
  file_fp   = new MEM_FP(it);
  head_fp   = new MEM_FP(it); // Ver 0.92
  boundary  = new sChar("boundary___?_A_Z_?B?X+Y");
  attachFlg = false;

  csvi   = new CsvInf_T(in_file);
  out_fp = fopen(out_file,"wt");
  if ((csvi->CsvError_Rd() != 0) || (out_fp == NULL))
    {
    if (csvi->CsvError_Rd() != 0){printf("file open error.(file=%s)\n",in_file);}
    if (out_fp == NULL){printf("file open error.(file=%s)\n",out_file);}
    else               {fclose(out_fp);}
    delete csvi;
    csvi = NULL;
    out_fp = NULL;
    return;
    }

  for(;;)
    {
    if (csvi->CsvFgets() == -1) {break;}
    if (csvi->CsvSelSu_Rd() == 0) {continue;}
    if ((str = csvi->CsvSel_Rd(0)) == MM_NULL) {continue;}
    sp_push(str); sp_push2(str); // Ver 0.94

    if (strcmp(str,"#from"   )==0) {from_rtn   ( );}
    if (strcmp(str,"#head"   )==0) {head_rtn   ( );} // Ver 0.92
    if (strcmp(str,"#subject")==0) {subject_rtn( );}
    if (strcmp(str,"#wr"     )==0) {wr_rtn     ( );}
    if (strcmp(str,"#to"     )==0) {to_rtn     (0);}
    if (strcmp(str,"#cc"     )==0) {to_rtn     (1);}
    if (strcmp(str,"#bcc"    )==0) {to_rtn     (2);}
    if (strcmp(str,"#attach" )==0) {file_rtn   ( );}
    if (strcmp(str,"#timeout")==0) {timeout_rtn( );}
    }

  fprintf(out_fp,"#timeout,%s\n",timeout->c_str());  
  fprintf(out_fp,"#mail_from,%s\n",from_addr->c_str());
  MEM_LOOP(w_to,to_T,to_fp)
    fprintf(out_fp,"#rcpt_to,%s\n",w_to->str->c_str());
  LOOP_END

  date_rtn();
  fprintf(out_fp,"#wr,From:\"%s\"<%s>\n",base64->encode(from_name->c_str()),from_addr->c_str());

  first = true;
  MEM_LOOP(w_to,to_T,to_fp)
    if (w_to->kbn != 0){continue;}
    if (first){fprintf(out_fp,"#wr,To:%s",w_to->str->c_str());}
    else      {fprintf(out_fp,";%s",w_to->str->c_str());}
    first = false;
  LOOP_END
  if (first == false){fprintf(out_fp,"\n");}
  first = true;
  MEM_LOOP(w_to,to_T,to_fp)
    if (w_to->kbn != 1){continue;}
    if (first){fprintf(out_fp,"#wr,Cc:%s",w_to->str->c_str());}
    else      {fprintf(out_fp,";%s",w_to->str->c_str());}
    first = false;
  LOOP_END
  if (first == false){fprintf(out_fp,"\n");}
  first = true;
  MEM_LOOP(w_to,to_T,to_fp)
    if (w_to->kbn != 2){continue;}
    if (first){fprintf(out_fp,"#wr,Bcc:%s",w_to->str->c_str());}
    else      {fprintf(out_fp,";%s",w_to->str->c_str());}
    first = false;
  LOOP_END
  if (first == false){fprintf(out_fp,"\n");}
  fprintf(out_fp,"#wr,Subject:%s\n",base64->encode(subject->c_str()));

  // Ver 0.92 header add
  MEM_LOOP(sstr,sChar,head_fp)
    fprintf(out_fp,"#wr,%s\n",sstr->c_str());
  LOOP_END

  if (attachFlg)
    {
    fprintf(out_fp,"#wr,Content-Type:multipart/mixed;boundary=\"%s\"\n",boundary->c_str());
    fprintf(out_fp,"#wr,\n");
    fprintf(out_fp,"#wr,--%s\n",boundary->c_str());
    }

  fprintf(out_fp,"#wr,Content-Type: text/plain; charset=\"ISO-2022-JP\"\n");
  fprintf(out_fp,"#wr,Content-Transfer-Encoding: 7bit\n");

  fprintf(out_fp,"#wr,\n");
  MEM_LOOP(sstr,sChar,wr_fp)
    fprintf(out_fp,"#wr,%s\n",iso_body->encord(sstr->c_str()));
  LOOP_END

  MEM_LOOP(sstr,sChar,file_fp)
    attach_rtn(sstr->c_str());
  LOOP_END

  if (attachFlg)
    {
    fprintf(out_fp,"#wr,--%s--\n",boundary->c_str());
    }

  }

encodeInf_T::~encodeInf_T(){
  to_T *w_to;
  sChar *str;

  if (csvi != NULL){delete csvi;}
  if (out_fp != NULL){fclose(out_fp);}
  delete base64;
  delete iso_body;

  MEM_LOOP(w_to,to_T,to_fp) delete w_to; LOOP_END
  MEM_LOOP(str,sChar,wr_fp) delete str; LOOP_END
  MEM_LOOP(str,sChar,file_fp) delete str; LOOP_END
  MEM_LOOP(str,sChar,head_fp) delete str; LOOP_END  // Ve 0.92

  delete to_fp;
  delete wr_fp;
  delete head_fp; // Ver 0.92
  delete file_fp;
  delete from_addr;
  delete from_name;
  delete timeout;
  delete subject;
  delete it;
  delete boundary;
  }


// ---------------
// #from
// ---------------
void encodeInf_T::from_rtn()
  {
  int i;
  char *str;
  int cnt;

  cnt = 0;
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    if (cnt == 0){from_addr->set(str); cnt++; continue;}
    from_name->set(str);
    break;
    }
  }

// ---------------
// #timeout
// ---------------
void encodeInf_T::timeout_rtn()
  {
  int i;
  char *str;

  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    timeout->set(str);
    break;
    }
  }

// ---------------
// #subject
// ---------------
void encodeInf_T::subject_rtn()
  {
  int i;
  char *str;
  
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    subject->set(str);
    break;
    }
  }

// ---------------
// #wr
// ---------------
void encodeInf_T::wr_rtn()
  {
  int i;
  char *str;
  sChar *sstr;

  sstr = new sChar("");
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    sstr->cat(str);
    }
  it->alloc_ptr = (MM_PTR_T *)sstr;
  wr_fp->mem_alloc();
  }

// ---------------
// #attach
// ---------------
void encodeInf_T::file_rtn()
  {
  int i;
  char *str;
  sChar *sstr;
  
  sstr = new sChar("");
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    sstr->cat(str);
    }
  it->alloc_ptr = (MM_PTR_T *)sstr;
  file_fp->mem_alloc();
  attachFlg = true;
  }


// ---------------
// #head Ver 0.92
// ---------------
void encodeInf_T::head_rtn()
  {
  int i;
  char *str;
  sChar *sstr;

  sstr = new sChar("");
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    sstr->cat(str);
    }
  it->alloc_ptr = sstr;
  head_fp->mem_alloc();
  }

// ---------------
// #to/#cc/#bcc
// ---------------
void encodeInf_T::to_rtn(int no)
  {
  int i;
  char *str;
  sChar *sstr;

  sstr = new sChar("");
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    sstr->cat(str);
    }
  it->alloc_ptr = (MM_PTR_T *)new to_T(sstr->c_str(),no);
  to_fp->mem_alloc();
  delete sstr;
  }

// ---------------
// attach rtn
// ---------------
void encodeInf_T::attach_rtn(char *file)
  {
  FileNameSep_T *sep;
  sChar *name;

  sep = new  FileNameSep_T;
  sep->Set(file);
  fprintf(out_fp,"#wr,--%s\n",boundary->c_str());
  fprintf(out_fp,"#wr,Content-Disposition:attachment;\n");
  name = new sChar(sep->FileGet());

  if (sep->ExtGet() != 0x00)
    {
    name->cat(".");
    name->cat(sep->ExtGet());
    }

  JisInf_T jis;
  int i;
  jis.flag = false;
  int len = strlen(name->c_str());
  unsigned char *w_buff = name->c_str();
  bool jisFlg = false;

  for(i=0;i<len-1;++i)
    {
    if (jis.SJisCheck((char *)w_buff++)){jisFlg = true; break;}
    }
  jis.flag = false;
  if (jisFlg)
    {
    w_buff = name->c_str();
    fprintf(out_fp,"#wr, filename*0*=ISO-2022-JP''");
    jisFlg = false;
    for(;;)
      {
      if (*w_buff == 0x00){break;}
      if (jis.SJisCheck((char *)w_buff))
        {
        if (jisFlg == false)
          {
          fprintf(out_fp,"%1B%24B");
          jisFlg = true;
          }
        sjis_jis(*w_buff,*(w_buff+1));
        w_buff += 2;
        if ((g_c1 >= '0') && (g_c1 <= '9')
         || (g_c1 >= 'A') && (g_c1 <= 'Z')
         || (g_c1 >= 'a') && (g_c1 <= 'z'))
          {
          fprintf(out_fp,"%c",g_c1);
          }
        else
          {
          fprintf(out_fp,"%%%02X",g_c1);
          }
        if ((g_c2 >= '0') && (g_c2 <= '9')
         || (g_c2 >= 'A') && (g_c2 <= 'Z')
         || (g_c2 >= 'a') && (g_c2 <= 'z'))
          {
          fprintf(out_fp,"%c",g_c2);
          }
        else
          {
          fprintf(out_fp,"%%%02X",g_c2);
          }
        }
      else
        {
        if (jisFlg == true)
          {
          fprintf(out_fp,"%1B%28B");
          jisFlg = false;
          }

        g_c1 = *w_buff++;
        if ((g_c1 >= '0') && (g_c1 <= '9')
         || (g_c1 >= 'A') && (g_c1 <= 'Z')
         || (g_c1 >= 'a') && (g_c1 <= 'z'))
          {
          fprintf(out_fp,"%c",g_c1);
          }
        else
          {
          fprintf(out_fp,"%%%02X",g_c1);
          }
        }
      }
    fprintf(out_fp,"\n");
    }
  else
    {
    fprintf(out_fp,"#wr, filename=\"%s\"\n",name->c_str());
    }
  fprintf(out_fp,"#wr,Content-Transfer-Encoding: base64\n");
  fprintf(out_fp,"#wr,\n");
  delete sep;
  delete name;

  int handle = open(file,O_RDONLY | O_BINARY);
  if (handle == -1)
    {
    printf("attach file open error.(file=%s)\n",file);
    fprintf(out_fp,"#wr,%s\n",base64->sjis_base64_attach("attach error.  ",15));
    return;
    }


  int   max  = lseek(handle,0,SEEK_END);
  char *buff = new char[max+1];
  lseek(handle,0,SEEK_SET);
  read(handle, buff, max);
  char *buff2 = base64->sjis_base64_attach(buff,max);
  int k = 0;
  for(;;)
    {
    char c = *buff2++;
    if (c == 0x00){break;}
    if (k==0){fprintf(out_fp,"#wr,");}
    fprintf(out_fp,"%c",c);
    if (k++ == 75){fprintf(out_fp,"\n"); k=0;}
    }
  fprintf(out_fp,"\n");
  //fprintf(out_fp,"#wr,\n");
  delete [] buff;
  close(handle);
  }

// ---------------
// date rtn
// ---------------
void encodeInf_T::date_rtn()
  {
  TDateTime t;
  unsigned short year,month,day;
  unsigned short hour,min,sec,msec;

  t = Date();
  t.DecodeDate(&year,&month,&day);
  t = Time();  
  t.DecodeTime(&hour,&min,&sec,&msec);
  fprintf(out_fp,"#wr,Date:");

  int week = t.DayOfWeek();
  if (week == 1){fprintf(out_fp,"Sun,");}
  if (week == 2){fprintf(out_fp,"Mon,");}
  if (week == 3){fprintf(out_fp,"Tue,");}
  if (week == 4){fprintf(out_fp,"Wed,");}
  if (week == 5){fprintf(out_fp,"Thu,");}
  if (week == 6){fprintf(out_fp,"Fri,");}
  if (week == 7){fprintf(out_fp,"Sat,");}
  fprintf(out_fp,"%d ",day);
  if (month == 1 ){fprintf(out_fp,"Jan ");}
  if (month == 2 ){fprintf(out_fp,"Feb ");}
  if (month == 3 ){fprintf(out_fp,"Mar ");}
  if (month == 4 ){fprintf(out_fp,"Apr ");}
  if (month == 5 ){fprintf(out_fp,"May ");}
  if (month == 6 ){fprintf(out_fp,"Jun ");}
  if (month == 7 ){fprintf(out_fp,"Jul ");}
  if (month == 8 ){fprintf(out_fp,"Aug ");}
  if (month == 9 ){fprintf(out_fp,"Sep ");}
  if (month == 10){fprintf(out_fp,"Oct ");}
  if (month == 11){fprintf(out_fp,"Nov ");}
  if (month == 12){fprintf(out_fp,"Dec ");}

  fprintf(out_fp,"%d ",year);
  fprintf(out_fp,"%02d:%02d:%02d +0900\n",hour,min,sec);  
  }


// ----------
// sjis->jis
// ----------
void encodeInf_T::sjis_jis(unsigned char p_c1,unsigned p_c2)
  {
  g_c1 = p_c1;
  g_c2 = p_c2;
  if (g_c1 >=0xe0){g_c1 =g_c1 -0x40;}
  if (g_c2 >=0x80){g_c2 =g_c2 -1;}
  if (g_c2 >=0x9e)
    {
    g_c1 =(g_c1 -0x70)*2;
    g_c2 =g_c2 -0x7d;
    }
  else
    {
    g_c1 =((g_c1 -0x70)*2)-1;
    g_c2 =g_c2 -0x1f;
    }

  //printf("%02x %02x(%c%c) -> %02x %02x (%c %c)\n",p_c1,p_c2,p_c1,p_c2,g_c1,g_c2,g_c1,g_c2);
  }
