/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
//
// HTML-File -> CSV-File 
//

// interface class -----------------
class Inf_T{
  public:
  xFgets_T *xfget;
  FILE *out_fp;
  FILE *in_fp;
  char *buff;
  int   ptr;
  int   buff_len;
  int   index;
  char *string;
  int   alloc_len;
  sChar *sv_key;
  bool   read_flg;

  Inf_T() {
    xfget  = new xFgets_T(1024);
    out_fp = NULL;
    in_fp  = NULL;
    ptr    = 0;
    buff_len = 0;
    string = NULL;
    index  = 0;
    alloc_len = 0;
    sv_key = new sChar("");
    read_flg = false;
    }

  ~Inf_T(){
    delete xfget;
    delete sv_key;
    if (in_fp  != NULL){fclose(in_fp );}
    if (out_fp != NULL){fclose(out_fp);}
    if (string != NULL){delete [] string;}
    }
  void Conv(char *in_file,char *out_file);
  void str_init();
  void str_cat(char c);
  void str_out();
  void tag_out();
  void output(char *str);
  void tag_output(char *str0,char *str1,char *str2);
};

// ---------------
// Convert
// ---------------
void Inf_T::Conv(char *in_file,char *out_file)
  {
  int mode;
  char c;
  bool chk;
  int i;
  int sv_mode;
  bool w_flg;

  in_fp  = fopen(in_file,"rt");
  out_fp = fopen(out_file,"wt");
  if ((in_fp == NULL) || (out_fp == NULL))
    {
    if (in_fp  != NULL){printf("open error.(file=%s)\n",in_file ); fclose(in_fp );}
    if (out_fp != NULL){printf("open error.(file=%s)\n",out_file); fclose(out_fp);}
    in_fp = NULL;
    out_fp = NULL;
    return;
    }

  printf("conver %s->%s\n",in_file,out_file);
  mode = 0;
  str_init();
  for(;;)
    {
    if (buff_len == ptr)
      {
      buff = xfget->xFgets(in_fp);
      if (buff == NULL){break;}
      ptr  = 0;
      buff_len = strlen(buff);
      if (buff_len == 0){continue;}
      }

    c = *(buff+ptr);
    ++ptr;

    if (mode == 2)
      {
      fprintf(out_fp,"#cmd,");
      if (*(buff+buff_len-1) == 0x0a){*(buff+buff_len-1) = 0x00;}
      output(buff);
      fprintf(out_fp,"\n");

      for(i=0;i<buff_len;++i){if (mem_cmp(buff+i,"-->",3) == 0){mode = 0; break;}}
      ptr = buff_len;
      continue;
      }

    if (c == '"')
      {
      if (mode == 3){mode = sv_mode;}
      else          {sv_mode = mode; mode = 3;}
      str_cat(c);
      continue;
      }

    if (mode == 3)
      {
      str_cat(c);
      continue;
      }

    if ((mode == 0) && (c == '<'))
      {
      mode = 1;
      str_out();
      str_init();
      if (mem_cmp(buff+ptr,"!-",2) == 0)
        {
        if (*(buff+buff_len-1) == 0x0a){*(buff+buff_len-1) = 0x00;}
        fprintf(out_fp,"#cmd,<");
        output(buff+ptr);
        fprintf(out_fp,"\n");
        w_flg = false;
        for(i=0;i<(int)strlen(buff+ptr+3);++i)
          {
          if (mem_cmp(buff+i+ptr+3,"-->",3) == 0){w_flg = true; break;}
          }
        if (w_flg == false){mode = 2;}
        else               {mode = 0;}
        ptr = buff_len;
        }
      if (mode == 1){read_flg = true;}  
      continue;
      }

    if ((mode == 1) && (c == '>'))
      {
      mode = 0;
      tag_out();
      str_init();
      continue;
      }
    str_cat(c);
    }

  fclose(in_fp);
  fclose(out_fp);
  in_fp = NULL;
  out_fp = NULL;
  printf("complete.\n");
  }


// ---------------
// String Init
// ---------------
void Inf_T::str_init()
  {
  index = 0;
  alloc_len = 512;
  if (string != NULL){delete [] string;}
  string = new char[alloc_len+1];
  *string = 0x00;
  }

// ---------------
// String Cat
// ---------------
void Inf_T::str_cat(char c)
  {
  char *sv;
  if (index >= alloc_len)
    {
    sv = new char[index+1];
    strcpy(sv,string);
    delete [] string;
    alloc_len = alloc_len * 2;
    string = new char[alloc_len+1];
    strcpy(string,sv);
    delete [] sv;
    }
  *(string+index) = c;
  ++index;
  *(string+index) = 0x00;
  }

// ---------------
// String Out
// ---------------
void Inf_T::str_out()
  {
  StrSrchInf_T *ssc;
  int i;
  sChar *s;

  if (*string == 0x00){return;}
  ssc = new StrSrchInf_T;
  ssc->Set(0x0a);
  ssc->Main(string);
  for(i=0;i<ssc->GetSu();++i)
    {
    s = ssc->Get(i);
    fprintf(out_fp,"#wr,");
//    sp_push(s->c_str());
//    sp_push2(s->c_str());
    output(s->c_str());
    fprintf(out_fp,"\n");
    }
  delete ssc;
  }

// ---------------
// Tag Out
// ---------------
void Inf_T::tag_out()
  {
  int i;
  int k;
  int mode;
  char *key;
  char *val;
  bool  wr_rq;
  int   sv_mode;

  char *w;
  JisInf_T *jis;
  jis = new  JisInf_T;
  for(w=string;;w++)
    {
    if (*w == 0x00){break;}
    if (jis->SJisCheck(w)){continue;}
    if (*w <  ' ' ){*w=' ';}
    }
  
  delete jis;

  mode = 0;
  key  = NULL;
  val  = NULL;
  wr_rq = true;
  for(i=0;i<index;++i)
    {
    if (*(string+i) == '"')
      {
      if (mode == 99){mode = sv_mode;}
      else           {sv_mode = mode; mode = 99;}
      continue;
      }
    if (mode == 99){continue;}

    if (mode == 0)
      {
      if (*(string+i) == ' ')
        {
        *(string+i) = 0x00;
        mode = 1;
        for(k=i;k<index;++k)
          {
          key = string+k+1;
          i = k;
          if (*key != ' '){break;}
          }
        if (i == index -1){key = NULL;}
        }
      continue;
      }

    if (mode == 1)
      {
      if (*(string+i) == ' ')
        {
        *(string+i) = 0x00;
        tag_output(string,key,NULL);
        for(k=i;k<index;++k)
          {
          key = string+k+1;
          i = k;
          if (*key != ' '){break;}
          }
        if (i == index -1){key = NULL;}
        }
      if (*(string+i) == '=')
        {
        *(string+i) = 0x00;
        mode = 2;
        for(k=i;k<index;++k)
          {
          val = string+k+1;
          i = k;
          if (*val != ' '){break;}
          }
        if (i == index -1){val = NULL;}
        }
      continue;
      }
    if (mode == 2)
      {
      if (*(string+i) == ' ')
        {
        *(string+i) = 0x00;
        tag_output(string,key,val);
        for(k=i;k<index;++k)
          {
          key = string+k+1;
          i = k;
          if (*key != ' '){break;}
          }
        if (i == index -1){key = NULL;}
        val = NULL;
        mode = 1;
        }
      continue;
      }
    }

  if (wr_rq == true){tag_output(string,key,val);}
  }

// --------------
// output
// --------------
void Inf_T::tag_output(char *str0,char *str1,char *str2)
  {
  char *w;

  JisInf_T *jis;
  jis = new  JisInf_T;
  if (str0 != NULL)
    {
    for(w=str0;;w++)
      {
      if (*w == 0x00){break;}
      if (jis->SJisCheck(w)){continue;}
      if (*w <  ' ' ){*w=' ';}
      }
    sp_push(str0);
    sp_push2(str0);
    }
  delete jis;
  jis = new  JisInf_T;
  if (str1 != NULL)
    {
    for(w=str1;;w++)
      {
      if (*w == 0x00){break;}
      if (jis->SJisCheck(w)){continue;}
      if (*w <  ' ' ){*w=' ';}
      }
    sp_push(str1);
    sp_push2(str1);
    }
  delete jis;
  jis = new  JisInf_T;
  if (str2 != NULL)
    {
    for(w=str2;;w++)
      {
      if (*w == 0x00){break;}
      if (jis->SJisCheck(w)){continue;}
      if (*w <  ' ' ){*w=' ';}
      }
    sp_push(str2);
    sp_push2(str2);
    }
  delete jis;

  if (read_flg == true)
    {
    if (str0 != NULL)
      {
      if (strcmp(sv_key->c_str(),str0) == 0)
        {
        fprintf(out_fp,"#tagchg\n");
        }
      sv_key->set(str0);
      }
    else
      {
      sv_key->set("");
      }
    }
  read_flg = false;
  if ((str1 == NULL) && (str2 == NULL)) {fprintf(out_fp,"#tag,%s\n"      ,str0);}
  if ((str1 != NULL) && (str2 == NULL)) {fprintf(out_fp,"#tag,%s,%s\n"   ,str0,str1);}
  if ((str1 != NULL) && (str2 != NULL)) {fprintf(out_fp,"#tag,%s,%s,%s\n",str0,str1,str2);}
  }

// --------------
// output
// --------------
void Inf_T::output(char *str)
  {
  char buff[4096];
  char buff2[4096];
  int i;
  int ptr;
  char *r_str;
  int kanma;

// sp_push(str); sp_push2(str);
  kanma = 0;
  ptr=0; buff[0] = 0x00;

  if (*str == 0x0d)
    {
    if (*(str+1) == 0x0a)
      {
      str = str + 2;
      }
    }

  for(i=0;i<(int)strlen(str);++i)
    {
    if (*(str+i) == ','){kanma = 1;}
    buff[ptr]   = *(str+i); ++ptr;
    if (*(str+i) == '"')
      {
      buff[ptr]   = *(str+i); ++ptr;
      kanma = 1;
      }
    buff[ptr]   = 0x00;
    }
  if (kanma == 1)
    {
    sprintf(buff2,"\"%s\"",buff);
    st_ini(r_str,buff2);
    }
  else
    {
    st_ini(r_str,buff);
    }

  fprintf(out_fp,"%s",r_str);
  delete [] r_str;
  }
