/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

//
//  Ping Command
//

typedef struct tagIPINFO{
	u_char Ttl;		// Time To Live
	u_char Tos;		// Type Of Service
	u_char IPFlags;		// IP flags
	u_char OptSize;		// Size of options data
	u_char FAR *Options;	// Options data buffer
}IPINFO, *PIPINFO;

typedef struct tagICMPECHO{
	u_long Source;		// Source address
	u_long Status;		// IP status
	u_long RTTime;		// Round trip time in milliseconds
	u_short DataSize;	// Reply data size
	u_short Reserved;	// Unknown
	void FAR *pData;	// Reply data buffer
	IPINFO	ipInfo;		// Reply options
}ICMPECHO, *PICMPECHO;

// interface class -----------------
class Inf_T
{
public:
  CsvInf_T *csvi;
  FILE     *out_fp;
  bool      errFlg;
  HANDLE    hndlIcmp;
  WSADATA   wsaData;
  int       loop;
  int       wait;

  HANDLE (WINAPI *pIcmpCreateFile )(VOID);
  BOOL   (WINAPI *pIcmpCloseHandle)(HANDLE);
  DWORD  (WINAPI *pIcmpSendEcho   )(HANDLE,DWORD,LPVOID,WORD,PIPINFO,LPVOID,DWORD,DWORD);

Inf_T(){
  int nRet;

  loop = 5;
  wait = 5000;
  errFlg = true;
  hndlIcmp = LoadLibrary("ICMP.DLL");
  if (hndlIcmp == NULL){printf("Can't load icmp.dll\n"); return;}
  printf("load icmp.dll\n");
  pIcmpCreateFile  = (HANDLE (WINAPI *)(void)                                               )GetProcAddress(hndlIcmp,"IcmpCreateFile");
  pIcmpCloseHandle = (BOOL   (WINAPI *)(HANDLE)                                             )GetProcAddress(hndlIcmp,"IcmpCloseHandle");
  pIcmpSendEcho    = (DWORD  (WINAPI *)(HANDLE,DWORD,LPVOID,WORD,PIPINFO,LPVOID,DWORD,DWORD))GetProcAddress(hndlIcmp,"IcmpSendEcho");
  if ((pIcmpCreateFile  == NULL)
   || (pIcmpCloseHandle == NULL)
   || (pIcmpSendEcho    == NULL))
    {
    printf("icmp proc no address\n");
    FreeLibrary(hndlIcmp);
    return;
    }
  nRet = WSAStartup(0x0101, &wsaData );
  if (nRet)
    {
    printf("WSAStartup() error(%d)\n",nRet); 
    WSACleanup();
    FreeLibrary(hndlIcmp);
    return;
    }
  if (0x0101 != wsaData.wVersion)
    {
    printf("WinSock version 1.1 not support\n");
    WSACleanup();
    FreeLibrary(hndlIcmp);
    return;
    }

  errFlg = false;
  }

~Inf_T(){
  if (errFlg == true){return;}
  FreeLibrary(hndlIcmp);
  WSACleanup();
  }

void Main(char *csv_file,char *log_file);
void ping_rtn();
void wait_rtn();
void loop_rtn();
void own_rtn();
};


// ---------------
// Main
// ---------------
void Inf_T::Main(char *csv_file,char *log_file)
  {
  char *str;

  if (errFlg == true){return;}
  out_fp = fopen(log_file,"wt");
  csvi   = new CsvInf_T(csv_file);

  if ((out_fp == NULL) || (csvi->CsvError_Rd() != 0))
    {
    if (out_fp != NULL){fclose(out_fp);}
    else               {printf("open error.(file=%s)\n",log_file);}
    delete csvi;
    return;
    }

  printf("ping process execute %s->%s\n",csv_file,log_file);

  csvi->sp_push_set(true); // Ver 1.01
  for(;;)
    {
    if (csvi->CsvFgets() == -1) {break;}
    if (csvi->CsvSelSu_Rd() == 0) {continue;}
    if ((str = csvi->CsvSel_Rd(0)) == MM_NULL) {continue;}
    if (strcmp(str,"#ping")==0) {ping_rtn  ();}
    if (strcmp(str,"#wait")==0) {wait_rtn  ();}
    if (strcmp(str,"#loop")==0) {loop_rtn  ();}
    if (strcmp(str,"#own" )==0) {own_rtn   ();}
    }

  delete csvi;
  fclose(out_fp);
  }


// ---------------
// my ip get
// ---------------
void Inf_T::own_rtn(){
  getMyAdr_C *as = new getMyAdr_C;
  if (as->okCheck()) {
    fprintf(out_fp,"#my_addr,%s,%s\n",as->hostName(),as->ipAdr());
  }
  else{
    printf("myhost not found\n");
    fprintf(out_fp,"#my_addr,myhost not found\n");
  }

  delete as;
}


// ---------------
// Wait
// ---------------
void Inf_T::wait_rtn()
  {
  char *str;
  int i;
  int w;

  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    w = SujiConvEx(str);
    if (w > 0)
      {
      printf("wait set = %d\n",w);
      wait = w;
      }
    }
  }

// ---------------
// Loop
// ---------------
void Inf_T::loop_rtn()
  {
  char *str;
  int i;
  int w;

  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    w = SujiConvEx(str);
    if (w >= 0)
      {
      printf("loop set = %d\n",w);
      loop = w;
      }
    }
  }


// ---------------
// Ping
// ---------------
void Inf_T::ping_rtn()
  {
  char *hostName;
  ICMPECHO icmpEcho;	 // ICMP Echo reply buffer
  HANDLE hndlFile;	 // Handle for IcmpCreateFile()
  LPHOSTENT pHost;	 // Pointer to host entry structure
  struct in_addr iaDest; // Internet address structure
  DWORD *dwAddress;	 // IP Address
  IPINFO ipInfo;	 // IP Options structure
  DWORD dwRet;		 // DWORD return code
  int x;
  int i;
  int ok;
  char *str;

  hostName = NULL;
  for(i=1;i<csvi->CsvSelSu_Rd();++i)
    {
    if ((str = csvi->CsvSel_Rd(i)) == MM_NULL) {continue;}
    hostName = str;
    }

  if (hostName == NULL){return;}

  // Lookup destination
  iaDest.s_addr = inet_addr(hostName);
  if (iaDest.s_addr == INADDR_NONE){pHost = gethostbyname(hostName);}
  else                             {pHost = gethostbyaddr((const char *)&iaDest,sizeof(struct in_addr), AF_INET);}
  if (pHost == NULL)
    {
    printf("%s not found\n", hostName);
    fprintf(out_fp,"#ping,%s,host not found\n", hostName);
    return;
    }

  // Tell the user what we're doing
  printf("ping %s [%s]\n", pHost->h_name,inet_ntoa((*(LPIN_ADDR)pHost->h_addr_list[0])));
  // Copy the IP address
  dwAddress = (DWORD *)(*pHost->h_addr_list);

  // Get an ICMP echo request handle        
  hndlFile = pIcmpCreateFile();
  for (ok=0,x=0;x<loop;x++)
    {
    // Set some reasonable default values
    ipInfo.Ttl = 255;
    ipInfo.Tos = 0;
    ipInfo.IPFlags = 0;
    ipInfo.OptSize = 0;
    ipInfo.Options = NULL;
    //icmpEcho.ipInfo.Ttl = 256;

    // Reqest an ICMP echo
    dwRet = pIcmpSendEcho(hndlFile,*dwAddress,NULL,0,&ipInfo,&icmpEcho,sizeof(struct tagICMPECHO),wait);

    // Print the results
    iaDest.s_addr = icmpEcho.Source;
    printf("reply from %s [Time:%ldms]  [TTL:%d]",inet_ntoa(iaDest),icmpEcho.RTTime,icmpEcho.ipInfo.Ttl);
    if (icmpEcho.Status){printf(" => error.[status:%ld]\n",icmpEcho.Status);}
    else                {printf(" => ok.\n"); ++ok;}
    }
  fprintf(out_fp,"#ping,%s,%s,%d,%d,%d",pHost->h_name,inet_ntoa((*(LPIN_ADDR)pHost->h_addr_list[0])),ok,loop,wait);
  if (ok == loop){fprintf(out_fp,",ok\n");}
  else
    {
    if (ok == 0){fprintf(out_fp,",ng\n");}
    else        {fprintf(out_fp,",ok/ng\n");}
    }
  pIcmpCloseHandle(hndlFile);
  }


