/*

 * Copyright (c) 2003 Shigeru Kasuya (sky_seeker99@users.sourceforge.jp)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
//
//  CSV File Plot
//


// # TextCtlInf #####
CsvFilePlot_C::CsvFilePlot_C(){
  it        = new MemHeader_T;
  plot_fp   = new MEM_FP(it);
  max_x     = 0;
  max_y     = 0;
  header    = new sChar("");
}

CsvFilePlot_C::~CsvFilePlot_C(){
  MEM_LOOP(pc,PlotData_C,plot_fp) delete pc; LOOP_END
  delete plot_fp;
  delete it;
  delete header;
}



// # main #####
void CsvFilePlot_C::Main(Read64_C *in_fp,Write64_C *out_fp,char *key){
  CsvAnl_C *csvi = new CsvAnl_C;
  for(;;){
	unsigned char *buff = in_fp->read();
	if (buff == NULL) {break;}
	csvi->Exec(buff);

    CSV_LOOP(csvi,ustr,SP_PUSH)
      char *str = (char *)ustr;
      if (strcmp(str,"#header"     ) == 0){header_rtn    (csvi    );}
      if (strcmp(str,"#data"       ) == 0){data_rtn      (csvi,key);}
      if (strcmp(str,"#plot_write" ) == 0){plot_write_rtn(out_fp,key);}
    LOOP_END
  }
  delete csvi;
}


// # header #####
void CsvFilePlot_C::header_rtn(CsvAnl_C *csvi){
  header->set("");

  CSV_LOOP(csvi,ustr,NON_SP_PUSH)
    char *str = (char *)ustr;
    header->cat(str);
  LOOP_END
}


// generate key #####
char *CsvFilePlot_C::gen_key_rtn(int x,int y){
  sprintf(gen_key,"%d_%d",x,y);
  return(gen_key);
}

// # data #####
void CsvFilePlot_C::data_rtn(CsvAnl_C *csvi,char *key)
  {
  char *str;
  char *w_x=NULL;
  char *w_y=NULL;
  bool keyFlg = false;
  char *w_key=NULL;
  
  CSV_LOOP(csvi,ustr,SP_PUSH)
    char *str = (char *)ustr;
    if (w_x == NULL){w_x = str; continue;}
    if (w_y == NULL){w_y = str; continue;}
    if (keyFlg == false){
      if (strcmp(str,key) == 0){keyFlg = true;}
      continue;
    } 
    w_key = str;
    break;
  LOOP_END

  if (w_key == NULL){return;}
  int x = SujiConvEx(w_x);
  int y = SujiConvEx(w_y);
  if ((x < 0) || (y < 0)){return;}
  it->srch_key = gen_key_rtn(x,y);
  if (plot_fp->mem_srch() == 0){
    pc = (PlotData_C *)plot_fp->mem_link_ptr_rd();
    delete pc;
    plot_fp->mem_del(); // Ver 1.03
  }
  pc = new PlotData_C(it->srch_key,w_key);
  it->alloc_ptr = (MM_PTR_T *)pc;
  plot_fp->mem_srch_alloc();
  if (max_x < x){max_x = x;}
  if (max_y < y){max_y = y;}
}

// # plot_write #####
void CsvFilePlot_C::plot_write_rtn(Write64_C *out_fp,char *key){
  sprintf(out_fp->buff,"#header,%s\n"     ,header->c_str()); out_fp->write();
  sprintf(out_fp->buff,"#key,%s\n"        ,key            ); out_fp->write();
  sprintf(out_fp->buff,"#size_x_y,%d,%d\n",max_x+1,max_y+1); out_fp->write();
  header->set("");

  out_fp->write("//,,");
  for(int x=0;x<=max_x;x++){
    sprintf(out_fp->buff,",%d",x);
    out_fp->write();
  }
  out_fp->writeln("");
  out_fp->write("//,,");
  for(int x=0;x<=max_x;x++){
    sprintf(out_fp->buff,",",x);
    out_fp->write();
  }
  out_fp->writeln("");

  for(int y=0;y<=max_y;y++){
    sprintf(out_fp->buff,"#data,%d,",y);
    out_fp->write();
    for(int x=0;x<=max_x;x++){
      out_fp->write(",");
      it->srch_key = gen_key_rtn(x,y);
      if (plot_fp->mem_srch() == 0){
        pc = (PlotData_C *)plot_fp->mem_link_ptr_rd();
        out_fp->write(pc->data->c_str());
      }
    }
    out_fp->writeln("");
  }
  max_x = 0;
  max_y = 0;
  out_fp->writeln("");

  MEM_LOOP(pc,PlotData_C,plot_fp) delete pc; LOOP_END
  plot_fp->mem_del_all();
}


