// ---------------------
// aaa module
// ---------------------
module aaa(
   i0
  ,i1
  ,o0
  ,o1
);
// # port define ########################
// # input  ########
  input   i0;
  input   i1;
// # output ########
  output  o0;
  output  o1;

// # wire define ############################
  wire  a;  // _CELL:[B18]
  wire  b;  // _CELL:[B19]
  wire  [31:0] hnet0;  // _CELL:[B13]
  wire  [7:0] irq;  // _CELL:[B14]
  wire  [31:0] on;  // _CELL:[B21]
  wire  zrst;  // _CELL:[B12]


// # m_aa(i_abc) ###############
  m_aa i_abc(  // _CELL:
     .in_ctl({a,b})  // _CELL:[D20]
    ,.irq(irq[3:0])  // _CELL:[D15]
    ,.rst(zrst)  // _CELL:[D12]
    ,.sad(hnet0)  // _CELL:[D13]
  );

// # m_aa(i_eee) ###############
  m_aa i_eee(  // _CELL:
     .irq(irq[7:4])  // _CELL:[E16]
    ,.mod(1'b0)  // _CELL:[E17]
    ,.out1(a)  // _CELL:[E18]
    ,.rst(zrst)  // _CELL:[E12]
    ,.sad(hnet0)  // _CELL:[E13]
  );

// # m_bb(i_fff) ###############
  m_bb i_fff(  // _CELL:
     .irqo(irq)  // _CELL:[F14]
    ,.mod(1'b0)  // _CELL:[F17]
    ,.out2(b)  // _CELL:[F19]
    ,.rst(zrst)  // _CELL:[F12]
  );

endmodule

