// ---------------------
// bbb module
// ---------------------
module bbb(
   i0
  ,i1
  ,o0
  ,o1
);
// # port define ########################
// # input  ########
// # output ########

// # wire define ############################
  wire  a;  // _CELL:[B14]
  wire  b;  // _CELL:[B15]
  wire  [31:0] hnet0;  // _CELL:[B9]
  wire  [7:0] irq;  // _CELL:[B10]
  wire  [31:0] on;  // _CELL:[B17]
  wire  zrst;  // _CELL:[B8]

// # m_aa(i_abc) ###############
  m_aa i_abc(  // _CELL:
     .in_ctl({a,b})  // _CELL:[D16]
    ,.irq(irq[3:0])  // _CELL:[D11]
    ,.rst(zrst)  // _CELL:[D8]
    ,.sad(hnet0)  // _CELL:[D9]
  );

// # m_aa(i_eee) ###############
  m_aa i_eee(  // _CELL:
     .irq(irq[7:4])  // _CELL:[E12]
    ,.mod(1'b0)  // _CELL:[E13]
    ,.out1(a)  // _CELL:[E14]
    ,.rst(zrst)  // _CELL:[E8]
    ,.sad(hnet0)  // _CELL:[E9]
  );

// # m_bb(i_fff) ###############
  m_bb i_fff(  // _CELL:
     .irqo(irq)  // _CELL:[F10]
    ,.mod(1'b0)  // _CELL:[F13]
    ,.out2(b)  // _CELL:[F15]
    ,.rst(zrst)  // _CELL:[F8]
  );

endmodule

