﻿CubePDF Utility
====

Copyright (c) 2013 CubeSoft Inc.

support@cube-soft.jp  
https://www.cube-soft.jp/

## はじめに

CubPDF Utility は、既存の PDF ファイルのページ挿入や削除、文書プロパティ、
各種セキュリティ機能などの設定を変更するためのソフトウェアです。

CubePDF Utility を使用するためには、Microsoft .NET Framework 3.5 以降が
インストールされている必要があります（4.5.2 以降を推奨）。
.NET Framework は、以下のURL からダウンロードして下さい。

* Microsoft .NET Framework 4.5.2  
  https://www.microsoft.com/ja-JP/download/details.aspx?id=42643
* Microsoft .NET Framework 3.5  
  https://www.microsoft.com/ja-jp/download/details.aspx?id=22

## 利用方法

まず、ファイルを開くボタンやドラッグ&ドラップを通じて、編集したい PDF ファイルを開きます。
この際、選択した PDF ファイルに対して既にセキュリティ機能が設定されている場合、
管理用パスワードを入力するためのダイアログボックスが表示されますので、正しいパスワードを入力して下さい。
その後、メイン画面上で PDF ファイルに対して必要な編集を行い、「上書き保存」または「名前を付けて保存」
ボタンを押すと、編集の適用された PDF ファイルが作成されます。

CubePDF Utility で編集可能なものは以下の通りです。

1. ページ編集
    - 挿入 ... 選択位置/ページ先頭/ページ末尾のいずれかに PDF, PNG, JPEG, BMP ファイルを挿入します
    - 削除 ... 選択したページ、またはページ番号を指定して該当ページを削除します
    - 抽出 ... 選択したページ群を別の PDF ファイルとして保存します
    - 順序 ... PDF ファイルのページ順序を変更（移動）します
    - 回転 ... 選択したページを回転します
2. 文書プロパティ
    - タイトル
    - 作成者
    - サブタイトル
    - キーワード
    - ページレイアウト
    - アプリケーション
3. セキュリティ
    - パスワード（管理用パスワード）
    - PDF ファイルを開く際のパスワード（閲覧用パスワード）
    - 印刷を許可する
    - テキストや画像のコピーを許可する
    - ページの挿入、回転、削除を許可する
    - アクセシビリティのための内容の抽出を許可する
    - フォームへの入力を許可する
    - 注釈の追加・編集操作を許可する

### バックアップ機能

CubePDF Utility では、以下のフォルダに過去 30 日間のバックアップを作成するようにしています。
もし、何らかの不都合により PDF ファイルを消失した場合は、バックアップも検索して下さい。

C:\ユーザー\<ユーザー名>\AppData\Local\CubeSoft\CubePdfUtility2\<日付>  
※ <ユーザー名> は、ログインしているユーザ名に置換して下さい。  
※ <日付> は、該当ファイルを編集した日付に置換して下さい。

## 利用ライブラリ

CubePDF Utility は、以下のライブラリを利用しています。
それぞれのライブラリについては、記載した URL から取得することができます。

* iTextSharp
    - GNU Affero General Public License
    - https://itextpdf.com/
    - https://www.nuget.org/packages/iTextSharp/
* PDFium
    - 3-clause BSD License
    - https://pdfium.googlesource.com/pdfium/
    - https://www.nuget.org/packages/PdfiumViewer.Native.x86.no_v8-no_xfa/
    - https://www.nuget.org/packages/PdfiumViewer.Native.x86_64.no_v8-no_xfa/
* log4net
    - Apache License, Version 2.0
    - http://logging.apache.org/log4net/
    - https://www.nuget.org/packages/log4net/
* MVVM Light Toolkit
    - MIT License
    - http://www.galasoft.ch/mvvm
    - https://www.nuget.org/packages/MvvmLight/
* AsyncBridge (.NET Framework 3.5 のみ)
    - MIT License
    - http://omermor.github.io/AsyncBridge/
    - https://www.nuget.org/packages/AsyncBridge.Net35

## バージョン履歴

* 2018/10/25 version 0.5.1β
    - 異なるプロセス（ウィンドウ）間でのドラッグ&ドロップによるページ移動に再対応
    - 詳細を設定して挿入機能に再対応
    - 挿入可能なファイル形式として PNG, JPEG, BMP に再対応
    - ウィンドウサイズの保持機能に再対応
    - スクロールバーのクリック時に選択状況が解除される不都合を修正
    - PDF を開く時に閲覧用パスワードを要求されない、保護された PDF ファイルを修正できない不都合を修正。
* 2018/09/26 version 0.5.0β
    - 内部処理を全面的に修正
    - 描画ライブラリとして PDFium を利用するように変更
    - メイン画面の表示言語を選択する機能を追加
* 2016/02/19 version 0.4.1β
    - 「閉じる」実行後のメモリ消費量を改善
    - 複数のページを選択して「ページを抽出して個別のファイルに保存」を実行する時に発生する不都合を修正
    - 保存時にブックマークの位置がずれる不都合を修正
    - 回転操作を実行後に 2 回以上保存した場合、回転操作が反映されない不都合を修正
    - 画像抽出時に透過情報が失われる不都合を修正
* 2016/01/20 version 0.4.0β
    - CubePDF ImagePicker より画像の抽出機能を移植
    - CubePDF Page より画像の挿入機能を移植
    - 一部の環境でパスワード保護されたファイルの上書きに失敗する不都合を修正
    - 挿入時はオーナパスワードのみを許容するように修正
    - パスワード保護時に表示される鍵マークをクリックするとパスワード入力画面を表示するように修正
    - ボタン配置を変更
* 2015/10/16 version 0.3.4β
    - ファイル名に特定の文字が含まれている場合、ファイルを開く処理に失敗する不都合を修正
    - ファイルの保存処理に失敗した時にファイルが消失しないように修正
    - セキュリティ画面において、何らかの操作を制限している状況で閲覧専用のパスワードを省略した場合、エラーメッセージを表示するように修正
    - パスワード保護されているファイルに対して編集を行おうとした時にパスワード入力画面を表示するように修正
* 2014/09/12 version 0.3.3β
    - 挿入時に特定の条件下でページ順序がずれる不都合を修正
    - PDF バージョンを 1.4 以下に設定できない不都合を修正
    -「PDF 閲覧時にパスワードを要求する」のみにチェックを入れた場合、ユーザパスワードが設定されない不都合を修正
    - ユーザパスワードが入力された状態で「閲覧専用のパスワードを設定する」のチェックを外した場合、ユーザパスワードが設定されてしまう不都合を修正
    - 特定の条件下でユーザ設定が正常に読み込まれない不都合を修正
    - プレビュー画面が誤って表示されてしまう不都合を修正
    - 最近使用した項目を最終アクセス時間で降順に表示するように修正
* 2014/03/05 version 0.3.2β
    - 暗号化された PDF ファイルが開けない不都合を修正
    - アクティブ化する画面が最小化されている場合に最小化を解除するように修正
    - ページ回転時にページ番号の表示が消える不都合を修正
    - スクロール時にサムネイルが表示されない不都合を改善
* 2014/02/17 version 0.3.1β
    - 既に画面に何らかの PDF ファイルが開かれている状態で「開く」を実行した場合、新しいウィンドウで開くように修正
    - 指定された PDF ファイルが既に別の画面で開かれている場合、その画面を表示するように修正
    - 文書プロパティにページレイアウトを追加
    - サムネイルの表示サイズを長辺ベースに修正
    - 結合方法をファイルサイズが小さくなるように修正
* 2013/12/18 version 0.3.0β
    - ウィンドウ間のドラッグ&ドロップ操作でページを挿入できるように修正
    - ドラッグ&ドロップによる最後尾への移動/挿入操作を修正
* 2013/11/11 version 0.2.3β
    - 複数ファイルを挿入する機能を追加
    - 既に開いている PDF ファイルを重複して挿入する操作を許容するように修正
    - 表示方法を変更して再描画ボタンを押した時にサムネイルが表示されない不都合を修正
    - ファイルを閉じた段階で垂直スクロールバーの状態をリセットするように修正
* 2013/10/03 version 0.2.2β
    - メモリの使用量をできるだけ抑えるように修正
    - 名前を付けて保存したファイルを最近使用した項目一覧に追加するように修正
* 2013/08/13 version 0.2.1β
    - 何も表示されていない時にナビゲーション画面を表示するように修正
    - CubePDF Utility で編集した PDF のファイルサイズをできるだけ小さく抑えるように修正
    - AES256 で暗号化された PDF ファイルを開くとエラーが表示される不都合を修正
    - パスワードダイアログと同時にエラーメッセージが表示されてしまう不都合を修正
    - PDF ファイルのセキュリティ設定をセキュリティ設定ダイアログに反映するように修正
    - タグ付き PDF（構造化された PDF）ファイルを開いた時に警告を表示するように修正
    - しおりに関して、一部の PDF ファイルで保存時にエラーの表示されていた不都合を修正
    - CubePDF Utility が既に起動している場合、起動時にスプラッシュ画面を表示しないように修正
    - スプラッシュ画面にバージョン情報を表示するように修正
* 2013/08/13 version 0.2.0β
    - ファイルの保存時に注釈やしおり等の付加的な情報が消去される不都合を修正
    - メモリリークが発生していた不都合を修正
    - 画面に表示されている部分（ページ）のサムネイルを優先して描画するように修正
    - 抽出後の PDF ファイルが Ctrl クリックした順番で保存されてしまう不都合を修正
    - 選択状態のサムネイルをダブルクリックした時にプレビュー画面が開かない不都合を修正
    - 既に開いている PDF ファイルを重複して挿入しようとするとエラーメッセージを表示するように修正
* 2013/06/17 version 0.1.2β
    - .NET Framework 4、および 4.5 に対応
    - 上書き保存して終了時、何らかの理由で上書き保存に失敗した場合にメッセージを表示するように修正
* 2013/06/06 version 0.1.1β
    - 起動時にスプラッシュ画面を表示するように修正
    - パソコン起動時、またはアプリケーション起動時にアップデートの確認を行うように修正
    - PDF ファイルをマウス右クリック時に「CubePDF Utility で開く」と言うメニューを追加
    - 特定の環境で、アプリケーション終了時にエラーが発生する不都合を修正
* 2013/05/20 version 0.1.0β
    - 最初の公開バージョン