/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPFaultElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axis2.saaj.NodeImplEx;
import org.apache.axis2.saaj.NodeListImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.TextImplEx;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SOAPElementImpl
extends NodeImplEx
implements SOAPElement {
    protected ElementImpl element;
    private String encodingStyle;

    public SOAPElementImpl(ElementImpl element) {
        super(element.getOMFactory());
        this.element = element;
    }

    public void discard() throws OMException {
        this.element.discard();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.element.internalSerialize(writer);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.element.internalSerializeAndConsume(writer);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if (name.getURI() == null || name.getURI().trim().length() == 0) {
            this.element.setAttribute(name.getLocalName(), value);
        } else {
            this.element.setAttributeNS(name.getURI(), name.getPrefix() + ":" + name.getLocalName(), value);
        }
        return this;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        String prefix = name.getPrefix();
        return this.addChildElement(name.getLocalName(), "".equals(prefix) ? null : prefix, name.getURI());
    }

    public SOAPElement addChildElement(SOAPElement soapElement) throws SOAPException {
        SOAPElementImpl childEle;
        String namespaceURI = soapElement.getNamespaceURI();
        String prefix = soapElement.getPrefix();
        String localName = soapElement.getLocalName();
        if (namespaceURI == null || namespaceURI.trim().length() == 0) {
            childEle = new SOAPElementImpl((ElementImpl)this.getOwnerDocument().createElement(localName));
        } else {
            this.element.declareNamespace(namespaceURI, prefix);
            childEle = new SOAPElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(namespaceURI, localName));
        }
        Iterator iter = soapElement.getAllAttributes();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            childEle.addAttribute(name, soapElement.getAttributeValue(name));
        }
        iter = soapElement.getChildElements();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Text) {
                childEle.addTextNode(((Text)o).getData());
                continue;
            }
            childEle.addChildElement((SOAPElement)o);
        }
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        if (namespaceURI != null && namespaceURI.trim().length() > 0) {
            childEle.element.setNamespace(childEle.element.declareNamespace(namespaceURI, prefix));
        }
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public String getLocalName() {
        return this.element.getLocalName();
    }

    public String getNamespaceURI() {
        return this.element.getNamespaceURI();
    }

    public String getPrefix() {
        return this.element.getPrefix();
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        OMNamespace omNamespace = this.element.declareNamespace(uri, prefix);
        return this.addChildElement(localName, omNamespace.getPrefix());
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Namespace not declared for the give prefix: " + prefix);
        }
        SOAPElementImpl childEle = new SOAPElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(namespaceURI, prefix + ":" + localName));
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(namespaceURI, prefix));
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPElementImpl childEle = new SOAPElementImpl((ElementImpl)this.getOwnerDocument().createElement(localName));
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        this.element.declareNamespace(uri, prefix);
        return this;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        Text textNode = this.getOwnerDocument().createTextNode(text);
        NodeImpl node = (NodeImpl)this.element.appendChild((org.w3c.dom.Node)textNode);
        TextImplEx saajTextNode = new TextImplEx(text, this);
        node.setUserData("saaj.node", (Object)saajTextNode, null);
        return this;
    }

    public Iterator getAllAttributes() {
        Iterator attribIter = this.element.getAllAttributes();
        ArrayList<PrefixedQName> attribName = new ArrayList<PrefixedQName>();
        while (attribIter.hasNext()) {
            Attr attr = (Attr)attribIter.next();
            PrefixedQName qname = attr.getNamespaceURI() == null || attr.getNamespaceURI().trim().length() == 0 ? new PrefixedQName(attr.getNamespaceURI(), attr.getName(), attr.getPrefix()) : new PrefixedQName(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix());
            attribName.add(qname);
        }
        return attribName.iterator();
    }

    public String getAttributeValue(Name name) {
        OMAttribute attribute = this.element.getAttribute(new QName(name.getURI(), name.getLocalName(), name.getPrefix()));
        if (attribute == null) {
            return null;
        }
        return attribute.getAttributeValue();
    }

    public Iterator getChildElements() {
        Iterator childIter = this.element.getChildren();
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            childElements.add(this.toSAAJNode((org.w3c.dom.Node)childIter.next()));
        }
        return childElements.iterator();
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        Iterator childIter = this.element.getChildrenWithName(qName);
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            childElements.add(this.toSAAJNode((org.w3c.dom.Node)childIter.next()));
        }
        return childElements.iterator();
    }

    public Name getElementName() {
        QName qName = this.element.getQName();
        return new PrefixedQName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public Iterator getNamespacePrefixes() {
        ArrayList<String> prefixList = new ArrayList<String>();
        Iterator nsIter = this.element.getAllDeclaredNamespaces();
        while (nsIter.hasNext()) {
            Object o = nsIter.next();
            if (!(o instanceof OMNamespace)) continue;
            OMNamespace ns = (OMNamespace)o;
            prefixList.add(ns.getPrefix());
        }
        return prefixList.iterator();
    }

    public String getNamespaceURI(String prefix) {
        return this.element.getNamespaceURI(prefix);
    }

    public Iterator getVisibleNamespacePrefixes() {
        Iterator namespacesIter = this.element.getAllDeclaredNamespaces();
        ArrayList<String> returnList = new ArrayList<String>();
        while (namespacesIter.hasNext()) {
            OMNamespace ns;
            Object o = namespacesIter.next();
            if (!(o instanceof OMNamespace) || (ns = (OMNamespace)o).getPrefix() == null) continue;
            returnList.add(ns.getPrefix());
        }
        OMContainer parent = this.element.getParent();
        if (parent != null && parent instanceof OMElement) {
            Iterator parentScopeNamespacesIter = ((OMElement)parent).getAllDeclaredNamespaces();
            while (parentScopeNamespacesIter.hasNext()) {
                OMNamespace ns;
                Object o = parentScopeNamespacesIter.next();
                if (!(o instanceof OMNamespace) || (ns = (OMNamespace)o).getPrefix() == null) continue;
                returnList.add(ns.getPrefix());
            }
        }
        return returnList.iterator();
    }

    public SOAPElement addAttribute(QName qname, String value) throws SOAPException {
        if (qname.getNamespaceURI() == null || qname.getNamespaceURI().trim().length() == 0) {
            this.element.setAttribute(qname.getLocalPart(), value);
        } else {
            this.element.setAttributeNS(qname.getNamespaceURI(), qname.getPrefix() + ":" + qname.getLocalPart(), value);
        }
        return this;
    }

    public SOAPElement addChildElement(QName qname) throws SOAPException {
        String prefix = qname.getPrefix();
        return this.addChildElement(qname.getLocalPart(), "".equals(prefix) ? null : prefix, qname.getNamespaceURI());
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        if (this.element.getNamespaceURI(prefix) == null) {
            throw new SOAPException("Invalid prefix");
        }
        QName qname = null;
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            qname = new QName("http://schemas.xmlsoap.org/soap/envelope/", localName, prefix);
        } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
            qname = new QName("http://www.w3.org/2003/05/soap-envelope", localName, prefix);
        }
        return qname;
    }

    public Iterator getAllAttributesAsQNames() {
        Iterator attribIter = this.element.getAllAttributes();
        ArrayList<QName> attributesAsQNames = new ArrayList<QName>();
        while (attribIter.hasNext()) {
            Attr attr = (Attr)attribIter.next();
            QName qname = new QName(attr.getNamespaceURI(), attr.getName(), attr.getPrefix());
            attributesAsQNames.add(qname);
        }
        return attributesAsQNames.iterator();
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attribute = this.element.getAttribute(qname);
        if (attribute == null) {
            return null;
        }
        return attribute.getAttributeValue();
    }

    public Iterator getChildElements(QName qname) {
        Iterator childIter = this.element.getChildrenWithName(qname);
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            childElements.add(this.toSAAJNode((org.w3c.dom.Node)childIter.next()));
        }
        return childElements.iterator();
    }

    public QName getElementQName() {
        return this.element.getQName();
    }

    public boolean removeAttribute(QName qname) {
        OMAttribute attr = this.element.getAttribute(qname);
        if (attr != null) {
            this.element.removeAttribute(attr);
            return true;
        }
        return false;
    }

    public SOAPElement setElementQName(QName newName) throws SOAPException {
        String localName = this.element.getLocalName();
        if ("Body".equals(localName) || "Header".equals(localName) || "Envelope".equals(localName)) {
            throw new SOAPException("changing this element name is not allowed");
        }
        OMNamespaceImpl omNamespace = new OMNamespaceImpl(newName.getNamespaceURI(), newName.getPrefix());
        this.element.setNamespace((OMNamespace)omNamespace);
        this.element.setLocalName(newName.getLocalPart());
        return this;
    }

    public boolean removeAttribute(Name name) {
        OMAttribute attr = this.element.getAttribute(new QName(name.getURI(), name.getLocalName(), name.getPrefix()));
        if (attr != null) {
            this.element.removeAttribute(attr);
            return true;
        }
        return false;
    }

    public void removeContents() {
        Iterator childIter = this.element.getChildElements();
        while (childIter.hasNext()) {
            Object o = childIter.next();
            if (!(o instanceof OMNode)) continue;
            ((OMNode)o).detach();
        }
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        return this.element.removeNamespace(prefix);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            try {
                URI uri = new URI(encodingStyle);
                if (!(this instanceof SOAPEnvelope) && !encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    throw new IllegalArgumentException("Invalid Encoding style : " + encodingStyle);
                }
                this.encodingStyle = encodingStyle;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Encoding style : " + encodingStyle + ":" + e);
            }
        } else if (this.element.getOMFactory() instanceof SOAP12Factory && (this instanceof SOAPHeader || this instanceof SOAPBody || this instanceof SOAPFault || this instanceof SOAPFaultElement || this instanceof SOAPEnvelope || this instanceof Detail)) {
            throw new SOAPException("EncodingStyle attribute cannot appear in : " + (Object)((Object)this));
        }
    }

    public void setParent(OMContainer parentElement) {
        this.element.setParent(parentElement);
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public Attr getAttributeNode(String name) {
        return this.element.getAttributeNode(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.element.getAttributeNodeNS(namespaceURI, localName);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.element.getAttributeNS(namespaceURI, localName);
    }

    public NodeList getElementsByTagName(String name) {
        return this.element.getElementsByTagName(name);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.element.getElementsByTagNameNS(namespaceURI, localName);
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.element.hasAttributeNS(namespaceURI, localName);
    }

    public void removeAttribute(String name) throws DOMException {
        this.element.removeAttribute(name);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return this.element.removeAttributeNode(attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.element.removeAttributeNS(namespaceURI, localName);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.element.setAttribute(name, value);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        return this.element.setAttributeNode(attr);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return this.element.setAttributeNodeNS(attr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.element.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public String getNodeName() {
        return this.element.getNodeName();
    }

    public short getNodeType() {
        return 1;
    }

    public ElementImpl getElement() {
        return this.element;
    }

    public SOAPElement getParentElement() {
        Node parentNode;
        if (this.parentElement == null && (parentNode = this.toSAAJNode(this.element.getParentNode())) instanceof SOAPElement) {
            this.parentElement = (SOAPElement)parentNode;
        }
        return this.parentElement;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        this.parentElement = parent;
        this.element.setParent((OMContainer)((SOAPElementImpl)parent).element);
    }

    public Document getOwnerDocument() {
        return this.element.getOwnerDocument();
    }

    public String getValue() {
        if (this.element.getType() == 4) {
            return this.element.getText();
        }
        if (this.element.getType() == 1) {
            OMNode firstOMChild = this.element.getFirstOMChild();
            if (firstOMChild instanceof TextImpl) {
                return ((TextImpl)firstOMChild).getData();
            }
            if (firstOMChild instanceof SOAPElementImpl) {
                return ((SOAPElementImpl)firstOMChild).getValue();
            }
        }
        return null;
    }

    public org.w3c.dom.Node getFirstChild() {
        return this.toSAAJNode(this.element.getFirstChild());
    }

    public org.w3c.dom.Node getLastChild() {
        return this.toSAAJNode(this.element.getLastChild());
    }

    public org.w3c.dom.Node getParentNode() {
        SOAPElement parentNode = null;
        if (this.parentElement == null) {
            parentNode = this.toSAAJNode(this.element.getParentNode());
            if (parentNode instanceof SOAPElement) {
                this.parentElement = parentNode;
            }
        } else {
            parentNode = this.parentElement;
        }
        return parentNode;
    }

    public org.w3c.dom.Node getNextSibling() {
        return this.toSAAJNode(this.element.getNextSibling());
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return this.toSAAJNode(this.element.getPreviousSibling());
    }

    public NodeList getChildNodes() {
        NodeList childNodes = this.element.getChildNodes();
        NodeListImpl nodes = new NodeListImpl();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            nodes.addNode((org.w3c.dom.Node)this.toSAAJNode(childNodes.item(i)));
        }
        return nodes;
    }

    public boolean hasChildNodes() {
        return this.element.hasChildNodes();
    }

    public void setValue(String value) {
        OMNode firstChild = this.element.getFirstOMChild();
        if (firstChild == null) {
            try {
                this.addTextNode(value);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Cannot add text node", e);
            }
        } else if (((org.w3c.dom.Node)firstChild).getNodeType() == 3 && firstChild.getNextOMSibling() == null) {
            ((Text)firstChild).setData(value);
        } else {
            throw new IllegalStateException("This node is not a Text  node and either has more than one child node or has a child node that is not a Text node");
        }
    }

    public void detachNode() {
        this.detach();
    }

    public OMNode detach() {
        OMNode omNode = this.element.detach();
        this.parentElement = null;
        return omNode;
    }

    public NamedNodeMap getAttributes() {
        return this.element.getAttributes();
    }

    public String toString() {
        return this.element.toString();
    }
}

