/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.AbstractAgent;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminAgent
extends AbstractAgent {
    private static final Log log = LogFactory.getLog((Class)AbstractAgent.class);
    private static final String LIST_SERVICE_GROUP_JSP = "ListServiceGroup.jsp";
    private static final String LIST_SERVICES_JSP_NAME = "listService.jsp";
    private static final String LIST_SINGLE_SERVICES_JSP_NAME = "listSingleService.jsp";
    private static final String SELECT_SERVICE_JSP_NAME = "SelectService.jsp";
    private static final String IN_ACTIVATE_SERVICE_JSP_NAME = "InActivateService.jsp";
    private static final String ACTIVATE_SERVICE_JSP_NAME = "ActivateService.jsp";
    private static final String LIST_PHASES_JSP_NAME = "viewphases.jsp";
    private static final String LIST_GLOABLLY_ENGAGED_MODULES_JSP_NAME = "globalModules.jsp";
    private static final String LIST_AVAILABLE_MODULES_JSP_NAME = "listModules.jsp";
    private static final String ENGAGING_MODULE_TO_SERVICE_JSP_NAME = "engagingtoaservice.jsp";
    private static final String ENGAGING_MODULE_TO_SERVICE_GROUP_JSP_NAME = "EngageToServiceGroup.jsp";
    private static final String ENGAGING_MODULE_GLOBALLY_JSP_NAME = "engagingglobally.jsp";
    public static final String ADMIN_JSP_NAME = "admin.jsp";
    private static final String VIEW_GLOBAL_HANDLERS_JSP_NAME = "ViewGlobalHandlers.jsp";
    private static final String VIEW_SERVICE_HANDLERS_JSP_NAME = "ViewServiceHandlers.jsp";
    private static final String SERVICE_PARA_EDIT_JSP_NAME = "ServiceParaEdit.jsp";
    private static final String ENGAGE_TO_OPERATION_JSP_NAME = "engagingtoanoperation.jsp";
    private static final String LOGIN_JSP_NAME = "Login.jsp";
    private File serviceDir;

    public AdminAgent(ConfigurationContext aConfigContext) {
        super(aConfigContext);
        try {
            if (this.configContext.getAxisConfiguration().getRepository() != null) {
                File repoDir = new File(this.configContext.getAxisConfiguration().getRepository().getFile());
                this.serviceDir = new File(repoDir, "services");
                if (!this.serviceDir.exists()) {
                    this.serviceDir.mkdirs();
                }
            }
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.axisSecurityEnabled() && this.authorizationRequired(httpServletRequest)) {
            this.renderView(LOGIN_JSP_NAME, httpServletRequest, httpServletResponse);
        } else {
            super.handle(httpServletRequest, httpServletResponse);
        }
    }

    protected void processIndex(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.renderView(ADMIN_JSP_NAME, req, res);
    }

    protected void processUpload(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String hasHotDeployment = (String)this.configContext.getAxisConfiguration().getParameterValue("hotdeployment");
        String hasHotUpdate = (String)this.configContext.getAxisConfiguration().getParameterValue("hotupdate");
        req.setAttribute("hotDeployment", (Object)(hasHotDeployment.equals("true") ? "enabled" : "disabled"));
        req.setAttribute("hotUpdate", (Object)(hasHotUpdate.equals("true") ? "enabled" : "disabled"));
        ServletRequestContext reqContext = new ServletRequestContext(req);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)reqContext);
        if (isMultipart) {
            try {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(req);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    String fileName;
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String fileExtesion = fileName = item.getName();
                    if (!(fileExtesion = fileExtesion.toLowerCase()).endsWith(".jar") && !fileExtesion.endsWith(".aar")) {
                        req.setAttribute("status", (Object)"failure");
                        req.setAttribute("cause", (Object)("Unsupported file type " + fileExtesion));
                        continue;
                    }
                    String fileNameOnly = fileName.indexOf("\\") < 0 ? fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length()) : fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length());
                    File uploadedFile = new File(this.serviceDir, fileNameOnly);
                    item.write(uploadedFile);
                    req.setAttribute("status", (Object)"success");
                    req.setAttribute("filename", (Object)fileNameOnly);
                }
            }
            catch (Exception e) {
                req.setAttribute("status", (Object)"failure");
                req.setAttribute("cause", (Object)e.getMessage());
            }
        }
        this.renderView("upload.jsp", req, res);
    }

    protected void processLogin(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String username = req.getParameter("userName");
        String password = req.getParameter("password");
        if (username == null || password == null || username.trim().length() == 0 || password.trim().length() == 0) {
            req.setAttribute("errorMessage", (Object)"Invalid auth credentials!");
            this.renderView(LOGIN_JSP_NAME, req, res);
            return;
        }
        String adminUserName = (String)this.configContext.getAxisConfiguration().getParameter("userName").getValue();
        String adminPassword = (String)this.configContext.getAxisConfiguration().getParameter("password").getValue();
        if (username.equals(adminUserName) && password.equals(adminPassword)) {
            req.getSession().setAttribute("Logged", (Object)"Yes");
            this.renderView(ADMIN_JSP_NAME, req, res);
        } else {
            req.setAttribute("errorMessage", (Object)"Invalid auth credentials!");
            this.renderView(LOGIN_JSP_NAME, req, res);
        }
    }

    protected void processEditServicePara(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String serviceName = req.getParameter("axisService");
        if (req.getParameter("changePara") != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            if (service != null) {
                ArrayList service_para = service.getParameters();
                for (int i = 0; i < service_para.size(); ++i) {
                    Parameter parameter = (Parameter)service_para.get(i);
                    String para = req.getParameter(serviceName + "_" + parameter.getName());
                    service.addParameter(new Parameter(parameter.getName(), para));
                }
                Iterator iterator = service.getOperations();
                while (iterator.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)iterator.next();
                    String op_name = axisOperation.getName().getLocalPart();
                    ArrayList operation_para = axisOperation.getParameters();
                    for (int i = 0; i < operation_para.size(); ++i) {
                        Parameter parameter = (Parameter)operation_para.get(i);
                        String para = req.getParameter(op_name + "_" + parameter.getName());
                        axisOperation.addParameter(new Parameter(parameter.getName(), para));
                    }
                }
            }
            res.setContentType("text/html");
            req.setAttribute("status", (Object)"Parameters Changed Successfully.");
            req.getSession().removeAttribute("service");
        } else {
            AxisService serviceTemp = this.configContext.getAxisConfiguration().getServiceForActivation(serviceName);
            if (serviceTemp.isActive()) {
                if (serviceName != null) {
                    req.getSession().setAttribute("service", (Object)this.configContext.getAxisConfiguration().getService(serviceName));
                }
            } else {
                req.setAttribute("status", (Object)("Service " + serviceName + " is not an active service" + ". \n Only parameters of active services can be edited."));
            }
        }
        this.renderView(SERVICE_PARA_EDIT_JSP_NAME, req, res);
    }

    protected void processEngagingGlobally(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        if (moduleName != null) {
            try {
                this.configContext.getAxisConfiguration().engageModule(moduleName);
                req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged globally successfully"));
            }
            catch (AxisFault axisFault) {
                req.getSession().setAttribute("engagestatus", (Object)axisFault.getMessage());
            }
        }
        req.getSession().setAttribute("modules", null);
        this.renderView(ENGAGING_MODULE_GLOBALLY_JSP_NAME, req, res);
    }

    protected void processListOperations(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("axisService");
        if (serviceName != null) {
            req.getSession().setAttribute("service", (Object)serviceName);
        } else {
            serviceName = (String)req.getSession().getAttribute("service");
        }
        req.getSession().setAttribute("operationmap", (Object)this.configContext.getAxisConfiguration().getService(serviceName).getOperations());
        req.getSession().setAttribute("engagestatus", null);
        String operationName = req.getParameter("axisOperation");
        if (serviceName != null && moduleName != null && operationName != null) {
            try {
                AxisOperation od = this.configContext.getAxisConfiguration().getService(serviceName).getOperation(new QName(operationName));
                od.engageModule(this.configContext.getAxisConfiguration().getModule(moduleName));
                req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged to the operation successfully"));
            }
            catch (AxisFault axisFault) {
                req.getSession().setAttribute("engagestatus", (Object)axisFault.getMessage());
            }
        }
        req.getSession().setAttribute("operation", null);
        this.renderView(ENGAGE_TO_OPERATION_JSP_NAME, req, res);
    }

    protected void processEngageToService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        this.populateSessionInformation(req);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("axisService");
        req.getSession().setAttribute("engagestatus", null);
        if (serviceName != null && moduleName != null) {
            try {
                this.configContext.getAxisConfiguration().getService(serviceName).engageModule(this.configContext.getAxisConfiguration().getModule(moduleName));
                req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged to the service successfully"));
            }
            catch (AxisFault axisFault) {
                req.getSession().setAttribute("engagestatus", (Object)axisFault.getMessage());
            }
        }
        req.getSession().setAttribute("axisService", null);
        this.renderView(ENGAGING_MODULE_TO_SERVICE_JSP_NAME, req, res);
    }

    protected void processEngageToServiceGroup(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        Iterator services = this.configContext.getAxisConfiguration().getServiceGroups();
        req.getSession().setAttribute("serviceGroupmap", (Object)services);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("axisService");
        req.getSession().setAttribute("engagestatus", null);
        if (serviceName != null && moduleName != null) {
            this.configContext.getAxisConfiguration().getServiceGroup(serviceName).engageModule(this.configContext.getAxisConfiguration().getModule(moduleName));
            req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged to the service group successfully"));
        }
        req.getSession().setAttribute("axisService", null);
        this.renderView(ENGAGING_MODULE_TO_SERVICE_GROUP_JSP_NAME, req, res);
    }

    protected void processLogout(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.getSession().invalidate();
        this.renderView("index.jsp", req, res);
    }

    protected void processviewServiceGroupConetxt(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String type = req.getParameter("TYPE");
        String sgID = req.getParameter("ID");
        ServiceGroupContext sgContext = this.configContext.getServiceGroupContext(sgID);
        req.getSession().setAttribute("ServiceGroupContext", (Object)sgContext);
        req.getSession().setAttribute("TYPE", (Object)type);
        req.getSession().setAttribute("ConfigurationContext", (Object)this.configContext);
        this.renderView("viewServiceGroupContext.jsp", req, res);
    }

    protected void processviewServiceContext(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String type = req.getParameter("TYPE");
        String sgID = req.getParameter("PID");
        String ID = req.getParameter("ID");
        ServiceGroupContext sgContext = this.configContext.getServiceGroupContext(sgID);
        if (sgContext != null) {
            AxisService service = sgContext.getDescription().getService(ID);
            ServiceContext serviceContext = sgContext.getServiceContext(service);
            req.setAttribute("ServiceContext", (Object)serviceContext);
            req.setAttribute("TYPE", (Object)type);
        } else {
            req.setAttribute("ServiceContext", null);
            req.setAttribute("TYPE", (Object)type);
        }
        this.renderView("viewServiceContext.jsp", req, res);
    }

    protected void processSelectServiceParaEdit(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"SERVICE_PARAMETER");
        this.renderView(SELECT_SERVICE_JSP_NAME, req, res);
    }

    protected void processListOperation(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"MODULE");
        this.renderView(SELECT_SERVICE_JSP_NAME, req, res);
    }

    protected void processActivateService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (req.getParameter("submit") != null) {
            String serviceName = req.getParameter("axisService");
            String turnon = req.getParameter("turnon");
            if (serviceName != null && turnon != null) {
                this.configContext.getAxisConfiguration().startService(serviceName);
            }
        }
        this.populateSessionInformation(req);
        this.renderView(ACTIVATE_SERVICE_JSP_NAME, req, res);
    }

    protected void processDeactivateService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (req.getParameter("submit") != null) {
            String serviceName = req.getParameter("axisService");
            String turnoff = req.getParameter("turnoff");
            if (serviceName != null) {
                if (turnoff != null) {
                    this.configContext.getAxisConfiguration().stopService(serviceName);
                }
                this.populateSessionInformation(req);
            }
        } else {
            this.populateSessionInformation(req);
        }
        this.renderView(IN_ACTIVATE_SERVICE_JSP_NAME, req, res);
    }

    protected void processViewGlobalHandlers(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.getSession().setAttribute("axisconfig", (Object)this.configContext.getAxisConfiguration());
        this.renderView(VIEW_GLOBAL_HANDLERS_JSP_NAME, req, res);
    }

    protected void processViewServiceHandlers(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String service = req.getParameter("axisService");
        if (service != null) {
            req.getSession().setAttribute("serviceHandlers", (Object)this.configContext.getAxisConfiguration().getService(service));
        }
        this.renderView(VIEW_SERVICE_HANDLERS_JSP_NAME, req, res);
    }

    protected void processListPhases(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        PhasesInfo info = this.configContext.getAxisConfiguration().getPhasesInfo();
        req.getSession().setAttribute("phaseList", (Object)info);
        this.renderView(LIST_PHASES_JSP_NAME, req, res);
    }

    protected void processListServiceGroups(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Iterator serviceGroups = this.configContext.getAxisConfiguration().getServiceGroups();
        this.populateSessionInformation(req);
        req.getSession().setAttribute("serviceGroupmap", (Object)serviceGroups);
        this.renderView(LIST_SERVICE_GROUP_JSP, req, res);
    }

    protected void processListService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("errprservicemap", (Object)this.configContext.getAxisConfiguration().getFaultyServices());
        this.renderView(LIST_SERVICES_JSP_NAME, req, res);
    }

    protected void processListSingleService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.getSession().setAttribute("Fault", (Object)"");
        String serviceName = req.getParameter("serviceName");
        if (serviceName != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            req.getSession().setAttribute("singleservice", (Object)service);
        }
        this.renderView(LIST_SINGLE_SERVICES_JSP_NAME, req, res);
    }

    protected void processListContexts(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.getSession().setAttribute("config_context", (Object)this.configContext);
        this.renderView("ViewContexts.jsp", req, res);
    }

    protected void processglobalModules(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Collection modules = this.configContext.getAxisConfiguration().getEngagedModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        this.renderView(LIST_GLOABLLY_ENGAGED_MODULES_JSP_NAME, req, res);
    }

    protected void processListModules(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        req.getSession().setAttribute("errormodulesmap", (Object)this.configContext.getAxisConfiguration().getFaultyModules());
        this.renderView(LIST_AVAILABLE_MODULES_JSP_NAME, req, res);
    }

    protected void processdisengageModule(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String type = req.getParameter("type");
        String serviceName = req.getParameter("serviceName");
        String moduleName = req.getParameter("module");
        AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
        AxisService service = axisConfiguration.getService(serviceName);
        AxisModule module = axisConfiguration.getModule(moduleName);
        if (type.equals("operation")) {
            if (service.isEngaged(module.getName()) || axisConfiguration.isEngaged(module.getName())) {
                req.getSession().setAttribute("status", (Object)("Can not disengage module " + moduleName + ". This module is engaged at a higher level."));
            } else {
                String opName = req.getParameter("operation");
                AxisOperation op = service.getOperation(new QName(opName));
                op.disengageModule(module);
                req.getSession().setAttribute("status", (Object)("Module " + moduleName + " was disengaged from " + "operation " + opName + " in service " + serviceName + "."));
            }
        } else if (axisConfiguration.isEngaged(module.getName())) {
            req.getSession().setAttribute("status", (Object)("Can not disengage module " + moduleName + ". " + "This module is engaged at a higher level."));
        } else {
            service.disengageModule(axisConfiguration.getModule(moduleName));
            req.getSession().setAttribute("status", (Object)("Module " + moduleName + " was disengaged from" + " service " + serviceName + "."));
        }
        this.renderView("disengage.jsp", req, res);
    }

    protected void processSelectService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"VIEW");
        this.renderView(SELECT_SERVICE_JSP_NAME, req, res);
    }

    private boolean authorizationRequired(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getSession().getAttribute("Logged") == null && !httpServletRequest.getRequestURI().endsWith("login");
    }

    private boolean axisSecurityEnabled() {
        Parameter parameter = this.configContext.getAxisConfiguration().getParameter("disableAdminSecurity");
        return parameter == null || !"true".equals(parameter.getValue());
    }
}

