/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.mail.server.MailAddress;
import org.apache.axis2.transport.mail.server.MailSorter;
import org.apache.axis2.transport.mail.server.Storage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMTPWorker
extends Thread {
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private boolean transmitionEnd = false;
    private String temp = "";
    private Storage st = null;
    boolean runThread = true;
    private ArrayList receivers = new ArrayList();
    private MimeMessage mail = null;
    private static final Log log = LogFactory.getLog((Class)SMTPWorker.class);
    private boolean dataWriting = false;
    private ConfigurationContext configurationContext = null;
    private boolean bodyData = false;
    private boolean actAsMailet = false;

    public SMTPWorker(Socket socket, Storage st) {
        this.doWork(socket, st, null);
    }

    public SMTPWorker(Socket socket, Storage st, ConfigurationContext configurationContext) {
        this.doWork(socket, st, configurationContext);
    }

    private void doWork(Socket socket, Storage st, ConfigurationContext configurationContext) {
        try {
            this.st = st;
            if (configurationContext == null) {
                this.actAsMailet = false;
            } else {
                this.configurationContext = configurationContext;
                this.actAsMailet = true;
            }
            this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        }
        catch (IOException ex) {
            log.info((Object)ex.getMessage());
        }
    }

    private void exitWorker() throws IOException {
        this.reader.close();
        this.writer.close();
        this.runThread = false;
    }

    private void initializeClient() throws IOException {
        if (this.writer != null) {
            this.send("220 SMTP Server IS UP");
        }
    }

    private String processInput(String input) {
        if (input == null) {
            return "550 Unknown command";
        }
        if (this.mail != null && this.transmitionEnd) {
            return "221 Closing SMTP service.";
        }
        if (input.startsWith("MAIL")) {
            int end;
            this.mail = new MimeMessage(Session.getInstance((Properties)new Properties(), (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return null;
                }
            }));
            int start = input.indexOf("<") + 1;
            if (start <= 0) {
                start = input.indexOf("FROM:") + 5;
                end = input.length();
            } else {
                end = input.indexOf(">");
            }
            String from = input.substring(start, end);
            if (from != null && from.trim().length() != 0) {
                Address[] mailFrom = new MailAddress[]{new MailAddress(from)};
                try {
                    this.mail.addFrom(mailFrom);
                }
                catch (MessagingException e) {
                    log.info((Object)e.getMessage());
                }
            }
            return "250 OK performed command MAIL";
        }
        if (input.startsWith("HELO")) {
            return "250 OK";
        }
        if (input.startsWith("RCPT")) {
            int start = input.indexOf("<") + 1;
            if (start <= 0) {
                start = input.indexOf("TO:") + 3;
            }
            int end = input.indexOf(">");
            String toStr = input.substring(start, end);
            try {
                this.mail.addRecipient(Message.RecipientType.TO, (Address)new MailAddress(toStr));
                this.receivers.add(toStr);
            }
            catch (MessagingException e) {
                log.info((Object)e.getMessage());
            }
            return "250 OK performed command RCPT";
        }
        if (input.equalsIgnoreCase("DATA")) {
            this.dataWriting = true;
            return "354 OK Ready for data";
        }
        if (input.equalsIgnoreCase("QUIT")) {
            this.dataWriting = true;
            this.transmitionEnd = true;
            return "221 Closing SMTP service.";
        }
        if (input.equals(".")) {
            this.dataWriting = false;
            return "250 OK finished adding data";
        }
        if (input.length() == 0 && !this.bodyData) {
            this.bodyData = true;
            return null;
        }
        if (this.mail != null && this.dataWriting) {
            try {
                if (this.bodyData) {
                    this.temp = this.temp + input;
                    this.mail.setContent((Object)this.temp, "text/xml");
                } else {
                    this.mail.addHeaderLine(input);
                }
            }
            catch (MessagingException e) {
                log.info((Object)e.getMessage());
            }
            return null;
        }
        return "550 Unknown command";
    }

    public void run() {
        try {
            this.initializeClient();
            while (this.runThread) {
                String input = null;
                input = this.reader.readLine();
                String retString = this.processInput(input);
                if ("EXIT".equals(retString)) {
                    this.exitWorker();
                    continue;
                }
                if (retString != null) {
                    this.send(retString);
                }
                if (this.mail == null || !this.transmitionEnd) continue;
                this.exitWorker();
            }
            for (int idx = 0; idx < this.receivers.size(); ++idx) {
                try {
                    MailSorter mSort = null;
                    mSort = this.actAsMailet ? new MailSorter(this.st, this.configurationContext) : new MailSorter(this.st, null);
                    mSort.sort((String)this.receivers.get(idx), new MimeMessage(this.mail));
                    continue;
                }
                catch (MessagingException e1) {
                    log.info((Object)e1.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.info((Object)"ERROR: CLIENT CLOSED THE SOCKET");
        }
    }

    private void send(String s) throws IOException {
        this.writer.write(s);
        this.writer.newLine();
        this.writer.flush();
    }
}

