/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.ScheduleAuthorityFormData;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュールの公開設定・秘書設定を処理するクラスです。 <br />
 * 
 */
public class ScheduleAuthorityFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ScheduleAuthorityFormScreen.class
      .getName());

  /**
   * スケジュールの公開設定・秘書設定画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      doScheduleAuthority_form(rundata, context);
    } catch (Exception ex) {
      logger.error("[ScheduleAuthorityFormScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  /**
   * スケジュールの公開設定・秘書設定画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   */
  protected void doScheduleAuthority_form(RunData rundata, Context context) {

    ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);
    List<UserGroupPositionLiteBean> list =
      UserUtils.getPostPositionBeanList((int) loginuser.getUserId().getValue());
    if (list != null && list.size() > 0) {
      UserGroupPositionLiteBean b = list.get(0);
      String current_parent_group_name = b.getPost1GroupName();
      String current_group_name = b.getPost2GroupName();
      context.put("current_group_name", current_group_name);
      context.put("current_parent_group_name", current_parent_group_name);
    }

    ScheduleAuthorityFormData formData = new ScheduleAuthorityFormData();
    formData.initField();
    formData.doViewForm(this, rundata, context);

    String layout_template = "portlets/html/ja/ajax-schedule-authority-form.vm";
    setTemplate(rundata, context, layout_template);
  }
}
